/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ExportBitmapServlet.java 4798 2009-08-07 12:30:47Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.servlet;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ExportBitmapServlet extends HttpServlet {

    /**
     *
     */
    private static final long serialVersionUID = -2206914885991825110L;

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(ExportBitmapServlet.class);

    @Override
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        logger.debug("request done");
        doDownload(request, response);
    }

    @Override
    public void doPost(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        logger.debug("request done");
        doDownload(request, response);
    }

    private void doDownload(final HttpServletRequest req, final HttpServletResponse resp) throws IOException {
        String fileId = req.getParameter("fileId");
        logger.debug("fileId={0}", fileId);
        File f = new File(fileId);
        ServletOutputStream op = resp.getOutputStream();

        resp.setContentType("image/png");
        resp.setContentLength((int) f.length());

        byte[] bbuf = new byte[2048];
        DataInputStream in = new DataInputStream(new FileInputStream(f));

        int length = 0;
        while ((in != null) && ((length = in.read(bbuf)) != -1)) {
            op.write(bbuf, 0, length);
        }

        in.close();
        op.flush();
        op.close();
    }

}
