/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineMessageEvent.java 4798 2009-08-07 12:30:47Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.jms.event;

import java.text.SimpleDateFormat;
import java.util.Date;


public class JasmineMessageEvent {

    public JasmineMessageEvent() {

    }


    // Getters
    /**
     * @return the domain
     */
    public String getDomain() {
        return domain;
    }

    /**
     * @return the server
     */
    public String getServer() {
        return server;
    }

    /**
     * @return the source
     */
    public String getSource() {
        return source;
    }

    /**
     * @return the probe
     */
    public String getProbe() {
        return probe;
    }

    /**
     * @return the csvFormat
     */
    public String getCsvFormat() {
        return csvFormat;
    }

    /**
     * @return the value
     */
    public String getValue() {
        return value;
    }

    /**
     * @return the timestamp
     */
    public long getTimestamp() {
        return timestamp;
    }

    /**
     * @return the sname
     */
    public String getSname() {
        return sname;
    }

    /**
     * @return the formattedTimeStamp
     */
    public String getFormattedTimeStamp() {
        return formattedTimeStamp;
    }


    // setters
    /**
     * @param domain the domain to set
     */
    public void setDomain(final String domain) {
        this.domain = domain;
    }

    /**
     * @param server the server to set
     */
    public void setServer(final String server) {
        this.server = server;
    }

    /**
     * @param source the source to set
     */
    public void setSource(final String source) {
        this.source = source;
    }

    /**
     * @param probe the probe to set
     */
    public void setProbe(final String probe) {
        this.probe = probe;
    }

    /**
     * @param csvFormat the csvFormat to set
     */
    public void setCsvFormat(final String csvFormat) {
        this.csvFormat = csvFormat;
    }

    /**
     * @param value the value to set
     */
    public void setValue(final String value) {
        this.value = value;
    }

    /**
     * @param timestamp the timestamp to set
     */
    public void setTimestamp(final long timestamp) {
        this.timestamp = timestamp;
        this.formattedTimeStamp = simpleDateFormat.format(new Date(this.timestamp));
    }

    /**
     * @param formattedTimeStamp the formattedTimeStamp to set
     */
    public void setFormattedTimeStamp(final String formattedTimeStamp) {
        this.formattedTimeStamp = formattedTimeStamp;
    }

    /**
     * @param sname the sname to set
     */
    public void setSname(final String sname) {
        this.sname = sname;
    }

    // datas
    /**
     * Domain of the probed server.
     */
    private String domain;

    /**
     * Name of the probed server.
     */
    private String server;

    /**
     * Event source (for example, MBeanCmd or JMX).
     */
    private String source;

    /**
     * Probe type.
     */
    private String probe;

    /**
     * Probed value.
     */
    private String value;

    /**
     * Probe time (precise up to a second).
     */
    private long timestamp;

    /**
     * Formatted timestamp : yyyy/MM/dd HH:mm:ss .
     */
    private String formattedTimeStamp;

    /**
     * JMX url of the probe.
     */
    private String sname;

    /**
     * Pattern value.
     */
    private String csvFormat;

    /**
     * Timestamp formatter
     */
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");


}
