/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.common.jms;

import java.io.Serializable;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.event.messages.JasmineEvent;
import org.ow2.jasmine.event.messages.JasmineEventDetails;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.event.JasmineMessageEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSMessageListener
implements MessageListener,
Serializable {
    private EventManager<JasmineMessageEvent> manager = null;
    public static String currentMessage = "";

    public JMSMessageListener(EventManager<JasmineMessageEvent> evManager) {
        this.manager = evManager;
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                message.acknowledge();
                ObjectMessage om = (ObjectMessage)message;
                Serializable jasmineEventObject = om.getObject();
                if (jasmineEventObject instanceof JasmineEvent) {
                    JasmineEvent event = (JasmineEvent)jasmineEventObject;
                    String result = "";
                    String split = ";";
                    String domain = event.getDomain();
                    String server = event.getServer();
                    List eventDetailsList = event.getEvents();
                    result = result + ((JasmineEventDetails)eventDetailsList.get(0)).getTimestamp().getTime() + split + ((JasmineEventDetails)eventDetailsList.get(0)).getTimestamp() + split + ((JasmineEventDetails)eventDetailsList.get(0)).getSname() + split + domain + split + server + split + ((JasmineEventDetails)eventDetailsList.get(0)).getProbe() + split;
                    for (JasmineEventDetails ed : event.getEvents()) {
                        JasmineMessageEvent ev = new JasmineMessageEvent();
                        ev.setDomain(domain);
                        ev.setServer(server);
                        ev.setProbe(ed.getProbe());
                        ev.setSource(ed.getSource());
                        ev.setTimestamp(ed.getTimestamp().getTime());
                        ev.setSname(ed.getSname());
                        ev.setValue(ed.getValue());
                        result = result + ed.getValue() + split;
                        ev.setCsvFormat(result);
                        this.manager.add(ev);
                    }
                } else if (jasmineEventObject instanceof JasmineEventEB) {
                    JasmineEventEB jasmineEventEB = (JasmineEventEB)jasmineEventObject;
                    JasmineMessageEvent ev = new JasmineMessageEvent();
                    ev.setDomain(jasmineEventEB.getDomain());
                    ev.setServer(jasmineEventEB.getServer());
                    ev.setProbe(jasmineEventEB.getProbe());
                    ev.setSource(jasmineEventEB.getSource());
                    ev.setTimestamp(jasmineEventEB.getTimestamp().getTime());
                    ev.setSname(jasmineEventEB.getSname());
                    Serializable value = jasmineEventEB.getValue();
                    if (value != null) {
                        ev.setValue(value.toString());
                    }
                    this.manager.add(ev);
                }
            }
        }
        catch (Throwable t) {
            System.err.println(t instanceof JMSException ? "JMSException" : "Throwable Caught in onMessage(): " + t.getMessage());
            t.printStackTrace();
        }
    }
}

