/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.common.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadFileServlet
extends HttpServlet {
    private static final long serialVersionUID = -4729955174780787192L;
    private final String tempDir = System.getProperty("java.io.tmpdir") + File.separatorChar + "EoS.temp";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            res.setContentType("text/xml");
            ServletOutputStream out = res.getOutputStream();
            out.println("<response>");
            List<FileItem> fI = this.getFileItems(req);
            if (fI == null) {
                ServletInputStream stream = req.getInputStream();
                int bufferSize = 1000;
                File file = new File(this.tempDir + System.currentTimeMillis() + ".png");
                FileOutputStream fileOutStream = new FileOutputStream(file);
                byte[] buffer = new byte[1000];
                int readCount = 0;
                while ((readCount = stream.read(buffer)) != -1) {
                    if (readCount < 1000) {
                        fileOutStream.write(buffer, 0, readCount);
                        continue;
                    }
                    fileOutStream.write(buffer);
                }
                fileOutStream.flush();
                fileOutStream.close();
                out.println("<file name=\"" + file.getAbsolutePath() + "\" size=\"" + file.length() + "\" />");
            } else {
                for (FileItem item : fI) {
                    if (item.isFormField()) {
                        out.println("<field name=\"" + item.getFieldName() + "\"value=\"" + item.getString() + "\" />");
                        continue;
                    }
                    File file = new File(this.tempDir);
                    file.mkdirs();
                    file = new File(file, item.getName());
                    item.write(file);
                    out.println("<file name=\"" + file.getAbsolutePath() + "\" size=\"" + item.getSize() + "\" />");
                }
            }
            out.println("</response>");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    protected List<FileItem> getFileItems(HttpServletRequest req) throws FileUploadException {
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload(factory);
            return upload.parseRequest(req);
        }
        catch (Exception e) {
            return null;
        }
    }
}

