/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: EventManager.java 5982 2010-01-19 14:16:05Z alitokmen $
 */
package org.ow2.jasmine.monitoring.eos.common;

import java.io.Serializable;
import java.util.List;

/**
 * @author Jean-Pierre Poutcheu
 * @param <T> Type of message event
 */
public interface EventManager<T> extends Serializable {

    /**
     * Add an event.
     *
     * @param event the event to add.
     */
    void add(final T event);

    /**
     * Get the entire queue of waiting events.
     *
     * @return the queue of events.
     */
    List<T> getAll();
}
