/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JMSMessageListener.java 5966 2010-01-19 09:42:37Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.jms;

import java.io.Serializable;
import java.util.List;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.event.messages.JasmineEvent;
import org.ow2.jasmine.event.messages.JasmineEventDetails;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.event.JasmineMessageEvent;

public class JMSMessageListener implements MessageListener, Serializable {

    private EventManager<JasmineMessageEvent> manager = null;

    public JMSMessageListener(final EventManager<JasmineMessageEvent> evManager) {
        super();
        this.manager = evManager;

    }

    public void onMessage(final Message message) {
        try {
            if (message instanceof ObjectMessage) {

                message.acknowledge();

                ObjectMessage om = (ObjectMessage) message;
                Object jasmineEventObject = om.getObject();

                if(jasmineEventObject instanceof JasmineEvent) {
                    JasmineEvent event = (JasmineEvent) jasmineEventObject;

                    String result = "";
                    String split = ";";

                    String domain = event.getDomain();
                    String server = event.getServer();

                    List<JasmineEventDetails> eventDetailsList = event.getEvents();

                    result = result + eventDetailsList.get(0).getTimestamp().getTime() + split
                    + eventDetailsList.get(0).getTimestamp() + split
                    + eventDetailsList.get(0).getSname() + split
                    + domain + split
                    + server + split
                    + eventDetailsList.get(0).getProbe() + split;

                    for (JasmineEventDetails ed : event.getEvents()) {
                        JasmineMessageEvent ev = new JasmineMessageEvent();
                        ev.setDomain(domain);
                        ev.setServer(server);
                        ev.setProbe(ed.getProbe());
                        ev.setSource(ed.getSource());
                        ev.setTimestamp(ed.getTimestamp().getTime());
                        ev.setSname(ed.getSname());
                        ev.setValue(ed.getValue());
                        result += ed.getValue() + split;
                        ev.setCsvFormat(result);

                        this.manager.add(ev);

                    }
                } else if (jasmineEventObject instanceof JasmineEventEB) {
                    JasmineEventEB jasmineEventEB = (JasmineEventEB) jasmineEventObject;
                    JasmineMessageEvent ev = new JasmineMessageEvent();
                    ev.setDomain(jasmineEventEB.getDomain());
                    ev.setServer(jasmineEventEB.getServer());
                    ev.setProbe(jasmineEventEB.getProbe());
                    ev.setSource(jasmineEventEB.getSource());
                    ev.setTimestamp(jasmineEventEB.getTimestamp().getTime());
                    ev.setSname(jasmineEventEB.getSname());
                    Serializable value = jasmineEventEB.getValue();
                    if(value != null) {
                        ev.setValue(value.toString());
                    }
                    this.manager.add(ev);
                }
            }

        } catch (Throwable t) {
            System.err.println((t instanceof JMSException) ? "JMSException" : "Throwable" + " Caught in onMessage(): "
                    + t.getMessage() );
            t.printStackTrace();
        }
    }

    public static String currentMessage = "";

}
