/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: InitServlet.java 5920 2010-01-14 13:45:06Z fornacif $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.servlet;

import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventPurgeTaskSLBRemote;

/**
 * A servlet that calls some Session Beans at statup
 * @author Francois Fornaciari
 */
public class InitServlet extends HttpServlet {

    /**
     * Class version ID
     */
    private static final long serialVersionUID = -2206914885991825110L;


    @EJB(mappedName = "db-ejb/purgetask")
    JasmineEventPurgeTaskSLBRemote jasmineEventPurgeTaskSLBRemote = null;

    @Override
    public void init() throws ServletException {
        super.init();
        jasmineEventPurgeTaskSLBRemote.activatePeriodicPurgeTasks();
    }
}
