/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.osgi;

import javax.naming.InitialContext;

import org.osgi.framework.BundleContext;

/**
 * Provides help to manage/communicate with the OSGi framework
 *
 * @author Julien Nicoulaud
 * @see {@link IOSGiManager}
 */
public class OSGiManager implements IOSGiManager{

	// -------------------------------------------------------------------------
	// Variables
	// -------------------------------------------------------------------------

	/**
	 * JNDI bundleContext binding
	 */
	public static final String BUNDLE_CONTEXT = "java:comp/env/BundleContext";

	/**
	 * JNDI Naming context
	 */
	private InitialContext namingContext = null;

	/**
	 * Bundle context that will be injected by the container.
	 */
	private BundleContext bundleContext = null;


	// -------------------------------------------------------------------------
	// Constructors
	// -------------------------------------------------------------------------

	/**
	 * Build a new OSGi manager
	 */
	public OSGiManager() {
	}


	// -------------------------------------------------------------------------
	// Implementation of IOSGiManager
	// -------------------------------------------------------------------------

	/**
	 * Get the OSGi bundleContext
	 *
	 * @return the BundleContext object
	 * @throws Exception if it could not be retrieved
	 */
	public BundleContext getBundleContext() throws Exception {
		if(bundleContext == null) {
			try{
				retrieveBundleContext();
			} catch (Exception e) {
				throw(new Exception("Could not retrieve BundleContext",e));
			}
		}
		return bundleContext;
	}


	// -------------------------------------------------------------------------
	// Private methods
	// -------------------------------------------------------------------------

    /**
	 * Retrieve OSGi bundle context with a JNDI lookup.
	 * FIXME introduces a high coupling with JOnAS
	 *
	 * @throws Exception if the JNDI lookup failed
	 */
	private void retrieveBundleContext() throws Exception {
		namingContext = new InitialContext();
		try {
			bundleContext = (BundleContext) namingContext.lookup(BUNDLE_CONTEXT);
		} catch (Exception e) {
			throw(new Exception("Could not lookup BundleContext",e));
		}
	}

}
