/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.servlet;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * A servlet that prepare a file hosted by the server given its path on the server
 *
 * @author Guillaume Renault
 */
public class PrepareDownloadFileServlet extends HttpServlet {

    /**
     *
     */
    private static final long serialVersionUID = 1336894628770462349L;

    /**
     * Logger
     */
    private static Log logger = LogFactory.getLog(PrepareDownloadFileServlet.class);

    /**
     * Handle GET requests
     */
    @Override
    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        doPost(request, response);
    }

    /**
     * Handle POST requests
     */
    @Override
    public void doPost(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        logger.debug("request done");
        prepare(request, response);
    }

    /**
     * Send the information about the file.
     *
     * @param req the {@link HttpServletRequest}
     * @param resp the {@link HttpServletResponse}
     * @throws IOException if something went wrong reading the file
     */
    private void prepare(final HttpServletRequest req, final HttpServletResponse res) throws IOException {
     // Set a response content type
        res.setContentType("text/xml");

        // Setup the output stream for the return XML data
        ServletOutputStream out = res.getOutputStream();
        out.println("<response>");

        File file = new File(req.getParameter("file"));


        // Send back the reference of the archive
        out.println("<file " +
                         "path=\"" + file.getAbsolutePath() + "\" " +
                         "name=\"" + file.getName() + "\" " +
                         "size=\"" + file.length()/1024 + "\" " +
                    "/>");


        // Close off the response XML data and stream
        out.println("</response>");
        out.close();
    }

}
