/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/**
 * A servlet that allows the client to upload a file on the server.
 *
 * @author Guillaume Renault
 */
public class UploadFileServlet extends HttpServlet {

    private static final long serialVersionUID = -4729955174780787192L;

    private final String tempDir = System.getProperty("java.io.tmpdir") + File.separatorChar + "EoS.temp";

    @Override
    protected void doGet(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        doPost(req, resp);
    }
    @Override
    protected void doPost(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        try {
            // Parse the incoming HTTP request
            // Commons takes over incoming request at this point
            // Get an iterator for all the data that was sent

            // Set a response content type
            res.setContentType("text/xml");

            // Setup the output stream for the return XML data
            ServletOutputStream out = res.getOutputStream();
            out.println("<response>");

            List<FileItem> fI = getFileItems(req);

            if (fI == null) {
                ServletInputStream stream = req.getInputStream();

                final int bufferSize = 1000;
                File file = new File(this.tempDir + System.currentTimeMillis() + ".png");
                FileOutputStream fileOutStream = new FileOutputStream(file);

                byte[] buffer = new byte[bufferSize];
                int readCount = 0;
                while ((readCount = stream.read(buffer)) != -1) {
                  if (readCount < bufferSize) {
                    fileOutStream.write(buffer, 0, readCount);
                  } else {
                    fileOutStream.write(buffer);
                  }
                }

                fileOutStream.flush();
                fileOutStream.close();

                out.println("<file name=\"" + file.getAbsolutePath() + "\" size=\"" + file.length() + "\" />");
            } else {
                for (FileItem item : fI) {
                    if (item.isFormField()) {
                        // If the current item is an HTML form field
                        // return an XML node with the field name and value
                        out.println("<field name=\"" + item.getFieldName() + "\"value=\"" + item.getString() + "\" />");
                    } else {
                        // Else the current item is file data,
                        // write the file data to disk
                        File file = new File(this.tempDir);
                        file.mkdirs();
                        file = new File(file, item.getName());
                        item.write(file);

                        // Return an XML node with the file name and size (in bytes)
                        out.println("<file name=\"" + file.getAbsolutePath() + "\" size=\"" + item.getSize() + "\" />");
                    }
                }

            }

            // Close off the response XML data and stream
            out.println("</response>");
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
            throw new ServletException(e);
        }
    }

    @SuppressWarnings("unchecked")
    protected List<FileItem> getFileItems(final HttpServletRequest req) throws FileUploadException {
        try {
            FileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload(factory);
            return upload.parseRequest(req);
        } catch (Exception e) {
            return null;
        }

    }
}
