/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.common.jms;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.JMSMessageListener;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JMSConnection
implements Serializable {
    public static final String CONNECTION_FACTORY = "JCF";
    private Log logger = LogFactory.getLog(this.getClass());
    protected Topic topic = null;
    protected Connection connection = null;
    protected Session session = null;
    protected MessageConsumer subscriber = null;
    private ConnectionInformation information = new ConnectionInformation();

    public JMSConnection(EventManager evManager) {
        this.information.manager = evManager;
    }

    public void connect(String topicName) throws Exception {
        this.connect(topicName, new JMSMessageListener(this.information.manager));
    }

    public <SML extends MessageListener, Serializable> void connect(String topicName, SML listener) throws Exception {
        this.logger.debug((Object)"", new Object[0]);
        InitialContext context = new InitialContext();
        Object o = context.lookup(CONNECTION_FACTORY);
        ConnectionFactory tcf = (ConnectionFactory)o;
        this.topic = (Topic)context.lookup(topicName);
        this.connection = tcf.createConnection();
        this.session = this.connection.createSession(false, 2);
        this.subscriber = this.session.createConsumer((Destination)this.topic);
        this.subscriber.setMessageListener(listener);
        this.connection.start();
        this.information.topicName = topicName;
        this.information.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendObjectMessage(Serializable object) throws Exception {
        if (this.connection == null) {
            throw new JMSException("Not connected!");
        }
        this.logger.debug((Object)"", new Object[0]);
        Session session = this.connection.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)this.topic);
        try {
            ObjectMessage m = session.createObjectMessage(object);
            producer.send((Message)m);
        }
        finally {
            producer.close();
            session.close();
            producer = null;
            session = null;
            System.gc();
        }
    }

    public void disconnect() throws Exception {
        this.logger.debug((Object)"", new Object[0]);
        if (this.connection != null) {
            this.subscriber.close();
            this.session.close();
            this.connection.close();
            this.connection = null;
            this.session = null;
            this.topic = null;
            this.subscriber = null;
            this.information.topicName = null;
            this.information.listener = null;
            System.gc();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.information);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.information = (ConnectionInformation)in.readObject();
            if (this.information.topicName != null && this.information.listener != null) {
                this.connect(this.information.topicName, this.information.listener);
            } else {
                this.information.topicName = null;
                this.information.listener = null;
            }
        }
        catch (Throwable t) {
            IOException ioe = new IOException("Cannot read object");
            ioe.initCause(t);
            throw ioe;
        }
    }

    private class ConnectionInformation
    implements Serializable {
        private EventManager manager = null;
        private String topicName = null;
        private MessageListener listener = null;

        private ConnectionInformation() {
        }
    }
}

