/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.common.jndilocator;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.jasmine.monitoring.eos.common.jndilocator.ServiceLocatorException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ServiceLocator {
    private static final Log LOGGER = LogFactory.getLog(ServiceLocator.class);
    private Context initialContext;
    private Map<String, Object> cache;
    private static final ServiceLocator instance = new ServiceLocator();

    public static ServiceLocator getInstance() {
        return instance;
    }

    private ServiceLocator() throws ServiceLocatorException {
        try {
            this.initialContext = this.getInitialContext();
            this.cache = new HashMap<String, Object>();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error starting ServiceLocator", new Object[]{e});
            throw new ServiceLocatorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getInitialContext() throws ServiceLocatorException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            InitialContext initialContext = new InitialContext();
            Thread.currentThread().setContextClassLoader(old);
            return initialContext;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(old);
                throw throwable;
            }
            catch (NamingException ne) {
                LOGGER.error((Object)"Error getting Initial Context", new Object[]{ne});
                throw new ServiceLocatorException(ne);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getInitialContext(String url) throws ServiceLocatorException {
        Properties h = new Properties();
        h.put("java.naming.factory.initial", "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory");
        h.put("java.naming.provider.url", url);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            InitialContext initialContext = new InitialContext(h);
            Thread.currentThread().setContextClassLoader(old);
            return initialContext;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(old);
                throw throwable;
            }
            catch (NamingException ne) {
                LOGGER.error((Object)"Error getting Initial Context", new Object[]{ne});
                throw new ServiceLocatorException(ne);
            }
        }
    }

    public synchronized Object getRemoteObject(String jndiName) throws ServiceLocatorException {
        Object remoteObject = this.cache.get(jndiName);
        if (remoteObject == null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                remoteObject = this.initialContext.lookup(jndiName);
                this.cache.put(jndiName, remoteObject);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error getting remote object", new Object[]{e});
                throw new ServiceLocatorException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        return remoteObject;
    }
}

