/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.mbeancmdmanager.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.monitoring.eos.mbeancmdmanager.service.exceptions.MBeanCmdManagerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanCmdManager
implements Serializable {
    private static final long serialVersionUID = 48822901471540481L;
    private transient MBeanServerConnection mbscnx = null;

    private boolean connect(String jmxUrl) {
        System.out.println("Connecting to : " + jmxUrl + "...");
        try {
            JMXServiceURL url = new JMXServiceURL(jmxUrl);
            JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
            this.mbscnx = jmxc.getMBeanServerConnection();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String newCommand(String command, String jmxUrl) throws MBeanCmdManagerException {
        if (!this.connect(jmxUrl)) {
            throw new MBeanCmdManagerException("Cannot connect to the MBeanCmd manager service located on " + jmxUrl);
        }
        ObjectName manager = null;
        String result = command;
        try {
            Set<ObjectName> objNames = this.mbscnx.queryNames(null, null);
            for (ObjectName obj : objNames) {
                if (!obj.getCanonicalName().contains("type=EventSwitch") || !obj.getCanonicalName().contains("name=manager")) continue;
                manager = obj;
                break;
            }
        }
        catch (IOException e) {
            throw new MBeanCmdManagerException("No MBean found", e);
        }
        try {
            result = (String)this.mbscnx.invoke(manager, "startMBeanCmdCommand", new Object[]{command}, new String[]{String.class.getName()});
        }
        catch (Exception e) {
            throw new MBeanCmdManagerException("Invoke failed ... ", e);
        }
        return result;
    }

    public List<String> getMBeanCmdInstanceNames(String jmxUrl) throws MBeanCmdManagerException {
        if (!this.connect(jmxUrl)) {
            throw new MBeanCmdManagerException("Cannot connect to the MBeanCmd manager service located on " + jmxUrl);
        }
        ObjectName manager = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            Set<ObjectName> objNames = this.mbscnx.queryNames(null, null);
            for (ObjectName obj : objNames) {
                if (!obj.getCanonicalName().contains("type=EventSwitch") || !obj.getCanonicalName().contains("name=manager")) continue;
                manager = obj;
                break;
            }
        }
        catch (IOException e) {
            throw new MBeanCmdManagerException("No MBean found");
        }
        String[] r = null;
        try {
            r = (String[])this.mbscnx.invoke(manager, "MBeanCmdCommandNames", null, null);
        }
        catch (Exception e) {
            throw new MBeanCmdManagerException("Invoke failed ... ");
        }
        for (int i = 0; i < r.length; ++i) {
            result.add(r[i]);
        }
        return result;
    }
}

