/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.JasmineEventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.JMSConnection;
import org.ow2.jasmine.monitoring.eos.common.jms.event.JasmineMessageEvent;
import org.ow2.jasmine.monitoring.eos.monitoring.DataBaseEventExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringService
implements Serializable {
    private static final long serialVersionUID = 8402643661543808499L;
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String noValue = "noValue";
    private JMSConnection jmsConnection = null;
    private static final String JMS_TOPIC = "jasmine";
    private Timer timer = null;
    private static long TIMER = 30000L;
    private JasmineEventManager eventManager = new JasmineEventManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadFile(String file) throws Exception {
        Exception e22;
        String string;
        FileReader f;
        block12: {
            String result = "";
            f = null;
            BufferedReader buffer = null;
            try {
                String line = "";
                f = new FileReader(file);
                buffer = new BufferedReader(f);
                boolean write = false;
                while ((line = buffer.readLine()) != null) {
                    if (line.contains("<monitor")) {
                        write = true;
                    }
                    if (!write) continue;
                    result = result + line + "\n";
                }
                string = result;
                Object var9_8 = null;
                if (buffer == null) break block12;
            }
            catch (Throwable throwable) {
                block14: {
                    Exception e22;
                    Object var9_9 = null;
                    if (buffer != null) {
                        try {
                            buffer.close();
                            buffer = null;
                            System.gc();
                        }
                        catch (Exception e22) {
                            this.logger.error((Object)"Failed closing buffer", new Object[]{e22});
                        }
                    }
                    if (f == null) break block14;
                    try {
                        f.close();
                        f = null;
                        System.gc();
                    }
                    catch (Exception e22) {
                        this.logger.error((Object)"Failed closing file", new Object[]{e22});
                    }
                }
                throw throwable;
            }
            try {
                buffer.close();
                buffer = null;
                System.gc();
            }
            catch (Exception e22) {
                this.logger.error((Object)"Failed closing buffer", new Object[]{e22});
            }
        }
        if (f != null) {
            try {
                f.close();
                f = null;
                System.gc();
            }
            catch (Exception e22) {
                this.logger.error((Object)"Failed closing file", new Object[]{e22});
            }
        }
        return string;
    }

    public List<List<EventData>> loadLogFile(String fileName, String filter) throws Exception {
        String[] toKeep = filter.split("bigSeparator");
        ArrayList<Filter> elements = new ArrayList<Filter>();
        for (int i = 0; i < toKeep.length; ++i) {
            elements.add(new Filter(toKeep[i]));
        }
        int[] columns = new int[elements.size()];
        ArrayList<List<EventData>> result = new ArrayList<List<EventData>>();
        ArrayList[] lists = new ArrayList[columns.length];
        for (int i0 = 0; i0 < lists.length; ++i0) {
            lists[i0] = new ArrayList();
            lists[i0].add(new EventData(((Filter)elements.get(i0)).header));
        }
        FileReader f = null;
        BufferedReader buffer = null;
        Object pattern = null;
        Matcher matcher = null;
        String header = "";
        String line = "";
        f = new FileReader(fileName);
        buffer = new BufferedReader(f);
        header = buffer.readLine();
        String[] headerArray = header.split(";");
        boolean dateIsFirst = headerArray[0].equals("date");
        for (int i1 = 0; i1 < elements.size(); ++i1) {
            boolean invalid = true;
            for (int i2 = 0; i2 < headerArray.length; ++i2) {
                if (((Filter)elements.get(i1)).header.compareTo(headerArray[i2]) != 0) continue;
                columns[i1] = i2;
                invalid = false;
                break;
            }
            if (!invalid) continue;
            throw new Exception("invalid column");
        }
        HashMap<Filter, Pattern> patterns = new HashMap<Filter, Pattern>();
        for (Filter fi : elements) {
            patterns.put(fi, Pattern.compile(fi.pattern));
        }
        while ((line = buffer.readLine()) != null) {
            String[] split = line.split(";");
            for (int i3 = 0; i3 < columns.length; ++i3) {
                matcher = ((Pattern)patterns.get(elements.get(i3))).matcher(line.toString());
                if (!((Filter)elements.get(i3)).pattern.equals(noValue) && !matcher.matches()) continue;
                EventData ed = dateIsFirst ? new EventData(split[0], split[columns[i3]]) : new EventData(split[1], split[columns[i3]]);
                ed.setId(((Filter)elements.get(i3)).id);
                lists[i3].add(ed);
            }
        }
        for (ArrayList l : lists) {
            result.add(l);
        }
        return result;
    }

    public List<List<EventData>> loadFromDataBase(String args, String filter) throws Exception {
        Matcher matcher = null;
        String[] datesSelected = args.split("separator");
        Calendar minDate = Calendar.getInstance();
        Calendar maxDate = Calendar.getInstance();
        minDate.set(Integer.parseInt(datesSelected[0]), Integer.parseInt(datesSelected[1]), Integer.parseInt(datesSelected[2]), Integer.parseInt(datesSelected[3]), Integer.parseInt(datesSelected[4]));
        maxDate.set(Integer.parseInt(datesSelected[5]), Integer.parseInt(datesSelected[6]), Integer.parseInt(datesSelected[7]), Integer.parseInt(datesSelected[8]), Integer.parseInt(datesSelected[9]));
        if (minDate.getTimeInMillis() > maxDate.getTimeInMillis()) {
            maxDate.set(Integer.parseInt(datesSelected[0]), Integer.parseInt(datesSelected[1]), Integer.parseInt(datesSelected[2]), Integer.parseInt(datesSelected[3]), Integer.parseInt(datesSelected[4]));
            minDate.set(Integer.parseInt(datesSelected[5]), Integer.parseInt(datesSelected[6]), Integer.parseInt(datesSelected[7]), Integer.parseInt(datesSelected[8]), Integer.parseInt(datesSelected[9]));
        }
        String[] toKeep = filter.split("bigSeparator");
        ArrayList<Filter> elements = new ArrayList<Filter>();
        for (int i = 0; i < toKeep.length; ++i) {
            elements.add(new Filter(toKeep[i]));
        }
        int[] columns = new int[elements.size()];
        ArrayList<List<EventData>> result = new ArrayList<List<EventData>>();
        ArrayList[] lists = new ArrayList[columns.length];
        for (int i0 = 0; i0 < lists.length; ++i0) {
            lists[i0] = new ArrayList();
            lists[i0].add(new EventData(((Filter)elements.get(i0)).header));
        }
        HashMap<Filter, Pattern> patterns = new HashMap<Filter, Pattern>();
        for (Filter fi : elements) {
            patterns.put(fi, Pattern.compile(fi.pattern));
        }
        DataBaseEventExtractor dataBaseEventExtractor = new DataBaseEventExtractor();
        JasmineEventEB[] events = null;
        String probe = "";
        String server = "";
        for (int j = 0; j < elements.size(); ++j) {
            probe = probe + ((Filter)elements.get(j)).header + "separator";
            server = server + ((Filter)elements.get(j)).server + "separator";
        }
        String[] arguments = new String[]{"-Context.INITIAL_CONTEXT_FACTORY", "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory", "-Wrapper.LOOKUP_BEAN", "db-ejb/event", "-domain", "jonas", "-server", server, "-source", "mbeancmd", "-probe", probe, "-starttimestamp", String.valueOf(minDate.getTimeInMillis()), "-endtimestamp", String.valueOf(maxDate.getTimeInMillis()), "-orderby", "timestamp", "-limit", "300000"};
        block4: for (JasmineEventEB jasmineEventEB : events = dataBaseEventExtractor.getEvents(arguments)) {
            for (int i = 0; i < lists.length; ++i) {
                if (((EventData)lists[i].get(0)).getType().compareTo(jasmineEventEB.getProbe()) != 0) continue;
                matcher = ((Pattern)patterns.get(elements.get(i))).matcher(jasmineEventEB.getProbe());
                if (!((Filter)elements.get(i)).pattern.equals(noValue) && !matcher.matches()) continue block4;
                String dateConverted = jasmineEventEB.getTimestamp().toString().substring(0, 4) + "/" + jasmineEventEB.getTimestamp().toString().substring(5, 7) + "/" + jasmineEventEB.getTimestamp().toString().substring(8, 10) + " " + jasmineEventEB.getTimestamp().toString().substring(11, 20);
                EventData ed = new EventData(dateConverted, jasmineEventEB.getValue().toString());
                ed.setId(((Filter)elements.get(i)).id);
                lists[i].add(ed);
                continue block4;
            }
        }
        for (ArrayList arrayList : lists) {
            result.add(arrayList);
        }
        return result;
    }

    public List<List<EventData>> startMonitoring(String filter) {
        try {
            if (this.jmsConnection == null) {
                this.connectTopic();
            }
            this.resetTimer();
            String[] toKeep = filter.split("bigSeparator");
            ArrayList<Filter> elements = new ArrayList<Filter>();
            for (int i = 0; i < toKeep.length; ++i) {
                elements.add(new Filter(toKeep[i]));
            }
            int[] columns = new int[elements.size()];
            ArrayList<List<EventData>> result = new ArrayList<List<EventData>>();
            ArrayList[] lists = new ArrayList[columns.length];
            for (int i0 = 0; i0 < lists.length; ++i0) {
                lists[i0] = new ArrayList();
                lists[i0].add(new EventData(((Filter)elements.get(i0)).header));
            }
            Pattern pattern = null;
            Matcher matcher = null;
            String probe = "";
            String[] p = null;
            List events = this.eventManager.getAll();
            block4: for (JasmineMessageEvent elem : events) {
                p = elem.getProbe().split(":");
                probe = p[p.length - 1];
                for (int i = 0; i < lists.length; ++i) {
                    if (((EventData)lists[i].get(0)).getType().compareTo(probe) != 0) continue;
                    pattern = Pattern.compile(((Filter)elements.get(i)).pattern);
                    matcher = pattern.matcher(elem.getCsvFormat());
                    if (!matcher.find() && !((Filter)elements.get(i)).pattern.equals(noValue)) continue block4;
                    EventData ed = new EventData(elem.getFormattedTimeStamp(), elem.getValue());
                    ed.setId(((Filter)elements.get(i)).id);
                    lists[i].add(ed);
                    continue block4;
                }
            }
            for (ArrayList l : lists) {
                result.add(l);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean stopMonitoring() throws Exception {
        this.disconnectTopic();
        return true;
    }

    private void connectTopic() throws Exception {
        if (this.jmsConnection == null) {
            this.jmsConnection = new JMSConnection((EventManager)this.eventManager);
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DisconnectTask(), TIMER);
        this.jmsConnection.connect(JMS_TOPIC);
    }

    public void disconnectTopic() throws Exception {
        this.logger.debug((Object)"Disconnecting from the JMS topic...", new Object[0]);
        if (this.jmsConnection != null) {
            this.jmsConnection.disconnect();
            this.jmsConnection = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void resetTimer() {
        this.timer.cancel();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DisconnectTask(), TIMER);
    }

    class Filter {
        private String header;
        private String id;
        private String pattern;
        private String server;

        public Filter(String properties) {
            String[] tabString = properties.split("separator");
            this.header = tabString[0];
            this.id = tabString[1];
            this.pattern = tabString[2];
            this.server = tabString[3];
        }

        public String getHeader() {
            return this.header;
        }

        public String getId() {
            return this.id;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getServer() {
            return this.server;
        }
    }

    class DisconnectTask
    extends TimerTask {
        DisconnectTask() {
        }

        public void run() {
            try {
                MonitoringService.this.disconnectTopic();
            }
            catch (Exception e) {
                MonitoringService.this.logger.error((Object)"Failed disconnecting from JMS topic", new Object[]{e});
            }
        }
    }
}

