/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.JasmineEventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.JMSConnection;
import org.ow2.jasmine.monitoring.eos.common.jms.event.JasmineMessageEvent;
import org.ow2.jasmine.monitoring.eos.monitoring.ConfigFile;
import org.ow2.jasmine.monitoring.eos.monitoring.DataBaseEventExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.ReplayFileName;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.SerieResult;
import org.ow2.jasmine.monitoring.eos.monitoring.service.NameFilter;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringService
implements Serializable {
    private static final long serialVersionUID = 8402643661543808499L;
    private Log logger = LogFactory.getLog(this.getClass());
    private Set<String> replaydirlist;
    private Set<String> configdirlist;
    private transient Timer timer = null;
    private long disconnectTime = 0L;
    private static final long JMS_CHECK_INTERVAL = 1000L;
    private static final long JMS_TIMEOUT = 60000L;
    private static final String JMS_TOPIC = "jasmine";
    private JMSConnection jmsConnection = null;
    private JasmineEventManager eventManager = null;

    public MonitoringService() {
        this.readConfig();
        this.eventManager = new JasmineEventManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConfigFile(File file) {
        BufferedReader buffer;
        FileReader fileReader;
        block26: {
            boolean bl;
            block24: {
                block25: {
                    fileReader = null;
                    buffer = null;
                    try {
                        fileReader = new FileReader(file);
                        buffer = new BufferedReader(fileReader);
                        String line = "";
                        while ((line = buffer.readLine()) != null) {
                            if (!line.contains("<monitor")) continue;
                            bl = true;
                            if (buffer == null) break block24;
                            break block25;
                        }
                        break block26;
                    }
                    catch (Exception e) {
                        if (buffer != null) {
                            try {
                                buffer.close();
                            }
                            catch (Exception e2) {
                                this.logger.error((Object)"Failed closing buffer", new Object[]{e2});
                            }
                        }
                        if (fileReader == null) return false;
                        try {
                            fileReader.close();
                            return false;
                        }
                        catch (Exception e3) {
                            this.logger.error((Object)"Failed closing fileReader", new Object[]{e3});
                            return false;
                        }
                        catch (Throwable throwable) {
                            if (buffer != null) {
                                try {
                                    buffer.close();
                                }
                                catch (Exception e4) {
                                    this.logger.error((Object)"Failed closing buffer", new Object[]{e4});
                                }
                            }
                            if (fileReader == null) throw throwable;
                            try {
                                fileReader.close();
                                throw throwable;
                            }
                            catch (Exception e5) {
                                this.logger.error((Object)"Failed closing fileReader", new Object[]{e5});
                            }
                            throw throwable;
                        }
                    }
                }
                try {
                    buffer.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed closing buffer", new Object[]{e});
                }
            }
            if (fileReader == null) return bl;
            try {
                fileReader.close();
                return bl;
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed closing fileReader", new Object[]{e});
            }
            return bl;
        }
        if (buffer != null) {
            try {
                buffer.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed closing buffer", new Object[]{e});
            }
        }
        if (fileReader == null) return false;
        try {
            fileReader.close();
            return false;
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed closing fileReader", new Object[]{e});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadConfigFile(String path) throws Exception {
        String string;
        FileReader fileReader;
        block18: {
            this.logger.debug((Object)("Load config file: " + path), new Object[0]);
            String result = "";
            fileReader = null;
            BufferedReader buffer = null;
            File file = new File(path);
            if (!file.exists()) {
                file = new File(JProp.getJonasBase() + File.separator + path);
            }
            if (!file.exists()) {
                throw new Exception("Impossible to locate the file: " + path);
            }
            String endofline = System.getProperty("line.separator");
            try {
                fileReader = new FileReader(file);
                buffer = new BufferedReader(fileReader);
                boolean write = false;
                String line = "";
                while ((line = buffer.readLine()) != null) {
                    if (line.contains("<monitor")) {
                        write = true;
                    }
                    if (!write) continue;
                    result = result + line + endofline;
                }
                if (!write) {
                    throw new Exception("Bad configuration file: No 'monitor' tag found.");
                }
                string = result;
                if (buffer == null) break block18;
            }
            catch (Throwable throwable) {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Failed closing buffer", new Object[]{e});
                    }
                }
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Failed closing fileReader", new Object[]{e});
                    }
                }
                throw throwable;
            }
            try {
                buffer.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed closing buffer", new Object[]{e});
            }
        }
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed closing fileReader", new Object[]{e});
            }
        }
        return string;
    }

    public List<SerieResult> loadLogFile(String fileName, List<Serie> series) throws Exception {
        this.logger.debug((Object)("Start reading file: " + fileName), new Object[0]);
        FileReader f = new FileReader(fileName);
        BufferedReader buffer = new BufferedReader(f);
        String header = buffer.readLine();
        if (header == null) {
            this.logger.warn((Object)("Empty file: " + fileName), new Object[0]);
            throw new Exception("Empty file: " + fileName);
        }
        if (header.startsWith("date")) {
            return this.loadLogFileHeader(buffer, series, header, 0);
        }
        if (header.startsWith("time")) {
            return this.loadLogFileHeader(buffer, series, header, 1);
        }
        return this.loadLogFileNoHeader(buffer, series);
    }

    private List<SerieResult> loadLogFileNoHeader(BufferedReader buffer, List<Serie> series) throws Exception {
        HashMap datalist = new HashMap();
        for (Serie serie : series) {
            datalist.put(serie.getId(), new ArrayList());
        }
        String line = "";
        while ((line = buffer.readLine()) != null) {
            String[] split = line.split(";");
            if (split.length <= 6) continue;
            String date = split[1];
            String server = split[4];
            String mbeanattr = split[5];
            int index = mbeanattr.lastIndexOf(":");
            String mbean = mbeanattr.substring(0, index);
            String attr = mbeanattr.substring(index + 1);
            String value = split[6];
            for (Serie curser : series) {
                if (!attr.equals(curser.getYcol()) || !this.match(mbean, curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(server)) continue;
                EventData ed = new EventData(date, value);
                ((ArrayList)datalist.get(curser.getId())).add(ed);
            }
        }
        ArrayList<SerieResult> result = new ArrayList<SerieResult>();
        for (Serie ser : series) {
            SerieResult sr = new SerieResult();
            sr.setId(ser.getId());
            sr.setResults((ArrayList)datalist.get(sr.getId()));
            result.add(sr);
            this.logger.debug((Object)("Found " + sr.getResults().size() + " events for serie " + sr.getId()), new Object[0]);
        }
        return result;
    }

    private List<SerieResult> loadLogFileHeader(BufferedReader buffer, List<Serie> series, String header, int dateind) throws Exception {
        String[] headerArray = header.split(";");
        int mbeanCol = -1;
        int serverCol = -1;
        HashMap<String, Integer> valueCol = new HashMap<String, Integer>();
        for (int index = 0; index < headerArray.length; ++index) {
            if (headerArray[index].equals("server")) {
                serverCol = index;
            }
            if (headerArray[index].equals("mbean")) {
                mbeanCol = index;
            }
            for (Serie afil : series) {
                if (!afil.getYcol().equals(headerArray[index])) continue;
                valueCol.put(afil.getId(), new Integer(index));
            }
        }
        if (serverCol == -1) {
            throw new Exception("Bad log file: No server in header");
        }
        if (mbeanCol == -1) {
            throw new Exception("Bad log file: No mbean in header");
        }
        HashMap datalist = new HashMap();
        for (Serie serie : series) {
            datalist.put(serie.getId(), new ArrayList());
        }
        String line = "";
        while ((line = buffer.readLine()) != null) {
            String[] split = line.split(";");
            if (split.length < headerArray.length) continue;
            String date = split[dateind];
            String server = split[serverCol];
            String mbeanattr = split[mbeanCol];
            int index = mbeanattr.lastIndexOf(":");
            String mbean = mbeanattr.substring(0, index);
            for (Serie curser : series) {
                Integer valueIndex = (Integer)valueCol.get(curser.getId());
                if (valueIndex == null) continue;
                String value = split[valueIndex];
                if (!this.match(mbean, curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(server)) continue;
                EventData ed = new EventData(date, value);
                ((ArrayList)datalist.get(curser.getId())).add(ed);
            }
        }
        ArrayList<SerieResult> result = new ArrayList<SerieResult>();
        for (Serie ser : series) {
            SerieResult sr = new SerieResult();
            sr.setId(ser.getId());
            sr.setResults((ArrayList)datalist.get(sr.getId()));
            result.add(sr);
            this.logger.debug((Object)("Found " + sr.getResults().size() + " events for serie " + sr.getId()), new Object[0]);
        }
        this.logger.debug((Object)("Stop reading file:" + result.size()), new Object[0]);
        return result;
    }

    public List<SerieResult> loadFromDataBase(Date from, Date to, List<Serie> series) throws Exception {
        this.logger.debug((Object)"start reading database", new Object[0]);
        HashMap datalist = new HashMap();
        for (Serie serie : series) {
            datalist.put(serie.getId(), new ArrayList());
        }
        HashSet<String> servers = new HashSet<String>();
        HashSet<String> probes = new HashSet<String>();
        for (Serie element : series) {
            probes.add(element.getYcol());
            if (element.getServer() == null) continue;
            servers.add(element.getServer());
        }
        DataBaseEventExtractor dataBaseEventExtractor = new DataBaseEventExtractor();
        JasmineEventEB[] events = dataBaseEventExtractor.getEvents(servers, probes, from, to);
        if (events != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            for (JasmineEventEB elem : events) {
                for (Serie curser : series) {
                    if (!elem.getProbe().endsWith(":" + curser.getYcol()) || !this.match(elem.getMBean(), curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(elem.getServer())) continue;
                    String dateConverted = format.format(elem.getTimestamp());
                    EventData ed = new EventData(dateConverted, elem.getValue().toString());
                    ((ArrayList)datalist.get(curser.getId())).add(ed);
                }
            }
        }
        ArrayList<SerieResult> result = new ArrayList<SerieResult>();
        for (Serie ser : series) {
            SerieResult sr = new SerieResult();
            sr.setId(ser.getId());
            sr.setResults((ArrayList)datalist.get(sr.getId()));
            result.add(sr);
            this.logger.debug((Object)("Found " + sr.getResults().size() + " events for serie " + sr.getId()), new Object[0]);
        }
        this.logger.debug((Object)("Stop reading database:" + result.size()), new Object[0]);
        return result;
    }

    public List<SerieResult> startMonitoring(List<Serie> series) throws Exception {
        HashMap datalist = new HashMap();
        for (Serie serie : series) {
            datalist.put(serie.getId(), new ArrayList());
        }
        this.connectTopic();
        List events = this.eventManager.getAll();
        for (JasmineMessageEvent elem : events) {
            for (Serie curser : series) {
                if (!elem.getProbe().endsWith(":" + curser.getYcol()) || !this.match(elem.getMBean(), curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(elem.getServer())) continue;
                EventData ed = new EventData(elem.getFormattedTimeStamp(), elem.getValue());
                ((ArrayList)datalist.get(curser.getId())).add(ed);
            }
        }
        ArrayList<SerieResult> result = new ArrayList<SerieResult>();
        for (Serie ser : series) {
            SerieResult sr = new SerieResult();
            sr.setId(ser.getId());
            sr.setResults((ArrayList)datalist.get(sr.getId()));
            result.add(sr);
            this.logger.debug((Object)("Found " + sr.getResults().size() + " events for serie " + sr.getId()), new Object[0]);
        }
        return result;
    }

    public void stopMonitoring() throws Exception {
        this.disconnectTopic();
    }

    public ArrayList<ReplayFileName> getReplayFilenames(String filter) throws Exception {
        this.logger.debug((Object)filter, new Object[0]);
        ArrayList<ReplayFileName> result = new ArrayList<ReplayFileName>();
        for (String dir : this.replaydirlist) {
            result.addAll(this.getReplayFiles(dir, filter));
        }
        return result;
    }

    private ArrayList<ReplayFileName> getReplayFiles(String directory, String filter) {
        this.logger.debug((Object)directory, new Object[0]);
        ArrayList<ReplayFileName> result = new ArrayList<ReplayFileName>();
        File dir = new File(directory);
        if (!dir.exists()) {
            dir = new File(JProp.getJonasBase() + File.separator + directory);
        }
        if (!dir.exists()) {
            this.logger.error((Object)("cannot find " + directory), new Object[0]);
            return result;
        }
        File[] files = dir.listFiles(new NameFilter(filter));
        if (files == null) {
            this.logger.warn((Object)("no files found in " + directory), new Object[0]);
            return result;
        }
        for (int i = 0; i < files.length; ++i) {
            ReplayFileName rfn = new ReplayFileName();
            rfn.setDirectory(dir.getPath());
            rfn.setName(files[i].getName());
            rfn.setSize(files[i].length());
            rfn.setDate(new Date(files[i].lastModified()));
            rfn.setSeparator(File.separator);
            result.add(rfn);
            this.logger.debug((Object)("found " + files[i].getName()), new Object[0]);
        }
        return result;
    }

    public ConfigFile saveConfigFile(String name, String file) throws Exception {
        this.logger.error((Object)("Save config file:" + name), new Object[0]);
        File pathname = new File(JProp.getJonasBase() + File.separator + "monitoring" + File.separator + name);
        FileWriter f = new FileWriter(pathname);
        f.write(file);
        f.close();
        ConfigFile rfn = new ConfigFile();
        rfn.setDirectory("monitoring");
        rfn.setName(name);
        rfn.setSize(pathname.length());
        rfn.setDate(new Date(pathname.lastModified()));
        rfn.setSeparator(File.separator);
        return rfn;
    }

    public ArrayList<ConfigFile> removeConfigFile(ConfigFile file) throws Exception {
        this.logger.error((Object)("Remove config file:" + file.getName()), new Object[0]);
        for (String strdir : this.configdirlist) {
            if (!strdir.endsWith(file.getDirectory())) continue;
            File dir = new File(strdir);
            if (!dir.exists()) {
                dir = new File(JProp.getJonasBase() + File.separator + strdir);
            }
            if (!dir.exists()) {
                this.logger.error((Object)("cannot find " + strdir), new Object[0]);
                break;
            }
            File f = new File(dir, file.getName());
            f.delete();
            break;
        }
        String filter = "*.xml";
        ArrayList<ConfigFile> result = new ArrayList<ConfigFile>();
        for (String dir : this.configdirlist) {
            result.addAll(this.getConfigFiles(dir, filter));
        }
        return result;
    }

    public ArrayList<ConfigFile> renameConfigFile(ConfigFile file, String newname) throws Exception {
        this.logger.error((Object)("Rename config file:" + file.getName()), new Object[0]);
        for (String strdir : this.configdirlist) {
            if (!strdir.endsWith(file.getDirectory())) continue;
            File dir = new File(strdir);
            if (!dir.exists()) {
                dir = new File(JProp.getJonasBase() + File.separator + strdir);
            }
            if (!dir.exists()) {
                this.logger.error((Object)("cannot find " + strdir), new Object[0]);
                break;
            }
            File f = new File(dir, file.getName());
            File dest = new File(dir, newname);
            f.renameTo(dest);
            break;
        }
        String filter = "*.xml";
        ArrayList<ConfigFile> result = new ArrayList<ConfigFile>();
        for (String dir : this.configdirlist) {
            result.addAll(this.getConfigFiles(dir, filter));
        }
        return result;
    }

    public ArrayList<ConfigFile> getConfigFiles(String filter) throws Exception {
        this.logger.debug((Object)filter, new Object[0]);
        ArrayList<ConfigFile> result = new ArrayList<ConfigFile>();
        for (String dir : this.configdirlist) {
            result.addAll(this.getConfigFiles(dir, filter));
        }
        return result;
    }

    private boolean match(String strmbean, String strpattern) {
        if (strpattern == null || strpattern.length() == 0 || strpattern.equals("*:*")) {
            return true;
        }
        ObjectName mbean = null;
        ObjectName pattern = null;
        try {
            mbean = new ObjectName(strmbean);
        }
        catch (MalformedObjectNameException e) {
            this.logger.error((Object)("Bad MBean ObjectName (MalformedObjectNameException) " + strmbean), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            this.logger.error((Object)("Bad MBean ObjectName (NPE) " + strmbean), new Object[0]);
            return false;
        }
        try {
            pattern = new ObjectName(strpattern);
        }
        catch (MalformedObjectNameException e) {
            this.logger.error((Object)("Bad Pattern ObjectName (MalformedObjectNameException) " + strpattern), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            this.logger.error((Object)("Bad Pattern ObjectName (NPE) " + strpattern), new Object[0]);
            return false;
        }
        if (pattern == null) {
            this.logger.error((Object)("Cannot get ObjectName on " + strpattern), new Object[0]);
            return false;
        }
        return pattern.apply(mbean);
    }

    private ArrayList<ConfigFile> getConfigFiles(String directory, String filter) {
        ArrayList<ConfigFile> result = new ArrayList<ConfigFile>();
        File dir = new File(directory);
        if (!dir.exists()) {
            dir = new File(JProp.getJonasBase() + File.separator + directory);
        }
        if (!dir.exists()) {
            this.logger.error((Object)("cannot find " + directory), new Object[0]);
            return result;
        }
        this.logger.debug((Object)("directory explored=" + dir.getPath()), new Object[0]);
        File[] files = dir.listFiles(new NameFilter(filter));
        if (files == null) {
            this.logger.warn((Object)("no files found in " + directory), new Object[0]);
            return result;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!this.isConfigFile(files[i])) continue;
            ConfigFile rfn = new ConfigFile();
            rfn.setDirectory(dir.getPath());
            rfn.setName(files[i].getName());
            rfn.setSize(files[i].length());
            rfn.setDate(new Date(files[i].lastModified()));
            rfn.setSeparator(File.separator);
            result.add(rfn);
            this.logger.debug((Object)("found " + files[i].getName()), new Object[0]);
        }
        return result;
    }

    private void readConfig() {
        JProp config = JProp.getInstance((String)"jasmine-monitoring.properties");
        this.replaydirlist = new HashSet<String>();
        String[] list = config.getValueAsArray("jasmine.monitoring.replaydir");
        if (list == null) {
            this.logger.debug((Object)"Missing jasmine-monitoring.properties: take default values", new Object[0]);
            this.replaydirlist.add("monitoring");
        } else {
            for (int i = 0; i < list.length; ++i) {
                this.replaydirlist.add(list[i]);
            }
        }
        String eostemp = System.getProperty("java.io.tmpdir") + File.separatorChar + "EoS.temp";
        this.replaydirlist.add(eostemp);
        this.configdirlist = new HashSet<String>();
        list = config.getValueAsArray("jasmine.monitoring.configdir");
        if (list == null) {
            this.logger.debug((Object)"Missing jasmine-monitoring.properties: take default values", new Object[0]);
            this.configdirlist.add("monitoring");
        } else {
            for (int i = 0; i < list.length; ++i) {
                this.configdirlist.add(list[i]);
            }
        }
        this.configdirlist.add(eostemp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectTopic() throws Exception {
        MonitoringService monitoringService = this;
        synchronized (monitoringService) {
            if (this.jmsConnection == null) {
                this.logger.debug((Object)"Connecting to the JMS topic...", new Object[0]);
                this.jmsConnection = new JMSConnection((EventManager)this.eventManager);
                this.jmsConnection.connect(JMS_TOPIC);
            }
        }
        this.logger.debug((Object)"Connected to the JMS topic", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectTopic() throws Exception {
        MonitoringService monitoringService = this;
        synchronized (monitoringService) {
            if (this.jmsConnection != null) {
                this.logger.debug((Object)"Disconnecting from the JMS topic...", new Object[0]);
                this.jmsConnection.disconnect();
                this.jmsConnection = null;
            }
            this.disconnectTime = 0L;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
                this.timer = null;
            }
        }
        this.logger.debug((Object)"Disconnected from the JMS topic", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTimer() {
        MonitoringService monitoringService = this;
        synchronized (monitoringService) {
            this.disconnectTime = System.currentTimeMillis() + 60000L;
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new DisconnectTask(), 1000L, 1000L);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.disconnectTime > 0L) {
            this.resetTimer();
        }
    }

    class DisconnectTask
    extends TimerTask {
        DisconnectTask() {
        }

        public void run() {
            try {
                if (System.currentTimeMillis() > MonitoringService.this.disconnectTime) {
                    MonitoringService.this.disconnectTopic();
                }
            }
            catch (Throwable t) {
                MonitoringService.this.logger.error((Object)"Failed disconnecting from JMS topic", new Object[]{t});
            }
        }
    }
}

