/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.jasmine.event.messages.JasmineEvent;
import org.ow2.jasmine.event.messages.JasmineEventDetails;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DatabaseExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.service.Extractor;
import org.ow2.jasmine.monitoring.eos.monitoring.service.FileExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.service.HeaderFileExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.service.MonitoringService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardDataCollector
implements MessageListener {
    private static final Log logger = LogFactory.getLog(MonitoringService.class);
    private int ident;
    private List<Serie> series;
    LinkedList<EventData> datalist = null;
    public static final String TOPIC_FACTORY = "JTCF";
    public static final String JASMINE_TOPIC = "jasmine";
    private Topic topic = null;
    private TopicConnection connection = null;
    private TopicSession session = null;
    private TopicSubscriber subscriber = null;
    private Extractor extractor = null;
    private boolean replay;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public DashboardDataCollector(int ident, List<Serie> series) {
        this.ident = ident;
        this.series = series;
        this.cleanResults();
    }

    public List<Serie> getSeries() {
        return this.series;
    }

    public synchronized void addResult(EventData evd) {
        this.datalist.addLast(evd);
    }

    public void setReplayCompleted() {
        this.extractor = null;
    }

    public boolean match(String strmbean, String strpattern) {
        if (strpattern == null || strpattern.length() == 0 || strpattern.equals("*:*")) {
            return true;
        }
        ObjectName mbean = null;
        ObjectName pattern = null;
        try {
            mbean = new ObjectName(strmbean);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)("Bad MBean ObjectName (MalformedObjectNameException) " + strmbean), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            logger.error((Object)("Bad MBean ObjectName (NPE) " + strmbean), new Object[0]);
            return false;
        }
        try {
            pattern = new ObjectName(strpattern);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)("Bad Pattern ObjectName (MalformedObjectNameException) " + strpattern), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            logger.error((Object)("Bad Pattern ObjectName (NPE) " + strpattern), new Object[0]);
            return false;
        }
        if (pattern == null) {
            logger.error((Object)("Cannot get ObjectName on " + strpattern), new Object[0]);
            return false;
        }
        return pattern.apply(mbean);
    }

    public void onMessage(Message message) {
        if (!(message instanceof ObjectMessage)) {
            return;
        }
        ObjectMessage om = (ObjectMessage)message;
        Serializable jasmineEventObject = null;
        try {
            message.acknowledge();
            jasmineEventObject = om.getObject();
        }
        catch (JMSException e) {
            logger.error((Object)"Bad nessage got on Jms Topic", new Object[0]);
            return;
        }
        if (!(jasmineEventObject instanceof JasmineEvent)) {
            return;
        }
        JasmineEvent event = (JasmineEvent)jasmineEventObject;
        String server = event.getServer();
        for (JasmineEventDetails ed : event.getEvents()) {
            String probe = ed.getProbe();
            String mbean = probe.substring(0, probe.lastIndexOf(":"));
            for (Serie curser : this.series) {
                String svr;
                if (!probe.endsWith(":" + curser.getYcol()) || !this.match(mbean, curser.getPattern()) || (svr = curser.getServer()) != null && svr.length() > 0 && !svr.equals(server)) continue;
                String formtime = this.simpleDateFormat.format(ed.getTimestamp());
                EventData evd = new EventData(curser.getId(), formtime, ed.getValue());
                this.addResult(evd);
            }
        }
    }

    public synchronized List<EventData> getAllResults() {
        int count;
        ArrayList<EventData> res = new ArrayList<EventData>();
        for (count = 0; count < 2000; ++count) {
            try {
                EventData ed = this.datalist.removeFirst();
                res.add(ed);
                continue;
            }
            catch (NoSuchElementException e) {
                // empty catch block
                break;
            }
        }
        if (count == 0 && this.isReplayCompleted()) {
            logger.debug((Object)"ReplayCompleted", new Object[0]);
            return null;
        }
        logger.debug((Object)("Found " + count + " events"), new Object[0]);
        return res;
    }

    public void startLiveMonitoring() throws NamingException, JMSException {
        logger.debug((Object)"", new Object[0]);
        this.cleanResults();
        this.replay = false;
        InitialContext context = new InitialContext();
        TopicConnectionFactory tcf = (TopicConnectionFactory)context.lookup(TOPIC_FACTORY);
        if (this.topic == null) {
            this.topic = (Topic)context.lookup(JASMINE_TOPIC);
        }
        this.connection = tcf.createTopicConnection();
        this.session = this.connection.createTopicSession(false, 2);
        this.subscriber = this.session.createSubscriber(this.topic);
        this.subscriber.setMessageListener((MessageListener)this);
        this.connection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLiveMonitoring() {
        logger.debug((Object)"", new Object[0]);
        if (this.connection != null) {
            try {
                if (this.subscriber != null) {
                    this.subscriber.close();
                }
                if (this.session != null) {
                    this.session.close();
                }
                this.connection.close();
            }
            catch (JMSException e) {
                logger.error((Object)"cannot disconnect from jasmine topic", new Object[0]);
            }
            finally {
                this.connection = null;
                this.session = null;
                this.subscriber = null;
            }
        }
    }

    public void startFileReplay(String fileName, Date from, Date to) throws Exception {
        logger.debug((Object)"", new Object[0]);
        this.cleanResults();
        FileReader f = new FileReader(fileName);
        BufferedReader buffer = new BufferedReader(f);
        String header = buffer.readLine();
        if (header == null) {
            logger.warn((Object)("Empty file: " + fileName), new Object[0]);
            throw new Exception("Empty file: " + fileName);
        }
        this.replay = true;
        this.extractor = header.startsWith("date") ? new HeaderFileExtractor(this, header, 0, buffer, from, to) : (header.startsWith("time") ? new HeaderFileExtractor(this, header, 1, buffer, from, to) : new FileExtractor(this, new BufferedReader(f), from, to));
        this.extractor.start();
    }

    public void startDatabaseReplay(Date from, Date to) throws Exception {
        logger.debug((Object)"", new Object[0]);
        this.cleanResults();
        this.replay = true;
        this.extractor = new DatabaseExtractor(this, from, to);
        this.extractor.start();
    }

    private boolean isReplayCompleted() {
        return this.replay && this.extractor == null;
    }

    private synchronized void cleanResults() {
        this.datalist = new LinkedList();
    }
}

