/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eos.monitoring.DataBaseEventExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DashboardDataCollector;
import org.ow2.jasmine.monitoring.eos.monitoring.service.Extractor;

public class DatabaseExtractor
extends Extractor {
    private static SimpleDateFormat format;

    public DatabaseExtractor(DashboardDataCollector dbc, Date from, Date to) {
        super(dbc, from, to);
        format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public void run() {
        HashSet<String> servers = new HashSet<String>();
        HashSet<String> probes = new HashSet<String>();
        for (Serie element : this.dbc.getSeries()) {
            probes.add(element.getYcol());
            if (element.getServer() == null) continue;
            servers.add(element.getServer());
        }
        DataBaseEventExtractor dataBaseEventExtractor = new DataBaseEventExtractor();
        JasmineEventEB[] events = null;
        try {
            events = dataBaseEventExtractor.getEvents(servers, probes, this.from, this.to);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot read database: " + e), new Object[0]);
            this.dbc.setReplayCompleted();
            return;
        }
        if (events == null) {
            logger.debug((Object)"Nothing read from database", new Object[0]);
            this.dbc.setReplayCompleted();
            return;
        }
        for (JasmineEventEB elem : events) {
            for (Serie curser : this.dbc.getSeries()) {
                if (!elem.getProbe().endsWith(":" + curser.getYcol()) || !this.dbc.match(elem.getMBean(), curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(elem.getServer())) continue;
                String dateConverted = format.format(elem.getTimestamp());
                EventData ed = new EventData(curser.getId(), dateConverted, elem.getValue().toString());
                this.dbc.addResult(ed);
            }
        }
        this.dbc.setReplayCompleted();
    }
}

