/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DashboardDataCollector;
import org.ow2.jasmine.monitoring.eos.monitoring.service.Extractor;

public class HeaderFileExtractor
extends Extractor {
    private String header;
    private BufferedReader buffer;
    private int dateind;

    public HeaderFileExtractor(DashboardDataCollector dbc, String header, int dateind, BufferedReader buffer, Date from, Date to) {
        super(dbc, from, to);
        this.header = header;
        this.buffer = buffer;
        this.dateind = dateind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String[] headerArray = this.header.split(";");
        int mbeanCol = -1;
        int serverCol = -1;
        HashMap<String, Integer> valueCol = new HashMap<String, Integer>();
        for (int index = 0; index < headerArray.length; ++index) {
            if (headerArray[index].equals("server")) {
                serverCol = index;
            }
            if (headerArray[index].equals("mbean")) {
                mbeanCol = index;
            }
            for (Serie afil : this.dbc.getSeries()) {
                if (!afil.getYcol().equals(headerArray[index])) continue;
                valueCol.put(afil.getId(), new Integer(index));
            }
        }
        if (serverCol == -1) {
            logger.error((Object)"Bad log file: No server in header", new Object[0]);
        }
        if (mbeanCol == -1) {
            logger.error((Object)"Bad log file: No mbean in header", new Object[0]);
        }
        String line = "";
        try {
            while ((line = this.buffer.readLine()) != null) {
                String[] split = line.split(";");
                if (split.length < headerArray.length) continue;
                String date = split[this.dateind];
                String server = split[serverCol];
                String mbeanattr = split[mbeanCol];
                int index = mbeanattr.lastIndexOf(":");
                String mbean = mbeanattr.substring(0, index);
                for (Serie curser : this.dbc.getSeries()) {
                    Integer valueIndex = (Integer)valueCol.get(curser.getId());
                    if (valueIndex == null) continue;
                    String value = split[valueIndex];
                    if (!this.dbc.match(mbean, curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(server)) continue;
                    EventData ed = new EventData(curser.getId(), date, value);
                    this.dbc.addResult(ed);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error reading file: " + e), new Object[0]);
        }
        finally {
            this.dbc.setReplayCompleted();
        }
    }
}

