/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DashboardDataCollector;
import org.ow2.jasmine.monitoring.eos.monitoring.service.Extractor;

public class FileExtractor
extends Extractor {
    private BufferedReader buffer;

    public FileExtractor(DashboardDataCollector dbc, BufferedReader buffer, Date from, Date to) {
        super(dbc, from, to);
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String line = "";
        try {
            while ((line = this.buffer.readLine()) != null) {
                String[] split = line.split(";");
                if (split.length <= 6) continue;
                String date = split[1];
                String server = split[4];
                String mbeanattr = split[5];
                int index = mbeanattr.lastIndexOf(":");
                String mbean = mbeanattr.substring(0, index);
                String attr = mbeanattr.substring(index + 1);
                String value = split[6];
                for (Serie curser : this.dbc.getSeries()) {
                    if (!attr.equals(curser.getYcol()) || !this.dbc.match(mbean, curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(server)) continue;
                    EventData ed = new EventData(curser.getId(), date, value);
                    this.dbc.addResult(ed);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error reading file: " + e), new Object[0]);
        }
        finally {
            this.dbc.setReplayCompleted();
        }
    }
}

