/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class ReplayFileName
implements Serializable {
    private Date date;
    private String directory = "";
    private String name = "";
    private long size = 0L;
    private long dateFirst;
    private long dateLast;
    private boolean headerType = false;
    private int timeIndex = 0;
    private String separator;

    public void setHeaderType(boolean headerType) {
        this.headerType = headerType;
    }

    public boolean isHeaderType() {
        return this.headerType;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public long getDateFirst() {
        return this.dateFirst;
    }

    public void setDateFirst(long dateFirst) {
        this.dateFirst = dateFirst;
    }

    public long getDateLast() {
        return this.dateLast;
    }

    public void setDateLast(long dateLast) {
        this.dateLast = dateLast;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public boolean validate() {
        File file = new File(this.directory, this.name);
        if (!file.exists()) {
            return false;
        }
        String line = "";
        try {
            FileReader fr = new FileReader(file);
            BufferedReader buffer = new BufferedReader(fr);
            buffer.mark(500);
            line = buffer.readLine();
            if (line == null) {
                return false;
            }
            if (line.startsWith("date")) {
                this.headerType = true;
                this.timeIndex = 1;
            } else if (line.startsWith("time")) {
                this.headerType = true;
                this.timeIndex = 0;
            } else {
                this.headerType = false;
                this.timeIndex = 0;
            }
            if (!this.headerType) {
                buffer.reset();
            }
            long timestampFirst = Long.MAX_VALUE;
            long timestampLast = Long.MIN_VALUE;
            int nblines = 0;
            int nberrors = 0;
            while ((line = buffer.readLine()) != null) {
                String[] split = line.split(";");
                if (split.length <= 6) {
                    ++nberrors;
                    continue;
                }
                try {
                    long timestamp = new Long(split[this.timeIndex]);
                    if (timestamp < timestampFirst) {
                        timestampFirst = timestamp;
                    }
                    if (timestamp > timestampLast) {
                        timestampLast = timestamp;
                    }
                    ++nblines;
                }
                catch (NumberFormatException e) {
                    ++nberrors;
                }
            }
            if (nblines == 0 || nberrors > nblines || timestampFirst > timestampLast) {
                return false;
            }
            this.dateFirst = timestampFirst;
            this.dateLast = timestampLast;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

