/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DashboardDataCollector;
import org.ow2.jasmine.monitoring.eos.monitoring.service.Extractor;

public class HeaderFileExtractor
extends Extractor {
    private String header;
    private BufferedReader buffer;
    private int dateind;
    private long fromTimestamp = 0L;
    private long toTimestamp = 0L;

    public HeaderFileExtractor(DashboardDataCollector dbc, String header, int dateind, BufferedReader buffer, Date from, Date to) {
        super(dbc);
        this.setDateLimits(from, to);
        this.header = header;
        this.buffer = buffer;
        this.dateind = dateind;
        if (from != null) {
            this.fromTimestamp = from.getTime();
        }
        if (to != null) {
            this.toTimestamp = to.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.debug((Object)"start reading header file", new Object[0]);
        String[] headerArray = this.header.split(";");
        int mbeanCol = -1;
        int serverCol = -1;
        int timestampCol = -1;
        HashMap<String, Integer> valueCol = new HashMap<String, Integer>();
        for (int index = 0; index < headerArray.length; ++index) {
            if (headerArray[index].equals("server")) {
                serverCol = index;
            }
            if (headerArray[index].equals("mbean")) {
                mbeanCol = index;
            }
            if (headerArray[index].equals("time")) {
                timestampCol = index;
            }
            for (Serie afil : this.dbc.getSeries()) {
                if (!afil.getYcol().equals(headerArray[index])) continue;
                valueCol.put(afil.getId(), new Integer(index));
            }
        }
        if (serverCol == -1) {
            logger.error((Object)"Bad log file: No server in header", new Object[0]);
        }
        if (mbeanCol == -1) {
            logger.error((Object)"Bad log file: No mbean in header", new Object[0]);
        }
        if (timestampCol == -1) {
            logger.error((Object)"Bad log file: No time in header", new Object[0]);
        }
        String line = "";
        long timestamp = 0L;
        try {
            while (!this.stopWanted) {
                line = this.buffer.readLine();
                if (line == null) {
                    if (timestamp >= this.toTimestamp) {
                        logger.debug((Object)"End of file", new Object[0]);
                        break;
                    }
                    logger.debug((Object)"Wait for new event", new Object[0]);
                    Thread.sleep(5000L);
                    continue;
                }
                String[] split = line.split(";");
                if (split.length < headerArray.length) continue;
                String date = split[this.dateind];
                String server = split[serverCol];
                timestamp = new Long(split[timestampCol]);
                if (timestamp < this.fromTimestamp) continue;
                if (this.toTimestamp > 0L && timestamp > this.toTimestamp) {
                    logger.debug((Object)"ignoring the rest of the file : not in the time range", new Object[0]);
                    break;
                }
                String mbean = split[mbeanCol];
                for (Serie curser : this.dbc.getSeries()) {
                    Integer valueIndex = (Integer)valueCol.get(curser.getId());
                    if (valueIndex == null) continue;
                    String value = split[valueIndex];
                    if (!this.dbc.match(mbean, curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(server)) continue;
                    EventData ed = new EventData(curser.getId(), timestamp, value);
                    this.dbc.addResult(ed);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error reading file: " + e), new Object[0]);
        }
        catch (InterruptedException e) {
            logger.warn((Object)"Interrupted", new Object[0]);
        }
        finally {
            this.dbc.setReplayCompleted();
        }
    }
}

