/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.eos.monitoring.ConfigFile;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.ReplayFileName;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DashboardDataCollector;
import org.ow2.jasmine.monitoring.eos.monitoring.service.NameFilter;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringService
implements Serializable {
    private static final long serialVersionUID = 8402643661543808499L;
    private final Log logger = LogFactory.getLog(this.getClass());
    private Map<Integer, DashboardDataCollector> dashboardList;
    private Set<String> replaydirlist;
    private Set<String> configdirlist;
    private int dashboardIdent = 0;
    private String eostemp;

    public MonitoringService() {
        this.logger.debug((Object)"", new Object[0]);
        this.dashboardList = new HashMap<Integer, DashboardDataCollector>();
        this.readConfig();
    }

    public ArrayList<ConfigFile> getConfigFiles() throws Exception {
        ArrayList<ConfigFile> result = new ArrayList<ConfigFile>();
        for (String dir : this.configdirlist) {
            result.addAll(this.getXmlFiles(dir));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadConfigFile(String path) throws Exception {
        String string;
        FileReader fileReader;
        block18: {
            this.logger.debug((Object)("Load config file: " + path), new Object[0]);
            String result = "";
            fileReader = null;
            BufferedReader buffer = null;
            File file = new File(path);
            if (!file.exists()) {
                file = new File(JProp.getJonasBase() + File.separator + path);
            }
            if (!file.exists()) {
                throw new Exception("Impossible to locate the file: " + path);
            }
            String endofline = System.getProperty("line.separator");
            try {
                fileReader = new FileReader(file);
                buffer = new BufferedReader(fileReader);
                boolean write = false;
                String line = "";
                while ((line = buffer.readLine()) != null) {
                    if (line.contains("<monitor")) {
                        write = true;
                    }
                    if (!write) continue;
                    result = result + line + endofline;
                }
                if (!write) {
                    throw new Exception("Bad configuration file: No 'monitor' tag found.");
                }
                string = result;
                if (buffer == null) break block18;
            }
            catch (Throwable throwable) {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Failed closing buffer", new Object[]{e});
                    }
                }
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Failed closing fileReader", new Object[]{e});
                    }
                }
                throw throwable;
            }
            try {
                buffer.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed closing buffer", new Object[]{e});
            }
        }
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed closing fileReader", new Object[]{e});
            }
        }
        return string;
    }

    public ArrayList<ConfigFile> saveConfigFile(String name, String file) throws Exception {
        this.logger.debug((Object)("Save config file:" + name), new Object[0]);
        String newName = name;
        if (!newName.endsWith(".xml")) {
            newName = newName + ".xml";
        }
        File pathname = new File(JProp.getJonasBase() + File.separator + "monitoring" + File.separator + newName);
        FileWriter f = new FileWriter(pathname);
        f.write(file);
        f.close();
        return this.getConfigFiles();
    }

    public ArrayList<ConfigFile> removeConfigFile(ConfigFile file) throws Exception {
        this.logger.debug((Object)("Remove config file:" + file.getName()), new Object[0]);
        for (String strdir : this.configdirlist) {
            this.logger.debug((Object)strdir, new Object[0]);
            if (!strdir.endsWith(file.getDirectory())) continue;
            File dir = new File(strdir);
            if (!dir.exists()) {
                this.logger.error((Object)("cannot find directory " + strdir), new Object[0]);
                break;
            }
            File f = new File(dir, file.getName());
            f.delete();
            this.logger.debug((Object)(file.getName() + " removed"), new Object[0]);
            break;
        }
        return this.getConfigFiles();
    }

    public ArrayList<ConfigFile> renameConfigFile(ConfigFile file, String newname) throws Exception {
        this.logger.debug((Object)("Rename config file:" + file.getName()), new Object[0]);
        String newName = newname;
        if (!newName.endsWith(".xml")) {
            newName = newName + ".xml";
        }
        for (String strdir : this.configdirlist) {
            this.logger.debug((Object)strdir, new Object[0]);
            if (!strdir.endsWith(file.getDirectory())) continue;
            File dir = new File(strdir);
            if (!dir.exists()) {
                this.logger.error((Object)("cannot find " + strdir), new Object[0]);
                break;
            }
            File f = new File(dir, file.getName());
            File dest = new File(dir, newName);
            f.renameTo(dest);
            this.logger.debug((Object)(file.getName() + " renamed to " + newName), new Object[0]);
            break;
        }
        return this.getConfigFiles();
    }

    public int createDashboard(List<Serie> series) throws Exception {
        int uuid = ++this.dashboardIdent;
        this.logger.debug((Object)("dbid=" + uuid), new Object[0]);
        DashboardDataCollector dbc = new DashboardDataCollector(uuid, series);
        this.dashboardList.put(uuid, dbc);
        return uuid;
    }

    public void removeDashboard(int dashboard) throws Exception {
        this.logger.debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = this.dashboardList.remove(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
    }

    public void startMonitoring(int dashboard) throws Exception {
        this.logger.debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = this.dashboardList.get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        dbc.startLiveMonitoring();
    }

    public void stopMonitoring(int dashboard) throws Exception {
        this.logger.debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = this.dashboardList.get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        dbc.stopLiveMonitoring();
    }

    public List<EventData> getAllResults(int dashboard) throws Exception {
        this.logger.debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = this.dashboardList.get(dashboard);
        if (dbc == null) {
            this.logger.debug((Object)("dashboardList size = " + this.dashboardList.size()), new Object[0]);
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        return dbc.getAllResults();
    }

    public void startFileReplay(int dashboard, String fileName, Date from, Date to) throws Exception {
        this.logger.debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = this.dashboardList.get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        dbc.startFileReplay(fileName, from, to);
    }

    public void startDatabaseReplay(int dashboard, Date from, Date to) throws Exception {
        this.logger.debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = this.dashboardList.get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        dbc.startDatabaseReplay(from, to);
    }

    public long getDatabaseLimits(int dashboard) throws Exception {
        this.logger.debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = this.dashboardList.get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        return dbc.getDatabaseLimits();
    }

    public ArrayList<ReplayFileName> getReplayFilenames(String filter, String filename) throws Exception {
        this.logger.debug((Object)filename, new Object[0]);
        ArrayList<ReplayFileName> result = new ArrayList<ReplayFileName>();
        String base = null;
        if (filename.length() > 0) {
            File file = new File(filename);
            base = file.getName();
        }
        if (base != null) {
            result.addAll(this.getReplayFiles(this.eostemp, filter));
        } else {
            for (String dir : this.replaydirlist) {
                result.addAll(this.getReplayFiles(dir, filter));
            }
        }
        return result;
    }

    private ArrayList<ReplayFileName> getReplayFiles(String directory, String filter) {
        this.logger.debug((Object)directory, new Object[0]);
        ArrayList<ReplayFileName> result = new ArrayList<ReplayFileName>();
        File dir = new File(directory);
        if (!dir.exists()) {
            dir = new File(JProp.getJonasBase() + File.separator + directory);
        }
        if (!dir.exists()) {
            this.logger.debug((Object)("cannot find directory " + directory), new Object[0]);
            this.logger.debug((Object)("Nor in absolute, neither in " + JProp.getJonasBase()), new Object[0]);
            return result;
        }
        File[] files = dir.listFiles(new NameFilter(filter));
        if (files == null) {
            this.logger.debug((Object)("no files found in " + directory), new Object[0]);
            return result;
        }
        for (int i = 0; i < files.length; ++i) {
            ReplayFileName rfn = new ReplayFileName();
            rfn.setDirectory(dir.getPath());
            rfn.setName(files[i].getName());
            rfn.setSize(files[i].length());
            rfn.setDate(new Date(files[i].lastModified()));
            rfn.setSeparator(File.separator);
            if (!rfn.validate()) continue;
            result.add(rfn);
            this.logger.debug((Object)("found " + files[i].getName()), new Object[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConfigFile(File file) {
        BufferedReader buffer;
        FileReader fileReader;
        block26: {
            boolean bl;
            block24: {
                block25: {
                    fileReader = null;
                    buffer = null;
                    try {
                        fileReader = new FileReader(file);
                        buffer = new BufferedReader(fileReader);
                        String line = "";
                        while ((line = buffer.readLine()) != null) {
                            if (!line.contains("<monitor")) continue;
                            bl = true;
                            if (buffer == null) break block24;
                            break block25;
                        }
                        break block26;
                    }
                    catch (Exception e) {
                        if (buffer != null) {
                            try {
                                buffer.close();
                            }
                            catch (Exception e2) {
                                this.logger.error((Object)"Failed closing buffer", new Object[]{e2});
                            }
                        }
                        if (fileReader == null) return false;
                        try {
                            fileReader.close();
                            return false;
                        }
                        catch (Exception e3) {
                            this.logger.error((Object)"Failed closing fileReader", new Object[]{e3});
                            return false;
                        }
                        catch (Throwable throwable) {
                            if (buffer != null) {
                                try {
                                    buffer.close();
                                }
                                catch (Exception e4) {
                                    this.logger.error((Object)"Failed closing buffer", new Object[]{e4});
                                }
                            }
                            if (fileReader == null) throw throwable;
                            try {
                                fileReader.close();
                                throw throwable;
                            }
                            catch (Exception e5) {
                                this.logger.error((Object)"Failed closing fileReader", new Object[]{e5});
                            }
                            throw throwable;
                        }
                    }
                }
                try {
                    buffer.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Failed closing buffer", new Object[]{e});
                }
            }
            if (fileReader == null) return bl;
            try {
                fileReader.close();
                return bl;
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed closing fileReader", new Object[]{e});
            }
            return bl;
        }
        if (buffer != null) {
            try {
                buffer.close();
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed closing buffer", new Object[]{e});
            }
        }
        if (fileReader == null) return false;
        try {
            fileReader.close();
            return false;
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed closing fileReader", new Object[]{e});
            return false;
        }
    }

    private ArrayList<ConfigFile> getXmlFiles(String directory) {
        ArrayList<ConfigFile> result = new ArrayList<ConfigFile>();
        File dir = new File(directory);
        if (!dir.exists()) {
            dir = new File(JProp.getJonasBase() + File.separator + directory);
        }
        if (!dir.exists()) {
            this.logger.error((Object)("cannot find " + directory), new Object[0]);
            return result;
        }
        this.logger.debug((Object)dir.getPath(), new Object[0]);
        File[] files = dir.listFiles(new NameFilter("*.xml"));
        if (files == null) {
            this.logger.warn((Object)("no files found in " + directory), new Object[0]);
            return result;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!this.isConfigFile(files[i])) continue;
            ConfigFile rfn = new ConfigFile();
            rfn.setDirectory(dir.getPath());
            rfn.setName(files[i].getName());
            rfn.setSize(files[i].length());
            rfn.setDate(new Date(files[i].lastModified()));
            rfn.setSeparator(File.separator);
            result.add(rfn);
            this.logger.debug((Object)("found " + files[i].getName()), new Object[0]);
        }
        return result;
    }

    private void readConfig() {
        int i;
        JProp config = JProp.getInstance((String)"jasmine-monitoring.properties");
        this.replaydirlist = new HashSet<String>();
        String[] list = config.getValueAsArray("jasmine.monitoring.replaydir");
        if (list == null) {
            this.logger.debug((Object)"Missing jasmine-monitoring.properties: take default values", new Object[0]);
            this.replaydirlist.add("monitoring");
        } else {
            for (i = 0; i < list.length; ++i) {
                this.replaydirlist.add(list[i]);
            }
        }
        this.eostemp = System.getProperty("java.io.tmpdir") + File.separatorChar + "EoS.temp";
        this.replaydirlist.add(this.eostemp);
        this.configdirlist = new HashSet<String>();
        list = config.getValueAsArray("jasmine.monitoring.configdir");
        if (list == null) {
            this.logger.debug((Object)"No jasmine-monitoring.properties: take default values", new Object[0]);
            this.configdirlist.add(JProp.getJonasBase() + File.separator + "monitoring");
        } else {
            for (i = 0; i < list.length; ++i) {
                String directory = list[i];
                File dir = new File(directory);
                if (!dir.exists()) {
                    directory = JProp.getJonasBase() + File.separator + directory;
                    dir = new File(directory);
                }
                if (dir.exists()) {
                    this.configdirlist.add(directory);
                    continue;
                }
                this.logger.error((Object)("cannot find " + list[i]), new Object[0]);
            }
        }
        this.configdirlist.add(this.eostemp);
    }

    private boolean match(String strmbean, String strpattern) {
        if (strpattern == null || strpattern.length() == 0 || strpattern.equals("*:*")) {
            return true;
        }
        ObjectName mbean = null;
        ObjectName pattern = null;
        try {
            mbean = new ObjectName(strmbean);
        }
        catch (MalformedObjectNameException e) {
            this.logger.error((Object)("Bad MBean ObjectName (MalformedObjectNameException) " + strmbean), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            this.logger.error((Object)("Bad MBean ObjectName (NPE) " + strmbean), new Object[0]);
            return false;
        }
        try {
            pattern = new ObjectName(strpattern);
        }
        catch (MalformedObjectNameException e) {
            this.logger.error((Object)("Bad Pattern ObjectName (MalformedObjectNameException) " + strpattern), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            this.logger.error((Object)("Bad Pattern ObjectName (NPE) " + strpattern), new Object[0]);
            return false;
        }
        if (pattern == null) {
            this.logger.error((Object)("Cannot get ObjectName on " + strpattern), new Object[0]);
            return false;
        }
        return pattern.apply(mbean);
    }
}

