/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;

public class NameFilter
implements FilenameFilter {
    private String[] filters = null;

    public NameFilter(String filter) {
        StringTokenizer st = new StringTokenizer(filter, ",");
        int tokenCount = st.countTokens();
        this.filters = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            this.filters[i] = st.nextToken();
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        if (name.endsWith("~")) {
            return false;
        }
        File file = new File(dir, name);
        if (!file.isFile()) {
            return false;
        }
        for (int i = 0; i < this.filters.length; ++i) {
            if (!this.matchFile(name, this.filters[i])) continue;
            return true;
        }
        return false;
    }

    private boolean matchFile(String name, String filter) {
        int first = filter.indexOf(42);
        if (first > 0 && !name.startsWith(filter.substring(0, first))) {
            return false;
        }
        int last = filter.lastIndexOf(42);
        return last < 0 || last >= filter.length() || name.endsWith(filter.substring(last + 1));
    }
}

