/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Date;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DashboardDataCollector;
import org.ow2.jasmine.monitoring.eos.monitoring.service.Extractor;

public class FileExtractor
extends Extractor {
    private BufferedReader buffer;
    private long fromTimestamp = 0L;
    private long toTimestamp = 0L;

    public FileExtractor(DashboardDataCollector dbc, BufferedReader buffer, Date from, Date to) {
        super(dbc);
        this.setDateLimits(from, to);
        this.buffer = buffer;
        if (from != null) {
            this.fromTimestamp = from.getTime();
        }
        if (to != null) {
            this.toTimestamp = to.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug((Object)"start reading file", new Object[0]);
        String line = "";
        long timestamp = 0L;
        try {
            while (!this.stopWanted) {
                line = this.buffer.readLine();
                if (line == null) {
                    if (timestamp >= this.toTimestamp) {
                        logger.debug((Object)"End of file", new Object[0]);
                        break;
                    }
                    logger.debug((Object)"Wait for new event", new Object[0]);
                    Thread.sleep(5000L);
                    continue;
                }
                String[] split = line.split(";");
                if (split.length <= 6) {
                    logger.debug((Object)("ignore incomplete line: " + line), new Object[0]);
                    continue;
                }
                timestamp = new Long(split[0]);
                String date = split[1];
                String server = split[4];
                if (timestamp < this.fromTimestamp) continue;
                if (this.toTimestamp > 0L && timestamp > this.toTimestamp) {
                    logger.debug((Object)"ignoring the rest of the file : not in the time range", new Object[0]);
                    break;
                }
                String mbeanattr = split[5];
                int index = mbeanattr.lastIndexOf(":");
                String mbean = mbeanattr.substring(0, index);
                String attr = mbeanattr.substring(index + 1);
                String value = split[6];
                for (Serie curser : this.dbc.getSeries()) {
                    if (!this.attrmatch(attr, curser.getYcol()) || !this.dbc.match(mbean, curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(server)) continue;
                    EventData ed = new EventData(curser.getId(), timestamp, value);
                    this.dbc.addResult(ed);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error reading file: " + e), new Object[0]);
        }
        catch (InterruptedException e) {
            logger.warn((Object)"Interrupted", new Object[0]);
        }
        finally {
            this.dbc.setReplayCompleted();
        }
    }
}

