/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.monitoring.eos.common.servlet.ExportBitmapServlet;
import org.ow2.jasmine.monitoring.eos.common.servlet.UploadFileServlet;
import org.ow2.jasmine.monitoring.eos.monitoring.ConfigFile;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.ReplayFileName;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DashboardDataCollector;
import org.ow2.jasmine.monitoring.eos.monitoring.service.NameFilter;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.kerneos.core.service.KerneosSimpleService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component
@Instantiate
@Provides
public class MonitoringService
implements KerneosSimpleService,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private final Log logger;
    private boolean __Fid;
    @ServiceProperty(name="kerneos-service-id", value="monitoringService")
    private String id;
    private boolean __FdashboardList;
    private Map<Integer, DashboardDataCollector> dashboardList;
    private boolean __Freplaydirlist;
    private Set<String> replaydirlist;
    private boolean __Fconfigdirlist;
    private Set<String> configdirlist;
    private boolean __FhttpService;
    @Requires
    private HttpService httpService;
    private boolean __FkerneosHttpContext;
    @Requires(filter="(ID=jasmine-eos)")
    private HttpContext kerneosHttpContext;
    private boolean __FdashboardIdent;
    private int dashboardIdent;
    private boolean __Feostemp;
    private String eostemp;
    private boolean __Mstart;
    private boolean __MregisterServlets;
    private boolean __MgetConfigFiles;
    private boolean __MloadConfigFile$java_lang_String;
    private boolean __MsaveConfigFile$java_lang_String$java_lang_String;
    private boolean __MremoveConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile;
    private boolean __MrenameConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile$java_lang_String;
    private boolean __McreateDashboard$java_util_List$boolean;
    private boolean __MremoveDashboard$int;
    private boolean __MstartMonitoring$int;
    private boolean __MstopMonitoring$int;
    private boolean __MgetAllResults$int;
    private boolean __MgetAllNotifs$int;
    private boolean __MstartFileReplay$int$java_lang_String$java_util_Date$java_util_Date;
    private boolean __MstartDatabaseReplay$int$java_util_Date$java_util_Date;
    private boolean __MgetDatabaseLimits$int;
    private boolean __MgetReplayFilenames$java_lang_String$java_lang_String;
    private boolean __MgetReplayFiles$java_lang_String$java_lang_String;
    private boolean __MisConfigFile$java_io_File;
    private boolean __MgetXmlFiles$java_lang_String;
    private boolean __MreadConfig;
    private boolean __Mmatch$java_lang_String$java_lang_String;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    String __getid() {
        if (!this.__Fid) {
            return this.id;
        }
        return (String)this.__IM.onGet((Object)this, "id");
    }

    void __setid(String string) {
        if (!this.__Fid) {
            this.id = string;
            return;
        }
        this.__IM.onSet((Object)this, "id", (Object)string);
    }

    Map __getdashboardList() {
        if (!this.__FdashboardList) {
            return this.dashboardList;
        }
        return (Map)this.__IM.onGet((Object)this, "dashboardList");
    }

    void __setdashboardList(Map map) {
        if (!this.__FdashboardList) {
            this.dashboardList = map;
            return;
        }
        this.__IM.onSet((Object)this, "dashboardList", (Object)map);
    }

    Set __getreplaydirlist() {
        if (!this.__Freplaydirlist) {
            return this.replaydirlist;
        }
        return (Set)this.__IM.onGet((Object)this, "replaydirlist");
    }

    void __setreplaydirlist(Set set) {
        if (!this.__Freplaydirlist) {
            this.replaydirlist = set;
            return;
        }
        this.__IM.onSet((Object)this, "replaydirlist", (Object)set);
    }

    Set __getconfigdirlist() {
        if (!this.__Fconfigdirlist) {
            return this.configdirlist;
        }
        return (Set)this.__IM.onGet((Object)this, "configdirlist");
    }

    void __setconfigdirlist(Set set) {
        if (!this.__Fconfigdirlist) {
            this.configdirlist = set;
            return;
        }
        this.__IM.onSet((Object)this, "configdirlist", (Object)set);
    }

    HttpService __gethttpService() {
        if (!this.__FhttpService) {
            return this.httpService;
        }
        return (HttpService)this.__IM.onGet((Object)this, "httpService");
    }

    void __sethttpService(HttpService httpService) {
        if (!this.__FhttpService) {
            this.httpService = httpService;
            return;
        }
        this.__IM.onSet((Object)this, "httpService", (Object)httpService);
    }

    HttpContext __getkerneosHttpContext() {
        if (!this.__FkerneosHttpContext) {
            return this.kerneosHttpContext;
        }
        return (HttpContext)this.__IM.onGet((Object)this, "kerneosHttpContext");
    }

    void __setkerneosHttpContext(HttpContext httpContext) {
        if (!this.__FkerneosHttpContext) {
            this.kerneosHttpContext = httpContext;
            return;
        }
        this.__IM.onSet((Object)this, "kerneosHttpContext", (Object)httpContext);
    }

    int __getdashboardIdent() {
        if (!this.__FdashboardIdent) {
            return this.dashboardIdent;
        }
        Object object = this.__IM.onGet((Object)this, "dashboardIdent");
        Integer n = (Integer)object;
        return n;
    }

    void __setdashboardIdent(int n) {
        if (!this.__FdashboardIdent) {
            this.dashboardIdent = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "dashboardIdent", (Object)n2);
    }

    String __geteostemp() {
        if (!this.__Feostemp) {
            return this.eostemp;
        }
        return (String)this.__IM.onGet((Object)this, "eostemp");
    }

    void __seteostemp(String string) {
        if (!this.__Feostemp) {
            this.eostemp = string;
            return;
        }
        this.__IM.onSet((Object)this, "eostemp", (Object)string);
    }

    public MonitoringService() {
        this(null);
    }

    private MonitoringService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(this.getClass()));
        this.__setdashboardIdent(0);
    }

    private void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.__getlogger().debug((Object)"", new Object[0]);
        this.__setdashboardList(new HashMap());
        this.readConfig();
        this.registerServlets();
    }

    private void registerServlets() {
        if (!this.__MregisterServlets) {
            this.__registerServlets();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerServlets", new Object[0]);
            this.__registerServlets();
            this.__IM.onExit((Object)this, "registerServlets", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerServlets", throwable);
            throw throwable;
        }
    }

    private void __registerServlets() {
        UploadFileServlet s1 = new UploadFileServlet();
        try {
            this.__gethttpService().registerServlet("/UploadFileServlet", (Servlet)s1, null, this.__getkerneosHttpContext());
        }
        catch (ServletException e) {
            this.__getlogger().error((Object)("Cannot register UploadFileServlet: " + (Object)((Object)e)), new Object[0]);
        }
        catch (NamespaceException e) {
            this.__getlogger().error((Object)("Cannot register UploadFileServlet: " + (Object)((Object)e)), new Object[0]);
        }
        ExportBitmapServlet s2 = new ExportBitmapServlet();
        try {
            this.__gethttpService().registerServlet("/ExportBitmapServlet", (Servlet)s2, null, this.__getkerneosHttpContext());
        }
        catch (ServletException e) {
            this.__getlogger().error((Object)("Cannot register ExportBitmapServlet: " + (Object)((Object)e)), new Object[0]);
        }
        catch (NamespaceException e) {
            this.__getlogger().error((Object)("Cannot register ExportBitmapServlet: " + (Object)((Object)e)), new Object[0]);
        }
    }

    public ArrayList<ConfigFile> getConfigFiles() throws Exception {
        ArrayList<ConfigFile> arrayList;
        if (!this.__MgetConfigFiles) {
            return this.__getConfigFiles();
        }
        try {
            this.__IM.onEntry((Object)this, "getConfigFiles", new Object[0]);
            arrayList = this.__getConfigFiles();
            this.__IM.onExit((Object)this, "getConfigFiles", arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConfigFiles", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList<ConfigFile> __getConfigFiles() throws Exception {
        this.__getlogger().debug((Object)"", new Object[0]);
        ArrayList<ConfigFile> result = new ArrayList<ConfigFile>();
        for (String dir : this.__getconfigdirlist()) {
            result.addAll(this.getXmlFiles(dir));
        }
        return result;
    }

    public String loadConfigFile(String string) throws Exception {
        String string2;
        if (!this.__MloadConfigFile$java_lang_String) {
            return this.__loadConfigFile(string);
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfigFile$java_lang_String", new Object[]{string});
            string2 = this.__loadConfigFile(string);
            this.__IM.onExit((Object)this, "loadConfigFile$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfigFile$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String __loadConfigFile(String path) throws Exception {
        String string;
        FileReader fileReader;
        block18: {
            this.__getlogger().debug((Object)("Load config file: " + path), new Object[0]);
            String result = "";
            fileReader = null;
            BufferedReader buffer = null;
            File file = new File(path);
            if (!file.exists()) {
                file = new File(JProp.getJonasBase() + File.separator + path);
            }
            if (!file.exists()) {
                throw new Exception("Impossible to locate the file: " + path);
            }
            String endofline = System.getProperty("line.separator");
            try {
                fileReader = new FileReader(file);
                buffer = new BufferedReader(fileReader);
                boolean write = false;
                String line = "";
                while ((line = buffer.readLine()) != null) {
                    if (line.contains("<monitor")) {
                        write = true;
                    }
                    if (!write) continue;
                    result = result + line + endofline;
                }
                if (!write) {
                    throw new Exception("Bad configuration file: No 'monitor' tag found.");
                }
                this.__getlogger().debug((Object)("Config file loaded: " + result), new Object[0]);
                string = result;
                if (buffer == null) break block18;
            }
            catch (Throwable throwable) {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (Exception e) {
                        this.__getlogger().error((Object)"Failed closing buffer", new Object[]{e});
                    }
                }
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Exception e) {
                        this.__getlogger().error((Object)"Failed closing fileReader", new Object[]{e});
                    }
                }
                throw throwable;
            }
            try {
                buffer.close();
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Failed closing buffer", new Object[]{e});
            }
        }
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Failed closing fileReader", new Object[]{e});
            }
        }
        return string;
    }

    public ArrayList<ConfigFile> saveConfigFile(String string, String string2) throws Exception {
        ArrayList<ConfigFile> arrayList;
        if (!this.__MsaveConfigFile$java_lang_String$java_lang_String) {
            return this.__saveConfigFile(string, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "saveConfigFile$java_lang_String$java_lang_String", new Object[]{string, string2});
            arrayList = this.__saveConfigFile(string, string2);
            this.__IM.onExit((Object)this, "saveConfigFile$java_lang_String$java_lang_String", arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveConfigFile$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList<ConfigFile> __saveConfigFile(String name, String file) throws Exception {
        this.__getlogger().debug((Object)("Save config file:" + name), new Object[0]);
        String newName = name;
        if (!newName.endsWith(".xml")) {
            newName = newName + ".xml";
        }
        File pathname = new File(JProp.getJonasBase() + File.separator + "monitoring" + File.separator + newName);
        FileWriter f = new FileWriter(pathname);
        f.write(file);
        f.close();
        return this.getConfigFiles();
    }

    public ArrayList<ConfigFile> removeConfigFile(ConfigFile configFile) throws Exception {
        ArrayList<ConfigFile> arrayList;
        if (!this.__MremoveConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile) {
            return this.__removeConfigFile(configFile);
        }
        try {
            this.__IM.onEntry((Object)this, "removeConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile", new Object[]{configFile});
            arrayList = this.__removeConfigFile(configFile);
            this.__IM.onExit((Object)this, "removeConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile", arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList<ConfigFile> __removeConfigFile(ConfigFile file) throws Exception {
        this.__getlogger().debug((Object)("Remove config file:" + file.getName()), new Object[0]);
        for (String strdir : this.__getconfigdirlist()) {
            this.__getlogger().debug((Object)strdir, new Object[0]);
            if (!strdir.endsWith(file.getDirectory())) continue;
            File dir = new File(strdir);
            if (!dir.exists()) {
                this.__getlogger().error((Object)("cannot find directory " + strdir), new Object[0]);
                break;
            }
            File f = new File(dir, file.getName());
            f.delete();
            this.__getlogger().debug((Object)(file.getName() + " removed"), new Object[0]);
            break;
        }
        return this.getConfigFiles();
    }

    public ArrayList<ConfigFile> renameConfigFile(ConfigFile configFile, String string) throws Exception {
        ArrayList<ConfigFile> arrayList;
        if (!this.__MrenameConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile$java_lang_String) {
            return this.__renameConfigFile(configFile, string);
        }
        try {
            this.__IM.onEntry((Object)this, "renameConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile$java_lang_String", new Object[]{configFile, string});
            arrayList = this.__renameConfigFile(configFile, string);
            this.__IM.onExit((Object)this, "renameConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile$java_lang_String", arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "renameConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile$java_lang_String", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList<ConfigFile> __renameConfigFile(ConfigFile file, String newname) throws Exception {
        this.__getlogger().debug((Object)("Rename config file:" + file.getName()), new Object[0]);
        String newName = newname;
        if (!newName.endsWith(".xml")) {
            newName = newName + ".xml";
        }
        for (String strdir : this.__getconfigdirlist()) {
            this.__getlogger().debug((Object)strdir, new Object[0]);
            if (!strdir.endsWith(file.getDirectory())) continue;
            File dir = new File(strdir);
            if (!dir.exists()) {
                this.__getlogger().error((Object)("cannot find " + strdir), new Object[0]);
                break;
            }
            File f = new File(dir, file.getName());
            File dest = new File(dir, newName);
            f.renameTo(dest);
            this.__getlogger().debug((Object)(file.getName() + " renamed to " + newName), new Object[0]);
            break;
        }
        return this.getConfigFiles();
    }

    public int createDashboard(List<Serie> list, boolean bl) throws Exception {
        int n;
        if (!this.__McreateDashboard$java_util_List$boolean) {
            return this.__createDashboard(list, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "createDashboard$java_util_List$boolean", new Object[]{list, new Boolean(bl)});
            n = this.__createDashboard(list, bl);
            this.__IM.onExit((Object)this, "createDashboard$java_util_List$boolean", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createDashboard$java_util_List$boolean", throwable);
            throw throwable;
        }
        return n;
    }

    private int __createDashboard(List<Serie> series, boolean notifications) throws Exception {
        MonitoringService monitoringService = this;
        int n = monitoringService.__getdashboardIdent() + 1;
        monitoringService.__setdashboardIdent(n);
        int uuid = n;
        this.__getlogger().debug((Object)("dbid=" + uuid), new Object[0]);
        DashboardDataCollector dbc = new DashboardDataCollector(uuid, series, notifications);
        this.__getdashboardList().put(uuid, dbc);
        this.__getlogger().debug((Object)("db created =" + uuid), new Object[0]);
        return uuid;
    }

    public void removeDashboard(int n) throws Exception {
        if (!this.__MremoveDashboard$int) {
            this.__removeDashboard(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeDashboard$int", new Object[]{new Integer(n)});
            this.__removeDashboard(n);
            this.__IM.onExit((Object)this, "removeDashboard$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeDashboard$int", throwable);
            throw throwable;
        }
    }

    private void __removeDashboard(int dashboard) throws Exception {
        this.__getlogger().debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = (DashboardDataCollector)this.__getdashboardList().remove(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
    }

    public void startMonitoring(int n) throws Exception {
        if (!this.__MstartMonitoring$int) {
            this.__startMonitoring(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startMonitoring$int", new Object[]{new Integer(n)});
            this.__startMonitoring(n);
            this.__IM.onExit((Object)this, "startMonitoring$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startMonitoring$int", throwable);
            throw throwable;
        }
    }

    private void __startMonitoring(int dashboard) throws Exception {
        this.__getlogger().debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = (DashboardDataCollector)this.__getdashboardList().get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        dbc.startLiveMonitoring();
    }

    public void stopMonitoring(int n) throws Exception {
        if (!this.__MstopMonitoring$int) {
            this.__stopMonitoring(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopMonitoring$int", new Object[]{new Integer(n)});
            this.__stopMonitoring(n);
            this.__IM.onExit((Object)this, "stopMonitoring$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopMonitoring$int", throwable);
            throw throwable;
        }
    }

    private void __stopMonitoring(int dashboard) throws Exception {
        this.__getlogger().debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = (DashboardDataCollector)this.__getdashboardList().get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        dbc.stopLiveMonitoring();
    }

    public List<EventData> getAllResults(int n) throws Exception {
        List<EventData> list;
        if (!this.__MgetAllResults$int) {
            return this.__getAllResults(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getAllResults$int", new Object[]{new Integer(n)});
            list = this.__getAllResults(n);
            this.__IM.onExit((Object)this, "getAllResults$int", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllResults$int", throwable);
            throw throwable;
        }
        return list;
    }

    private List<EventData> __getAllResults(int dashboard) throws Exception {
        this.__getlogger().debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = (DashboardDataCollector)this.__getdashboardList().get(dashboard);
        if (dbc == null) {
            this.__getlogger().debug((Object)("dashboardList size = " + this.__getdashboardList().size()), new Object[0]);
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        return dbc.getAllResults();
    }

    public List<JasmineEventNotification> getAllNotifs(int n) throws Exception {
        List<JasmineEventNotification> list;
        if (!this.__MgetAllNotifs$int) {
            return this.__getAllNotifs(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getAllNotifs$int", new Object[]{new Integer(n)});
            list = this.__getAllNotifs(n);
            this.__IM.onExit((Object)this, "getAllNotifs$int", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllNotifs$int", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineEventNotification> __getAllNotifs(int dashboard) throws Exception {
        this.__getlogger().debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = (DashboardDataCollector)this.__getdashboardList().get(dashboard);
        if (dbc == null) {
            this.__getlogger().debug((Object)("dashboardList size = " + this.__getdashboardList().size()), new Object[0]);
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        return dbc.getAllNotifs();
    }

    public void startFileReplay(int n, String string, Date date, Date date2) throws Exception {
        if (!this.__MstartFileReplay$int$java_lang_String$java_util_Date$java_util_Date) {
            this.__startFileReplay(n, string, date, date2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startFileReplay$int$java_lang_String$java_util_Date$java_util_Date", new Object[]{new Integer(n), string, date, date2});
            this.__startFileReplay(n, string, date, date2);
            this.__IM.onExit((Object)this, "startFileReplay$int$java_lang_String$java_util_Date$java_util_Date", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startFileReplay$int$java_lang_String$java_util_Date$java_util_Date", throwable);
            throw throwable;
        }
    }

    private void __startFileReplay(int dashboard, String fileName, Date from, Date to) throws Exception {
        this.__getlogger().debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = (DashboardDataCollector)this.__getdashboardList().get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        dbc.startFileReplay(fileName, from, to);
    }

    public void startDatabaseReplay(int n, Date date, Date date2) throws Exception {
        if (!this.__MstartDatabaseReplay$int$java_util_Date$java_util_Date) {
            this.__startDatabaseReplay(n, date, date2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startDatabaseReplay$int$java_util_Date$java_util_Date", new Object[]{new Integer(n), date, date2});
            this.__startDatabaseReplay(n, date, date2);
            this.__IM.onExit((Object)this, "startDatabaseReplay$int$java_util_Date$java_util_Date", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startDatabaseReplay$int$java_util_Date$java_util_Date", throwable);
            throw throwable;
        }
    }

    private void __startDatabaseReplay(int dashboard, Date from, Date to) throws Exception {
        this.__getlogger().debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = (DashboardDataCollector)this.__getdashboardList().get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        dbc.startDatabaseReplay(from, to);
    }

    public long getDatabaseLimits(int n) throws Exception {
        long l;
        if (!this.__MgetDatabaseLimits$int) {
            return this.__getDatabaseLimits(n);
        }
        try {
            this.__IM.onEntry((Object)this, "getDatabaseLimits$int", new Object[]{new Integer(n)});
            l = this.__getDatabaseLimits(n);
            this.__IM.onExit((Object)this, "getDatabaseLimits$int", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDatabaseLimits$int", throwable);
            throw throwable;
        }
        return l;
    }

    private long __getDatabaseLimits(int dashboard) throws Exception {
        this.__getlogger().debug((Object)("dbid=" + dashboard), new Object[0]);
        DashboardDataCollector dbc = (DashboardDataCollector)this.__getdashboardList().get(dashboard);
        if (dbc == null) {
            throw new Exception("Bad dashboard id: " + dashboard);
        }
        return dbc.getDatabaseLimits();
    }

    public ArrayList<ReplayFileName> getReplayFilenames(String string, String string2) throws Exception {
        ArrayList<ReplayFileName> arrayList;
        if (!this.__MgetReplayFilenames$java_lang_String$java_lang_String) {
            return this.__getReplayFilenames(string, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "getReplayFilenames$java_lang_String$java_lang_String", new Object[]{string, string2});
            arrayList = this.__getReplayFilenames(string, string2);
            this.__IM.onExit((Object)this, "getReplayFilenames$java_lang_String$java_lang_String", arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getReplayFilenames$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList<ReplayFileName> __getReplayFilenames(String filter, String filename) throws Exception {
        this.__getlogger().debug((Object)filename, new Object[0]);
        ArrayList<ReplayFileName> result = new ArrayList<ReplayFileName>();
        String base = null;
        if (filename.length() > 0) {
            File file = new File(filename);
            base = file.getName();
        }
        if (base != null) {
            result.addAll(this.getReplayFiles(this.__geteostemp(), base));
        } else {
            for (String dir : this.__getreplaydirlist()) {
                result.addAll(this.getReplayFiles(dir, filter));
            }
        }
        return result;
    }

    private ArrayList<ReplayFileName> getReplayFiles(String string, String string2) {
        ArrayList<ReplayFileName> arrayList;
        if (!this.__MgetReplayFiles$java_lang_String$java_lang_String) {
            return this.__getReplayFiles(string, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "getReplayFiles$java_lang_String$java_lang_String", new Object[]{string, string2});
            arrayList = this.__getReplayFiles(string, string2);
            this.__IM.onExit((Object)this, "getReplayFiles$java_lang_String$java_lang_String", arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getReplayFiles$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList<ReplayFileName> __getReplayFiles(String directory, String filter) {
        this.__getlogger().debug((Object)directory, new Object[0]);
        ArrayList<ReplayFileName> result = new ArrayList<ReplayFileName>();
        File dir = new File(directory);
        if (!dir.exists()) {
            dir = new File(JProp.getJonasBase() + File.separator + directory);
        }
        if (!dir.exists()) {
            this.__getlogger().debug((Object)("cannot find directory " + directory), new Object[0]);
            this.__getlogger().debug((Object)("Nor in absolute, neither in " + JProp.getJonasBase()), new Object[0]);
            return result;
        }
        File[] files = dir.listFiles(new NameFilter(filter));
        if (files == null) {
            this.__getlogger().debug((Object)("no files found in " + directory), new Object[0]);
            return result;
        }
        for (int i = 0; i < files.length; ++i) {
            ReplayFileName rfn = new ReplayFileName();
            rfn.setDirectory(dir.getPath());
            rfn.setName(files[i].getName());
            rfn.setSize(files[i].length());
            rfn.setDate(new Date(files[i].lastModified()));
            rfn.setSeparator(File.separator);
            if (!rfn.validate()) continue;
            result.add(rfn);
            this.__getlogger().debug((Object)("found " + files[i].getName()), new Object[0]);
        }
        return result;
    }

    private boolean isConfigFile(File file) {
        boolean bl;
        if (!this.__MisConfigFile$java_io_File) {
            return this.__isConfigFile(file);
        }
        try {
            this.__IM.onEntry((Object)this, "isConfigFile$java_io_File", new Object[]{file});
            bl = this.__isConfigFile(file);
            this.__IM.onExit((Object)this, "isConfigFile$java_io_File", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isConfigFile$java_io_File", throwable);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean __isConfigFile(File file) {
        BufferedReader buffer;
        FileReader fileReader;
        block26: {
            boolean bl;
            block24: {
                block25: {
                    fileReader = null;
                    buffer = null;
                    try {
                        fileReader = new FileReader(file);
                        buffer = new BufferedReader(fileReader);
                        String line = "";
                        while ((line = buffer.readLine()) != null) {
                            if (!line.contains("<monitor")) continue;
                            bl = true;
                            if (buffer == null) break block24;
                            break block25;
                        }
                        break block26;
                    }
                    catch (Exception e) {
                        if (buffer != null) {
                            try {
                                buffer.close();
                            }
                            catch (Exception e2) {
                                this.__getlogger().error((Object)"Failed closing buffer", new Object[]{e2});
                            }
                        }
                        if (fileReader == null) return false;
                        try {
                            fileReader.close();
                            return false;
                        }
                        catch (Exception e3) {
                            this.__getlogger().error((Object)"Failed closing fileReader", new Object[]{e3});
                            return false;
                        }
                        catch (Throwable throwable) {
                            if (buffer != null) {
                                try {
                                    buffer.close();
                                }
                                catch (Exception e4) {
                                    this.__getlogger().error((Object)"Failed closing buffer", new Object[]{e4});
                                }
                            }
                            if (fileReader == null) throw throwable;
                            try {
                                fileReader.close();
                                throw throwable;
                            }
                            catch (Exception e5) {
                                this.__getlogger().error((Object)"Failed closing fileReader", new Object[]{e5});
                            }
                            throw throwable;
                        }
                    }
                }
                try {
                    buffer.close();
                }
                catch (Exception e) {
                    this.__getlogger().error((Object)"Failed closing buffer", new Object[]{e});
                }
            }
            if (fileReader == null) return bl;
            try {
                fileReader.close();
                return bl;
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Failed closing fileReader", new Object[]{e});
            }
            return bl;
        }
        if (buffer != null) {
            try {
                buffer.close();
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Failed closing buffer", new Object[]{e});
            }
        }
        if (fileReader == null) return false;
        try {
            fileReader.close();
            return false;
        }
        catch (Exception e) {
            this.__getlogger().error((Object)"Failed closing fileReader", new Object[]{e});
            return false;
        }
    }

    private ArrayList<ConfigFile> getXmlFiles(String string) {
        ArrayList<ConfigFile> arrayList;
        if (!this.__MgetXmlFiles$java_lang_String) {
            return this.__getXmlFiles(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getXmlFiles$java_lang_String", new Object[]{string});
            arrayList = this.__getXmlFiles(string);
            this.__IM.onExit((Object)this, "getXmlFiles$java_lang_String", arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getXmlFiles$java_lang_String", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList<ConfigFile> __getXmlFiles(String directory) {
        ArrayList<ConfigFile> result = new ArrayList<ConfigFile>();
        File dir = new File(directory);
        if (!dir.exists()) {
            dir = new File(JProp.getJonasBase() + File.separator + directory);
        }
        if (!dir.exists()) {
            this.__getlogger().error((Object)("cannot find " + directory), new Object[0]);
            return result;
        }
        this.__getlogger().debug((Object)dir.getPath(), new Object[0]);
        File[] files = dir.listFiles(new NameFilter("*.xml"));
        if (files == null) {
            this.__getlogger().warn((Object)("no files found in " + directory), new Object[0]);
            return result;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!this.isConfigFile(files[i])) continue;
            ConfigFile rfn = new ConfigFile();
            rfn.setDirectory(dir.getPath());
            rfn.setName(files[i].getName());
            rfn.setSize(files[i].length());
            rfn.setDate(new Date(files[i].lastModified()));
            rfn.setSeparator(File.separator);
            result.add(rfn);
            this.__getlogger().debug((Object)("found " + files[i].getName()), new Object[0]);
        }
        return result;
    }

    private void readConfig() {
        if (!this.__MreadConfig) {
            this.__readConfig();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "readConfig", new Object[0]);
            this.__readConfig();
            this.__IM.onExit((Object)this, "readConfig", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "readConfig", throwable);
            throw throwable;
        }
    }

    private void __readConfig() {
        int i;
        JProp config = JProp.getInstance((String)"jasmine-monitoring.properties");
        this.__setreplaydirlist(new HashSet());
        String[] list = config.getValueAsArray("jasmine.monitoring.replaydir");
        if (list == null) {
            this.__getlogger().debug((Object)"Missing jasmine-monitoring.properties: take default values", new Object[0]);
            this.__getreplaydirlist().add("monitoring");
        } else {
            for (i = 0; i < list.length; ++i) {
                this.__getreplaydirlist().add(list[i]);
            }
        }
        this.__seteostemp(System.getProperty("java.io.tmpdir") + File.separatorChar + "EoS.temp");
        this.__getreplaydirlist().add(this.__geteostemp());
        this.__setconfigdirlist(new HashSet());
        list = config.getValueAsArray("jasmine.monitoring.configdir");
        if (list == null) {
            this.__getlogger().debug((Object)"No jasmine-monitoring.properties: take default values", new Object[0]);
            this.__getconfigdirlist().add(JProp.getJonasBase() + File.separator + "monitoring");
        } else {
            for (i = 0; i < list.length; ++i) {
                String directory = list[i];
                File dir = new File(directory);
                if (!dir.exists()) {
                    directory = JProp.getJonasBase() + File.separator + directory;
                    dir = new File(directory);
                }
                if (dir.exists()) {
                    this.__getconfigdirlist().add(directory);
                    continue;
                }
                this.__getlogger().error((Object)("cannot find " + list[i]), new Object[0]);
            }
        }
        this.__getconfigdirlist().add(this.__geteostemp());
        this.__getlogger().debug((Object)"jasmine-monitoring.properties read", new Object[0]);
    }

    private boolean match(String string, String string2) {
        boolean bl;
        if (!this.__Mmatch$java_lang_String$java_lang_String) {
            return this.__match(string, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "match$java_lang_String$java_lang_String", new Object[]{string, string2});
            bl = this.__match(string, string2);
            this.__IM.onExit((Object)this, "match$java_lang_String$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "match$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __match(String strmbean, String strpattern) {
        if (strpattern == null || strpattern.length() == 0 || strpattern.equals("*:*")) {
            return true;
        }
        ObjectName mbean = null;
        ObjectName pattern = null;
        try {
            mbean = new ObjectName(strmbean);
        }
        catch (MalformedObjectNameException e) {
            this.__getlogger().error((Object)("Bad MBean ObjectName (MalformedObjectNameException) " + strmbean), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            this.__getlogger().error((Object)("Bad MBean ObjectName (NPE) " + strmbean), new Object[0]);
            return false;
        }
        try {
            pattern = new ObjectName(strpattern);
        }
        catch (MalformedObjectNameException e) {
            this.__getlogger().error((Object)("Bad Pattern ObjectName (MalformedObjectNameException) " + strpattern), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            this.__getlogger().error((Object)("Bad Pattern ObjectName (NPE) " + strpattern), new Object[0]);
            return false;
        }
        if (pattern == null) {
            this.__getlogger().error((Object)("Cannot get ObjectName on " + strpattern), new Object[0]);
            return false;
        }
        return pattern.apply(mbean);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configdirlist")) {
                this.__Fconfigdirlist = true;
            }
            if (set.contains("id")) {
                this.__Fid = true;
            }
            if (set.contains("eostemp")) {
                this.__Feostemp = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("dashboardIdent")) {
                this.__FdashboardIdent = true;
            }
            if (set.contains("dashboardList")) {
                this.__FdashboardList = true;
            }
            if (set.contains("replaydirlist")) {
                this.__Freplaydirlist = true;
            }
            if (set.contains("kerneosHttpContext")) {
                this.__FkerneosHttpContext = true;
            }
            if (set.contains("httpService")) {
                this.__FhttpService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("registerServlets")) {
                this.__MregisterServlets = true;
            }
            if (set.contains("getConfigFiles")) {
                this.__MgetConfigFiles = true;
            }
            if (set.contains("loadConfigFile$java_lang_String")) {
                this.__MloadConfigFile$java_lang_String = true;
            }
            if (set.contains("saveConfigFile$java_lang_String$java_lang_String")) {
                this.__MsaveConfigFile$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile")) {
                this.__MremoveConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile = true;
            }
            if (set.contains("renameConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile$java_lang_String")) {
                this.__MrenameConfigFile$org_ow2_jasmine_monitoring_eos_monitoring_ConfigFile$java_lang_String = true;
            }
            if (set.contains("createDashboard$java_util_List$boolean")) {
                this.__McreateDashboard$java_util_List$boolean = true;
            }
            if (set.contains("removeDashboard$int")) {
                this.__MremoveDashboard$int = true;
            }
            if (set.contains("startMonitoring$int")) {
                this.__MstartMonitoring$int = true;
            }
            if (set.contains("stopMonitoring$int")) {
                this.__MstopMonitoring$int = true;
            }
            if (set.contains("getAllResults$int")) {
                this.__MgetAllResults$int = true;
            }
            if (set.contains("getAllNotifs$int")) {
                this.__MgetAllNotifs$int = true;
            }
            if (set.contains("startFileReplay$int$java_lang_String$java_util_Date$java_util_Date")) {
                this.__MstartFileReplay$int$java_lang_String$java_util_Date$java_util_Date = true;
            }
            if (set.contains("startDatabaseReplay$int$java_util_Date$java_util_Date")) {
                this.__MstartDatabaseReplay$int$java_util_Date$java_util_Date = true;
            }
            if (set.contains("getDatabaseLimits$int")) {
                this.__MgetDatabaseLimits$int = true;
            }
            if (set.contains("getReplayFilenames$java_lang_String$java_lang_String")) {
                this.__MgetReplayFilenames$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getReplayFiles$java_lang_String$java_lang_String")) {
                this.__MgetReplayFiles$java_lang_String$java_lang_String = true;
            }
            if (set.contains("isConfigFile$java_io_File")) {
                this.__MisConfigFile$java_io_File = true;
            }
            if (set.contains("getXmlFiles$java_lang_String")) {
                this.__MgetXmlFiles$java_lang_String = true;
            }
            if (set.contains("readConfig")) {
                this.__MreadConfig = true;
            }
            if (set.contains("match$java_lang_String$java_lang_String")) {
                this.__Mmatch$java_lang_String$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

