/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.messages.JasmineEvent;
import org.ow2.jasmine.event.messages.JasmineEventDetails;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DatabaseExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.service.Extractor;
import org.ow2.jasmine.monitoring.eos.monitoring.service.FileExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.service.HeaderFileExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.service.MonitoringService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DashboardDataCollector
implements MessageListener {
    private static final Log logger = LogFactory.getLog(MonitoringService.class);
    private int ident;
    private List<Serie> series;
    public static final String CONNECTION_FACTORY = "JCF";
    LinkedList<EventData> resultList = null;
    private static final int MAX_RESULT_READ = 5000;
    public static final String RESULT_TOPIC = "jasmine";
    private Topic resultTopic = null;
    private Connection resultConnection = null;
    private Session resultSession = null;
    private MessageConsumer resultSubscriber = null;
    LinkedList<JasmineEventNotification> notifList = null;
    public static final String NOTIF_TOPIC = "jasmineNotification";
    private Topic notifTopic = null;
    private Connection notifConnection = null;
    private Session notifSession = null;
    private MessageConsumer notifSubscriber = null;
    private Extractor extractor = null;
    private boolean replay;

    public DashboardDataCollector(int ident, List<Serie> series, boolean notifications) {
        this.ident = ident;
        this.series = series;
        this.cleanResults();
    }

    public List<Serie> getSeries() {
        return this.series;
    }

    public synchronized void addResult(EventData evd) {
        this.resultList.addLast(evd);
    }

    public void setReplayCompleted() {
        logger.debug((Object)"", new Object[0]);
        this.extractor = null;
    }

    public boolean match(String strmbean, String strpattern) {
        if (strpattern == null || strpattern.length() == 0 || strpattern.equals("*:*")) {
            return true;
        }
        ObjectName mbean = null;
        ObjectName pattern = null;
        try {
            mbean = new ObjectName(strmbean);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)("Bad MBean ObjectName (MalformedObjectNameException) " + strmbean), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            logger.error((Object)("Bad MBean ObjectName (NPE) " + strmbean), new Object[0]);
            return false;
        }
        try {
            pattern = new ObjectName(strpattern);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)("Bad Pattern ObjectName (MalformedObjectNameException) " + strpattern), new Object[0]);
            return false;
        }
        catch (NullPointerException e) {
            logger.error((Object)("Bad Pattern ObjectName (NPE) " + strpattern), new Object[0]);
            return false;
        }
        if (pattern == null) {
            logger.error((Object)("Cannot get ObjectName on " + strpattern), new Object[0]);
            return false;
        }
        return pattern.apply(mbean);
    }

    public void onMessage(Message message) {
        if (!(message instanceof ObjectMessage)) {
            return;
        }
        ObjectMessage om = (ObjectMessage)message;
        Serializable obj = null;
        try {
            message.acknowledge();
            obj = om.getObject();
        }
        catch (JMSException e) {
            logger.error((Object)"Bad message got on Jms Topic", new Object[0]);
            return;
        }
        if (obj instanceof JasmineEvent) {
            this.resultReceived((JasmineEvent)obj);
        } else if (obj instanceof JasmineEventNotification) {
            this.notifReceived((JasmineEventNotification)obj);
        }
    }

    private void resultReceived(JasmineEvent event) {
        logger.debug((Object)"", new Object[0]);
        String server = event.getServer();
        for (JasmineEventDetails ed : event.getEvents()) {
            String probe = ed.getProbe();
            int index = probe.lastIndexOf(":");
            String mbean = probe.substring(0, index);
            String attr = probe.substring(index + 1);
            for (Serie curser : this.series) {
                String svr;
                if (!this.attrmatch(attr, curser.getYcol()) || !this.match(mbean, curser.getPattern()) || (svr = curser.getServer()) != null && svr.length() > 0 && !svr.equals(server)) continue;
                EventData evd = new EventData(curser.getId(), ed.getTimestamp().getTime(), ed.getValue());
                this.addResult(evd);
            }
        }
    }

    private void notifReceived(JasmineEventNotification notif) {
        logger.debug((Object)"", new Object[0]);
        this.notifList.add(notif);
    }

    public synchronized List<JasmineEventNotification> getAllNotifs() {
        LinkedList<JasmineEventNotification> res = new LinkedList<JasmineEventNotification>();
        res.addAll(this.notifList);
        this.notifList = new LinkedList();
        logger.debug((Object)("returning " + res.size() + " notifs"), new Object[0]);
        return res;
    }

    public synchronized List<EventData> getAllResults() {
        int count;
        ArrayList<EventData> res = new ArrayList<EventData>();
        for (count = 0; count < 5000; ++count) {
            try {
                EventData ed = this.resultList.removeFirst();
                res.add(ed);
                continue;
            }
            catch (NoSuchElementException e) {
                // empty catch block
                break;
            }
        }
        if (count == 0 && this.isReplayCompleted()) {
            logger.debug((Object)"ReplayCompleted", new Object[0]);
            return null;
        }
        logger.debug((Object)("Found " + count + " events"), new Object[0]);
        return res;
    }

    public void startLiveMonitoring() throws NamingException, JMSException {
        logger.debug((Object)"", new Object[0]);
        this.cleanResults();
        this.replay = false;
        InitialContext context = new InitialContext();
        ConnectionFactory tcf = (ConnectionFactory)context.lookup(CONNECTION_FACTORY);
        if (this.resultTopic == null) {
            this.resultTopic = (Topic)context.lookup(RESULT_TOPIC);
        }
        this.resultConnection = tcf.createConnection();
        this.resultSession = this.resultConnection.createSession(false, 2);
        this.resultSubscriber = this.resultSession.createConsumer((Destination)this.resultTopic);
        this.resultSubscriber.setMessageListener((MessageListener)this);
        this.resultConnection.start();
        if (this.notifTopic == null) {
            this.notifTopic = (Topic)context.lookup(NOTIF_TOPIC);
        }
        this.notifConnection = tcf.createConnection();
        this.notifSession = this.notifConnection.createSession(false, 2);
        this.notifSubscriber = this.notifSession.createConsumer((Destination)this.notifTopic);
        this.notifSubscriber.setMessageListener((MessageListener)this);
        this.notifConnection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLiveMonitoring() {
        logger.debug((Object)"", new Object[0]);
        if (this.resultConnection != null) {
            try {
                if (this.resultSubscriber != null) {
                    this.resultSubscriber.close();
                }
                if (this.resultSession != null) {
                    this.resultSession.close();
                }
                this.resultConnection.close();
            }
            catch (JMSException e) {
                logger.error((Object)"cannot disconnect from jasmine topic", new Object[0]);
            }
            finally {
                this.resultConnection = null;
                this.resultSession = null;
                this.resultSubscriber = null;
            }
        }
        if (this.notifConnection != null) {
            try {
                if (this.notifSubscriber != null) {
                    this.notifSubscriber.close();
                }
                if (this.notifSession != null) {
                    this.notifSession.close();
                }
                this.notifConnection.close();
            }
            catch (JMSException e) {
                logger.error((Object)"cannot disconnect from jasmineNotification topic", new Object[0]);
            }
            finally {
                this.notifConnection = null;
                this.notifSession = null;
                this.notifSubscriber = null;
            }
        }
        if (this.extractor != null) {
            this.extractor.stopMonitoring();
        }
    }

    public void startFileReplay(String fileName, Date from, Date to) throws Exception {
        logger.debug((Object)("from=" + from), new Object[0]);
        this.cleanResults();
        FileReader f = new FileReader(fileName);
        BufferedReader buffer = new BufferedReader(f);
        buffer.mark(500);
        String header = buffer.readLine();
        if (header == null) {
            logger.warn((Object)("Empty file: " + fileName), new Object[0]);
            throw new Exception("Empty file: " + fileName);
        }
        this.replay = true;
        if (header.startsWith("date")) {
            this.extractor = new HeaderFileExtractor(this, header, 0, buffer, from, to);
        } else if (header.startsWith("time")) {
            this.extractor = new HeaderFileExtractor(this, header, 1, buffer, from, to);
        } else {
            buffer.reset();
            this.extractor = new FileExtractor(this, buffer, from, to);
        }
        this.extractor.start();
    }

    public void startDatabaseReplay(Date from, Date to) throws Exception {
        logger.debug((Object)"", new Object[0]);
        this.cleanResults();
        this.replay = true;
        if (this.extractor == null) {
            this.extractor = new DatabaseExtractor(this);
        }
        this.extractor.setDateLimits(from, to);
        this.extractor.start();
    }

    public long getDatabaseLimits() throws Exception {
        logger.debug((Object)"", new Object[0]);
        this.extractor = new DatabaseExtractor(this);
        return ((DatabaseExtractor)this.extractor).getStartTime();
    }

    private boolean isReplayCompleted() {
        return this.replay && this.extractor == null;
    }

    private synchronized void cleanResults() {
        this.resultList = new LinkedList();
        this.notifList = new LinkedList();
    }

    protected boolean attrmatch(String attr, String ycol) {
        if (attr.equals(ycol)) {
            return true;
        }
        int index = attr.indexOf(".");
        return index > 0 && attr.substring(index + 1).equals(ycol);
    }
}

