/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.monitoring.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eos.monitoring.DataBaseEventExtractor;
import org.ow2.jasmine.monitoring.eos.monitoring.EventData;
import org.ow2.jasmine.monitoring.eos.monitoring.Serie;
import org.ow2.jasmine.monitoring.eos.monitoring.service.DashboardDataCollector;
import org.ow2.jasmine.monitoring.eos.monitoring.service.Extractor;

public class DatabaseExtractor
extends Extractor {
    private static SimpleDateFormat format;
    private int nbrecordread = 12000;
    private int nbmillisecwait = 10000;

    public DatabaseExtractor(DashboardDataCollector dbc) {
        super(dbc);
        format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public long getStartTime() throws Exception {
        DataBaseEventExtractor dataBaseEventExtractor = new DataBaseEventExtractor();
        JasmineEventEB elem = null;
        try {
            elem = dataBaseEventExtractor.getFirstEvent();
            if (elem == null) {
                logger.warn((Object)"Nothing in database yet", new Object[0]);
                return new Date().getTime();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Cannot read database: " + e), new Object[0]);
            throw e;
        }
        return elem.getTimestamp().getTime();
    }

    @Override
    public void run() {
        HashSet<String> servers = new HashSet<String>();
        HashSet<String> probes = new HashSet<String>();
        for (Serie element : this.dbc.getSeries()) {
            probes.add(element.getYcol());
            if (element.getServer() == null) continue;
            servers.add(element.getServer());
        }
        DataBaseEventExtractor dataBaseEventExtractor = new DataBaseEventExtractor();
        Date fromDate = this.from;
        while (!this.stopWanted) {
            JasmineEventEB[] events = null;
            logger.debug((Object)("replay from database from " + fromDate + " to " + this.to), new Object[0]);
            try {
                events = dataBaseEventExtractor.getEvents(servers, probes, fromDate, this.to, this.nbrecordread);
                if (events == null) {
                    if (this.to.getTime() < System.currentTimeMillis()) break;
                    logger.debug((Object)"Waiting for new events from database", new Object[0]);
                    Thread.sleep(this.nbmillisecwait);
                    continue;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Cannot read database: " + e), new Object[0]);
                break;
            }
            long timeLimit = this.to.getTime() - 120000L;
            long lasttimestamp = 0L;
            for (JasmineEventEB elem : events) {
                lasttimestamp = elem.getTimestamp().getTime();
                String sValue = "";
                if (elem.getValue() != null) {
                    sValue = elem.getValue().toString();
                }
                int index = elem.getProbe().lastIndexOf(":");
                String mbean = elem.getProbe().substring(0, index);
                String attr = elem.getProbe().substring(index + 1);
                for (Serie curser : this.dbc.getSeries()) {
                    if (!this.attrmatch(attr, curser.getYcol()) || !this.dbc.match(mbean, curser.getPattern()) || curser.getServer() != null && curser.getServer().length() > 0 && !curser.getServer().equals(elem.getServer())) continue;
                    EventData ed = new EventData(curser.getId(), elem.getTimestamp().getTime(), sValue);
                    this.dbc.addResult(ed);
                }
            }
            fromDate = new Date(lasttimestamp + 1000L);
            if (lasttimestamp < timeLimit) continue;
            break;
        }
        dataBaseEventExtractor.finished();
        this.dbc.setReplayCompleted();
    }
}

