/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.notification.service.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.monitoring.eos.common.EventManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSMessageListener
implements MessageListener {
    private EventManager<JasmineEventNotification> manager = null;

    public JMSMessageListener(EventManager<JasmineEventNotification> evManager) {
        this.manager = evManager;
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                message.acknowledge();
                ObjectMessage om = (ObjectMessage)message;
                Serializable jasmineEventNotificationObject = om.getObject();
                if (jasmineEventNotificationObject instanceof JasmineEventNotification) {
                    JasmineEventNotification notification = (JasmineEventNotification)jasmineEventNotificationObject;
                    JasmineEventNotification ev = new JasmineEventNotification();
                    ev.setId(notification.getId());
                    ev.setDate(notification.getDate());
                    ev.setLevel(notification.getLevel());
                    ev.setMessage(notification.getMessage());
                    ev.setRule(notification.getRule());
                    ev.setStatus(notification.getStatus());
                    this.manager.add((Object)ev);
                }
            }
        }
        catch (Throwable t) {
            System.err.println(t instanceof JMSException ? "JMSException" : "Throwable Caught in onMessage(): " + t.getMessage());
            t.printStackTrace();
        }
    }
}

