/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.notification.service;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.MessageListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotificationExecutedAction;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.JMSConnection;
import org.ow2.jasmine.monitoring.eos.common.jndilocator.ServiceLocator;
import org.ow2.jasmine.monitoring.eos.notification.actions.api.IAction;
import org.ow2.jasmine.monitoring.eos.notification.actions.exchange.ActionResult;
import org.ow2.jasmine.monitoring.eos.notification.filters.api.IFilter;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.AcknowledgeState;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.ActionCall;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.ColumnSetting;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.ExecutedAction;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.LevelSetting;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.NotificationBoardSettings;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.NotificationSetting;
import org.ow2.jasmine.monitoring.eos.notification.service.jms.JMSMessageListener;
import org.ow2.jasmine.monitoring.eos.notification.service.jms.NotificationEventManager;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventNotificationSLBRemote;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Log logger = LogFactory.getLog(NotificationService.class);
    private static final String NOTIFICATION_CONFIG = "META-INF/notification-config.xml";
    private static final String NOTIFICATION_CONFIG_XSD = "resources/notification-config.xsd";
    private static final String DEFAULT_ACKNOWLEDGE_ACTION_CLASS = "org.ow2.jasmine.monitoring.eos.notification.actions.impl.AcknowledgeAction";
    private String currentAcknowledgeActionName;
    private Map<String, String> availableActions = new HashMap<String, String>();
    private Map<String, LevelSetting> availableLevels = new HashMap<String, LevelSetting>();
    private Map<String, Boolean> filters = new HashMap<String, Boolean>();
    private List<IFilter> alwaysProcessedFilters = new ArrayList<IFilter>();
    private List<IFilter> onlyWhenLiveProcessedFilters = new ArrayList<IFilter>();
    private static JasmineEventNotificationSLBRemote notifFacade = (JasmineEventNotificationSLBRemote)ServiceLocator.getInstance().getRemoteObject("db-ejb/notification");
    private JMSConnection connection = null;
    private NotificationEventManager manager = null;
    private Timer timer = null;
    private static long TIMER = 300000L;

    public List<JasmineEventNotification> getNotifsFromDB() {
        this.disconnectTopic();
        this.logger.debug((Object)"Getting notification from Data Base", new Object[0]);
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        List notifList = notifFacade.getAllNotifications();
        if (notifList != null) {
            for (JasmineEventNotification j : notifList) {
                if (!this.filter(j, false)) continue;
                result.add(j);
            }
        }
        this.logger.debug((Object)"Return the notifications from Data Base", new Object[0]);
        return result;
    }

    public List<JasmineEventNotification> getNotifsFromDBFromTo(Date dateFrom, Date dateTo) {
        this.disconnectTopic();
        this.logger.debug((Object)"Getting notification from Data Base from date {0} to date {1}.", new Object[]{dateFrom, dateTo});
        List notifList = null;
        notifList = notifFacade.getEventNotifications(dateFrom, dateTo);
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        if (notifList != null) {
            for (JasmineEventNotification j : notifList) {
                if (!this.filter(j, true)) continue;
                result.add(j);
            }
        }
        notifList = null;
        return result;
    }

    public List<JasmineEventNotification> getNotifsFromTopic() {
        this.logger.debug((Object)"Getting notification from JMS Topic", new Object[0]);
        if (this.connection == null) {
            this.connectTopic();
        }
        this.resetTimer();
        ArrayList<JasmineEventNotification> list = new ArrayList<JasmineEventNotification>();
        list.addAll(this.manager.getAll());
        this.logger.debug((Object)"Received {0} notifications.", new Object[]{list.size()});
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        for (JasmineEventNotification j : list) {
            if (!this.filter(j, false)) continue;
            result.add(j);
        }
        list = null;
        return result;
    }

    public int connectTopic() {
        this.manager = new NotificationEventManager();
        if (this.connection == null) {
            this.connection = new JMSConnection((EventManager)this.manager);
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DisconnectTask(), TIMER);
        this.logger.debug((Object)"Connected to the topic ...", new Object[0]);
        return this.connection.connect("jasmineNotification", (MessageListener)new JMSMessageListener(this.manager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int disconnectTopic() {
        this.logger.debug((Object)"Disconnecting from the JMS topic...", new Object[0]);
        try {
            int result;
            if (this.connection == null) {
                int n = -1;
                return n;
            }
            int n = result = this.connection.disconnect();
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            this.connection = null;
            this.manager = null;
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
    }

    private void resetTimer() {
        this.timer.cancel();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DisconnectTask(), TIMER);
    }

    private boolean filter(JasmineEventNotification notification, boolean reviewing) {
        boolean result = true;
        for (IFilter filter : this.alwaysProcessedFilters) {
            result &= filter.filter(notification);
        }
        if (!reviewing) {
            for (IFilter filter : this.onlyWhenLiveProcessedFilters) {
                result &= filter.filter(notification);
            }
        }
        return result;
    }

    private void initializeFilters() throws Exception {
        this.logger.info((Object)"Initialize filters", new Object[0]);
        Set<String> filtersSet = this.filters.keySet();
        for (String className : filtersSet) {
            Class<?> filterClass = Class.forName(className);
            Constructor<?> filterConstructor = filterClass.getConstructor(new Class[0]);
            IFilter filter = (IFilter)filterConstructor.newInstance(new Object[0]);
            if (this.filters.get(className).booleanValue()) {
                this.logger.info((Object)"Add {0} to the alwaysExecutedFilter list", new Object[]{className});
                this.alwaysProcessedFilters.add(filter);
                continue;
            }
            this.logger.info((Object)"Add {0} to the onlyWhenLiveProcessedFilters list", new Object[]{className});
            this.onlyWhenLiveProcessedFilters.add(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationBoardSettings getActions() {
        ArrayList<NotificationSetting> actionsList = new ArrayList<NotificationSetting>();
        ArrayList<ColumnSetting> columnsList = new ArrayList<ColumnSetting>();
        NotificationBoardSettings settings = new NotificationBoardSettings();
        try {
            URL notification = this.getClass().getClassLoader().getResource(NOTIFICATION_CONFIG);
            this.logger.debug((Object)"loading file : {0}", new Object[]{notification});
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = null;
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource schemaFile = new StreamSource(new File(this.getClass().getClassLoader().getResource(NOTIFICATION_CONFIG_XSD).toURI()));
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            try {
                validator.validate(new DOMSource(doc));
            }
            catch (SAXException e) {
                throw new Exception("The configuration file META-INF/notification-config.xml is not well formed. Please refer to the XML Schema.", e);
            }
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl.getResource(NOTIFICATION_CONFIG) != null) {
                this.logger.info((Object)"loading file : {0}", new Object[]{NOTIFICATION_CONFIG});
                this.logger.debug((Object)"Loading the notification XML file from classpath", new Object[0]);
                InputStream resource = cl.getResourceAsStream(NOTIFICATION_CONFIG);
                try {
                    doc = documentBuilder.parse(resource);
                }
                finally {
                    resource.close();
                    resource = null;
                }
            } else {
                this.logger.error((Object)"No configuration file available : {0}", new Object[]{NOTIFICATION_CONFIG});
            }
            if (doc != null) {
                doc.getDocumentElement().normalize();
                NodeList listOfFiltersEntries = doc.getElementsByTagName("filters");
                Node filtersNode = listOfFiltersEntries.item(0);
                NodeList filterList = filtersNode.getChildNodes();
                for (int filterListLength = 0; filterListLength < filterList.getLength(); ++filterListLength) {
                    Node filter = filterList.item(filterListLength);
                    if (!"filter".equals(filter.getNodeName())) continue;
                    String className = filter.getAttributes().getNamedItem("class").getTextContent();
                    Boolean reviewProcessed = Boolean.valueOf(filter.getAttributes().getNamedItem("reviewProcess").getTextContent());
                    this.logger.debug((Object)"reviewProcess {0}", new Object[]{reviewProcessed});
                    this.filters.put(className, reviewProcessed);
                }
                NodeList listOfAckClasseEntries = doc.getElementsByTagName("acknowledgeClass");
                Node ackClasses = listOfAckClasseEntries.item(0);
                String ackClassSet = ackClasses.getAttributes().getNamedItem("class").getTextContent();
                this.currentAcknowledgeActionName = ackClasses.getAttributes().getNamedItem("name").getTextContent();
                if ("default".equals(ackClassSet)) {
                    this.availableActions.put(this.currentAcknowledgeActionName, DEFAULT_ACKNOWLEDGE_ACTION_CLASS);
                } else {
                    this.availableActions.put(this.currentAcknowledgeActionName, ackClassSet);
                }
                NodeList listOfkeepDisplayedEntries = doc.getElementsByTagName("keepDisplayed");
                Node keepDisplayed = listOfkeepDisplayedEntries.item(0);
                String numberOfHours = keepDisplayed.getAttributes().getNamedItem("hours").getTextContent();
                NodeList listOfLevelsEntries = doc.getElementsByTagName("levels");
                Node levels = listOfLevelsEntries.item(0);
                NodeList levelList = levels.getChildNodes();
                for (int levelListLength = 0; levelListLength < levelList.getLength(); ++levelListLength) {
                    LevelSetting levelSetting = new LevelSetting();
                    Node level = levelList.item(levelListLength);
                    if ("level".equals(level.getNodeName())) {
                        String name = level.getAttributes().getNamedItem("name").getTextContent();
                        String color = level.getAttributes().getNamedItem("color").getTextContent();
                        levelSetting.setLevel(name);
                        if (!"".equals(color)) {
                            levelSetting.setColor(color);
                        }
                        this.logger.debug((Object)"name : {0}", new Object[]{level.getAttributes().getNamedItem("name").getTextContent()});
                        this.logger.debug((Object)"color : {0}", new Object[]{level.getAttributes().getNamedItem("color").getTextContent()});
                    }
                    this.availableLevels.put(levelSetting.getLevel(), levelSetting);
                }
                NodeList listOfEntries = doc.getElementsByTagName("notifs");
                for (int j = 0; j < listOfEntries.getLength(); ++j) {
                    Node notifs = listOfEntries.item(j);
                    this.logger.debug((Object)"<notifs> node name : {0}", new Object[]{notifs.getNodeName()});
                    NodeList allNotifs = notifs.getChildNodes();
                    for (int k = 0; k < allNotifs.getLength(); ++k) {
                        Node notif = allNotifs.item(k);
                        this.logger.debug((Object)"<notif> node name : {0}", new Object[]{notif.getNodeName()});
                        if ("All".equals(notif.getNodeName())) {
                            this.logger.info((Object)"Getting all the notifications ... No levels will be associated then.", new Object[0]);
                            settings.setActionsList(actionsList);
                            settings.setColumnsList(columnsList);
                            return settings;
                        }
                        if (!"notif".equals(notif.getNodeName())) continue;
                        NotificationSetting actionBinding = new NotificationSetting();
                        actionBinding.setRule(notif.getAttributes().getNamedItem("rule").getTextContent());
                        actionBinding.setKeepDisplayed(Integer.valueOf(numberOfHours));
                        if (this.availableLevels.get(notif.getAttributes().getNamedItem("level").getTextContent()) == null) {
                            throw new Exception("Level " + notif.getAttributes().getNamedItem("level").getTextContent() + " not defined in the <levels> tag");
                        }
                        actionBinding.setLevel(this.availableLevels.get(notif.getAttributes().getNamedItem("level").getTextContent()));
                        boolean synch = Boolean.valueOf(notif.getAttributes().getNamedItem("synchronized").getTextContent());
                        actionBinding.setSynchronize(synch);
                        actionBinding.setAcknowledgeActionName(this.currentAcknowledgeActionName);
                        NodeList allActions = notif.getChildNodes();
                        for (int m = 0; m < allActions.getLength(); ++m) {
                            Node actions = allActions.item(m);
                            this.logger.debug((Object)"<actions> node name : {0}", new Object[]{actions.getNodeName()});
                            if (!"actions".equals(actions.getNodeName())) continue;
                            NodeList allAction = actions.getChildNodes();
                            for (int l = 0; l < allAction.getLength(); ++l) {
                                Node action = allAction.item(l);
                                this.logger.debug((Object)"<action> node name : {0}", new Object[]{action.getNodeName()});
                                if (!"action".equals(action.getNodeName())) continue;
                                actionBinding.addAction(action.getAttributes().getNamedItem("name").getTextContent());
                                if (this.availableActions.containsKey(action.getAttributes().getNamedItem("name").getTextContent())) continue;
                                this.availableActions.put(action.getAttributes().getNamedItem("name").getTextContent(), action.getAttributes().getNamedItem("className").getTextContent());
                            }
                        }
                        this.logger.debug((Object)"number of actions in the binding object : {0}", new Object[]{actionBinding.getAction().size()});
                        actionsList.add(actionBinding);
                    }
                }
                NodeList listOfColumnEntries = doc.getElementsByTagName("displayedColumns");
                Node displayedColumnsNode = listOfColumnEntries.item(0);
                NodeList columnList = displayedColumnsNode.getChildNodes();
                for (int columnListLength = 0; columnListLength < columnList.getLength(); ++columnListLength) {
                    ColumnSetting columnSetting = new ColumnSetting();
                    Node column = columnList.item(columnListLength);
                    if (!"column".equals(column.getNodeName())) continue;
                    String id = column.getAttributes().getNamedItem("id").getTextContent();
                    String dataField = column.getAttributes().getNamedItem("dataField").getTextContent();
                    String displayed = column.getAttributes().getNamedItem("displayed").getTextContent();
                    if (column.getAttributes().getNamedItem("headerText") != null) {
                        String headerText = column.getAttributes().getNamedItem("headerText").getTextContent();
                        columnSetting.setHeaderText(headerText);
                    } else {
                        columnSetting.setHeaderText(id);
                    }
                    columnSetting.setId(id);
                    columnSetting.setDataField(dataField);
                    columnSetting.setDisplayed(displayed);
                    columnsList.add(columnSetting);
                }
                settings.setActionsList(actionsList);
                settings.setColumnsList(columnsList);
            }
            this.initializeFilters();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return settings;
    }

    public ExecutedAction execute(ActionCall action) throws Exception {
        try {
            if (action.getName().equals(this.currentAcknowledgeActionName)) {
                this.logger.debug((Object)"Update notification {0} to the acknowledged state", new Object[]{action.getNotification().getId()});
                notifFacade.updateNotificationStatus(action.getNotification().getId(), true);
            }
            JasmineEventNotificationExecutedAction actionToSave = new JasmineEventNotificationExecutedAction(action.getComment(), action.getName(), new Date(), action.getUser());
            notifFacade.saveExecutedAction(action.getNotification().getId(), actionToSave);
            this.logger.debug((Object)"Action name : {0} , id : {1} .\n\tThe associated class is : {2}", new Object[]{action.getName(), action.getNotification().getId(), this.availableActions.get(action.getName())});
            Class<?> actionClass = Class.forName(this.availableActions.get(action.getName()));
            Constructor<?> actionConstructor = actionClass.getConstructor(new Class[0]);
            IAction actionInstance = (IAction)actionConstructor.newInstance(new Object[0]);
            this.logger.info((Object)"Executing the following action : {0}", new Object[]{actionInstance.getName()});
            ActionResult actionResult = actionInstance.execute(action.getNotification());
            actionResult.setName(action.getName());
            ExecutedAction executedAction = new ExecutedAction();
            executedAction.setActionResult(actionResult);
            executedAction.setUser(action.getUser());
            executedAction.setNotification(notifFacade.getEventNotification(action.getNotification().getId()));
            return executedAction;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public AcknowledgeState isAcknowledged(JasmineEventNotification notification) {
        SecurityCurrent secutiryCurrent = SecurityCurrent.getCurrent();
        this.logger.debug((Object)"logged user : {0}", new Object[]{secutiryCurrent.getSecurityContext().getPrincipalName()});
        this.logger.debug((Object)"Checking notification {0} from rule {1}", new Object[]{notification.getId(), notification.getRule()});
        JasmineEventNotification notif = notifFacade.getEventNotification(notification.getId());
        AcknowledgeState ackState = null;
        if (notif.getStatus().booleanValue()) {
            for (JasmineEventNotificationExecutedAction action : notif.getActions()) {
                if (!action.getAction().equals(this.currentAcknowledgeActionName)) continue;
                ackState = new AcknowledgeState(notif.getStatus(), action.getUser(), notif.getId());
            }
        } else {
            ackState = new AcknowledgeState(notif.getStatus(), "", notif.getId());
        }
        ackState.setLoggedUser(secutiryCurrent.getSecurityContext().getPrincipalName());
        this.logger.debug((Object)"Notification {0} checked with status {1}.", new Object[]{ackState.getNotificationId(), ackState.getState()});
        return ackState;
    }

    public String getLoggedUser() {
        return SecurityCurrent.getCurrent().getSecurityContext().getPrincipalName();
    }

    class DisconnectTask
    extends TimerTask {
        DisconnectTask() {
        }

        public void run() {
            NotificationService.this.disconnectTopic();
        }
    }
}

