/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.notification.service.jms;

import java.io.Serializable;
import java.util.ArrayList;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotificationDetail;
import org.ow2.jasmine.event.beans.JasmineEventNotificationExecutedAction;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSMessageListener
implements MessageListener {
    private static Log logger = LogFactory.getLog(JMSMessageListener.class);
    private EventManager<JasmineEventNotification> manager = null;

    public JMSMessageListener(EventManager<JasmineEventNotification> evManager) {
        this.manager = evManager;
    }

    public void onMessage(Message message) {
        logger.debug((Object)"onMessage", new Object[]{message});
        try {
            ObjectMessage om;
            Serializable jasmineEventNotificationObject;
            if (message instanceof ObjectMessage && (jasmineEventNotificationObject = (om = (ObjectMessage)message).getObject()) != null && jasmineEventNotificationObject instanceof JasmineEventNotification) {
                JasmineEventNotification notification = (JasmineEventNotification)jasmineEventNotificationObject;
                JasmineEventNotification ev = new JasmineEventNotification(notification.getId(), notification.getDate(), notification.getLevel(), notification.getMessage(), notification.getStatus(), notification.getRule());
                ArrayList<JasmineEventNotificationDetail> details = new ArrayList<JasmineEventNotificationDetail>();
                for (JasmineEventNotificationDetail detail : notification.getDetails()) {
                    JasmineEventNotificationDetail d = new JasmineEventNotificationDetail(detail.getLabel(), detail.getMessage());
                    details.add(d);
                }
                ev.setDetails(details);
                ArrayList<JasmineEventNotificationExecutedAction> actions = new ArrayList<JasmineEventNotificationExecutedAction>();
                for (JasmineEventNotificationExecutedAction action : notification.getActions()) {
                    JasmineEventNotificationExecutedAction a = new JasmineEventNotificationExecutedAction(action.getComment(), action.getAction(), action.getDate(), action.getUser());
                    actions.add(a);
                }
                ev.setActions(actions);
                this.manager.add((Object)ev);
            }
            message.acknowledge();
        }
        catch (Throwable t) {
            logger.error((Object)"Failed processing JMS message", new Object[]{t});
        }
    }
}

