/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.notification.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.jms.MessageListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotificationExecutedAction;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.JMSConnection;
import org.ow2.jasmine.monitoring.eos.common.jndilocator.ServiceLocator;
import org.ow2.jasmine.monitoring.eos.notification.actions.api.IAction;
import org.ow2.jasmine.monitoring.eos.notification.actions.exchange.ActionResult;
import org.ow2.jasmine.monitoring.eos.notification.actions.impl.AcknowledgeAction;
import org.ow2.jasmine.monitoring.eos.notification.filters.api.IFilter;
import org.ow2.jasmine.monitoring.eos.notification.service.NotificationComparator;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.AcknowledgeState;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.ActionCall;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.ColumnSetting;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.ExecutedAction;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.LevelSetting;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.NotificationBoardSettings;
import org.ow2.jasmine.monitoring.eos.notification.service.exchange.NotificationSetting;
import org.ow2.jasmine.monitoring.eos.notification.service.jms.JMSMessageListener;
import org.ow2.jasmine.monitoring.eos.notification.service.jms.NotificationEventManager;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventNotificationSLBRemote;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.kerneos.core.service.KerneosSimpleService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component
@Instantiate
@Provides
public class NotificationService
implements KerneosSimpleService,
Pojo {
    private InstanceManager __IM;
    private boolean __Fid;
    @ServiceProperty(name="kerneos-service-id", value="notificationService")
    private String id;
    private static final long serialVersionUID = 1L;
    private boolean __Flogger;
    private Log logger;
    private static final String NOTIFICATION_CONFIG = "META-INF/notification-config.xml";
    private static final String NOTIFICATION_CONFIG_XSD = "notification-config.xsd";
    private static final String JMS_TOPIC = "jasmineNotification";
    private static final String DEFAULT_ACKNOWLEDGE_ACTION_CLASS = AcknowledgeAction.class.getName();
    private boolean __FcurrentAcknowledgeActionName;
    private String currentAcknowledgeActionName;
    private boolean __FavailableActions;
    private Map<String, String> availableActions;
    private boolean __FavailableLevels;
    private Map<String, LevelSetting> availableLevels;
    private boolean __Ffilters;
    private Map<String, Boolean> filters;
    private boolean __FalwaysProcessedFilters;
    private List<IFilter> alwaysProcessedFilters;
    private boolean __FonlyWhenLiveProcessedFilters;
    private List<IFilter> onlyWhenLiveProcessedFilters;
    private boolean __FnotifFacade;
    private transient JasmineEventNotificationSLBRemote notifFacade;
    private boolean __Ftimer;
    private transient Timer timer;
    private boolean __FdisconnectTime;
    private long disconnectTime;
    private static final long JMS_CHECK_INTERVAL = 1000L;
    private static final long JMS_TIMEOUT = 60000L;
    private boolean __Fconnection;
    private JMSConnection connection;
    private boolean __Fmanager;
    private NotificationEventManager manager;
    private boolean __F_settings;
    private NotificationBoardSettings _settings;
    private boolean __MgetNotifsFromDB;
    private boolean __MgetNotifsFromDBFromTo$java_util_Date$java_util_Date;
    private boolean __MgetNotifsFromTopic;
    private boolean __MconnectTopic;
    private boolean __MdisconnectTopic;
    private boolean __MresetTimer;
    private boolean __Mfilter$org_ow2_jasmine_event_beans_JasmineEventNotification$boolean;
    private boolean __MinitializeFilters;
    private boolean __MgetActions;
    private boolean __MparseSettings$boolean;
    private boolean __Mexecute$org_ow2_jasmine_monitoring_eos_notification_service_exchange_ActionCall;
    private boolean __MisAcknowledged$org_ow2_jasmine_event_beans_JasmineEventNotification;
    private boolean __MgetLoggedUser;
    private boolean __MreadObject$java_io_ObjectInputStream;

    String __getid() {
        if (!this.__Fid) {
            return this.id;
        }
        return (String)this.__IM.onGet((Object)this, "id");
    }

    void __setid(String string) {
        if (!this.__Fid) {
            this.id = string;
            return;
        }
        this.__IM.onSet((Object)this, "id", (Object)string);
    }

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    String __getcurrentAcknowledgeActionName() {
        if (!this.__FcurrentAcknowledgeActionName) {
            return this.currentAcknowledgeActionName;
        }
        return (String)this.__IM.onGet((Object)this, "currentAcknowledgeActionName");
    }

    void __setcurrentAcknowledgeActionName(String string) {
        if (!this.__FcurrentAcknowledgeActionName) {
            this.currentAcknowledgeActionName = string;
            return;
        }
        this.__IM.onSet((Object)this, "currentAcknowledgeActionName", (Object)string);
    }

    Map __getavailableActions() {
        if (!this.__FavailableActions) {
            return this.availableActions;
        }
        return (Map)this.__IM.onGet((Object)this, "availableActions");
    }

    void __setavailableActions(Map map) {
        if (!this.__FavailableActions) {
            this.availableActions = map;
            return;
        }
        this.__IM.onSet((Object)this, "availableActions", (Object)map);
    }

    Map __getavailableLevels() {
        if (!this.__FavailableLevels) {
            return this.availableLevels;
        }
        return (Map)this.__IM.onGet((Object)this, "availableLevels");
    }

    void __setavailableLevels(Map map) {
        if (!this.__FavailableLevels) {
            this.availableLevels = map;
            return;
        }
        this.__IM.onSet((Object)this, "availableLevels", (Object)map);
    }

    Map __getfilters() {
        if (!this.__Ffilters) {
            return this.filters;
        }
        return (Map)this.__IM.onGet((Object)this, "filters");
    }

    void __setfilters(Map map) {
        if (!this.__Ffilters) {
            this.filters = map;
            return;
        }
        this.__IM.onSet((Object)this, "filters", (Object)map);
    }

    List __getalwaysProcessedFilters() {
        if (!this.__FalwaysProcessedFilters) {
            return this.alwaysProcessedFilters;
        }
        return (List)this.__IM.onGet((Object)this, "alwaysProcessedFilters");
    }

    void __setalwaysProcessedFilters(List list) {
        if (!this.__FalwaysProcessedFilters) {
            this.alwaysProcessedFilters = list;
            return;
        }
        this.__IM.onSet((Object)this, "alwaysProcessedFilters", (Object)list);
    }

    List __getonlyWhenLiveProcessedFilters() {
        if (!this.__FonlyWhenLiveProcessedFilters) {
            return this.onlyWhenLiveProcessedFilters;
        }
        return (List)this.__IM.onGet((Object)this, "onlyWhenLiveProcessedFilters");
    }

    void __setonlyWhenLiveProcessedFilters(List list) {
        if (!this.__FonlyWhenLiveProcessedFilters) {
            this.onlyWhenLiveProcessedFilters = list;
            return;
        }
        this.__IM.onSet((Object)this, "onlyWhenLiveProcessedFilters", (Object)list);
    }

    JasmineEventNotificationSLBRemote __getnotifFacade() {
        if (!this.__FnotifFacade) {
            return this.notifFacade;
        }
        return (JasmineEventNotificationSLBRemote)this.__IM.onGet((Object)this, "notifFacade");
    }

    void __setnotifFacade(JasmineEventNotificationSLBRemote jasmineEventNotificationSLBRemote) {
        if (!this.__FnotifFacade) {
            this.notifFacade = jasmineEventNotificationSLBRemote;
            return;
        }
        this.__IM.onSet((Object)this, "notifFacade", (Object)jasmineEventNotificationSLBRemote);
    }

    Timer __gettimer() {
        if (!this.__Ftimer) {
            return this.timer;
        }
        return (Timer)this.__IM.onGet((Object)this, "timer");
    }

    void __settimer(Timer timer) {
        if (!this.__Ftimer) {
            this.timer = timer;
            return;
        }
        this.__IM.onSet((Object)this, "timer", (Object)timer);
    }

    long __getdisconnectTime() {
        if (!this.__FdisconnectTime) {
            return this.disconnectTime;
        }
        Object object = this.__IM.onGet((Object)this, "disconnectTime");
        Long l = (Long)object;
        return l;
    }

    void __setdisconnectTime(long l) {
        if (!this.__FdisconnectTime) {
            this.disconnectTime = l;
            return;
        }
        Long l2 = new Long(l);
        this.__IM.onSet((Object)this, "disconnectTime", (Object)l2);
    }

    JMSConnection __getconnection() {
        if (!this.__Fconnection) {
            return this.connection;
        }
        return (JMSConnection)this.__IM.onGet((Object)this, "connection");
    }

    void __setconnection(JMSConnection jMSConnection) {
        if (!this.__Fconnection) {
            this.connection = jMSConnection;
            return;
        }
        this.__IM.onSet((Object)this, "connection", (Object)jMSConnection);
    }

    NotificationEventManager __getmanager() {
        if (!this.__Fmanager) {
            return this.manager;
        }
        return (NotificationEventManager)this.__IM.onGet((Object)this, "manager");
    }

    void __setmanager(NotificationEventManager notificationEventManager) {
        if (!this.__Fmanager) {
            this.manager = notificationEventManager;
            return;
        }
        this.__IM.onSet((Object)this, "manager", (Object)notificationEventManager);
    }

    NotificationBoardSettings __get_settings() {
        if (!this.__F_settings) {
            return this._settings;
        }
        return (NotificationBoardSettings)this.__IM.onGet((Object)this, "_settings");
    }

    void __set_settings(NotificationBoardSettings notificationBoardSettings) {
        if (!this.__F_settings) {
            this._settings = notificationBoardSettings;
            return;
        }
        this.__IM.onSet((Object)this, "_settings", (Object)notificationBoardSettings);
    }

    public NotificationService() {
        this(null);
    }

    private NotificationService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(this.getClass()));
        this.__setavailableActions(new HashMap());
        this.__setavailableLevels(new HashMap());
        this.__setfilters(new HashMap());
        this.__setalwaysProcessedFilters(new ArrayList());
        this.__setonlyWhenLiveProcessedFilters(new ArrayList());
        this.__settimer(null);
        this.__setdisconnectTime(0L);
        this.__setconnection(null);
        this.__setmanager(null);
        this.__set_settings(null);
        this.__setnotifFacade((JasmineEventNotificationSLBRemote)ServiceLocator.getInstance().getRemoteObject("db-ejb/notification"));
    }

    public List<JasmineEventNotification> getNotifsFromDB() throws Exception {
        List<JasmineEventNotification> list;
        if (!this.__MgetNotifsFromDB) {
            return this.__getNotifsFromDB();
        }
        try {
            this.__IM.onEntry((Object)this, "getNotifsFromDB", new Object[0]);
            list = this.__getNotifsFromDB();
            this.__IM.onExit((Object)this, "getNotifsFromDB", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNotifsFromDB", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineEventNotification> __getNotifsFromDB() throws Exception {
        this.disconnectTopic();
        this.__getlogger().debug((Object)"Getting notifications from DB", new Object[0]);
        TreeSet<JasmineEventNotification> notifications = new TreeSet<JasmineEventNotification>(new NotificationComparator());
        NotificationBoardSettings settings = this.getActions();
        if (settings.getActionsList() == null || settings.getActionsList().size() == 0) {
            notifications.addAll(this.__getnotifFacade().getAllNotifications());
        } else {
            int keepDisplayed = -1;
            String acknowledgeActionName = null;
            ArrayList<String> synchronizedRules = new ArrayList<String>();
            ArrayList<String> nonSynchronizedRules = new ArrayList<String>();
            for (NotificationSetting setting : settings.getActionsList()) {
                keepDisplayed = setting.getKeepDisplayed();
                acknowledgeActionName = setting.getAcknowledgeActionName();
                if (setting.getRule() == null || setting.getRule().length() <= 0) continue;
                if (setting.isSynchronize()) {
                    synchronizedRules.add(setting.getRule());
                    continue;
                }
                nonSynchronizedRules.add(setting.getRule());
            }
            if (synchronizedRules.size() > 0) {
                String[] synchronizedRulesArray = new String[synchronizedRules.size()];
                synchronizedRules.toArray(synchronizedRulesArray);
                notifications.addAll(this.__getnotifFacade().getEventNotifications(keepDisplayed, acknowledgeActionName, synchronizedRulesArray));
            }
            if (nonSynchronizedRules.size() > 0) {
                String[] nonSynchronizedRulesArray = new String[nonSynchronizedRules.size()];
                nonSynchronizedRules.toArray(nonSynchronizedRulesArray);
                notifications.addAll(this.__getnotifFacade().getEventNotifications(keepDisplayed, null, nonSynchronizedRulesArray));
            }
        }
        this.__getlogger().debug((Object)"Obtained notifications from DB: {0} notifications", new Object[]{notifications.size()});
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        for (JasmineEventNotification notification : notifications) {
            if (!this.filter(notification, false)) continue;
            result.add(notification);
        }
        this.__getlogger().debug((Object)"Filtered notifications obtained from DB: {0} left", new Object[]{result.size()});
        return result;
    }

    public List<JasmineEventNotification> getNotifsFromDBFromTo(Date date, Date date2) throws Exception {
        List<JasmineEventNotification> list;
        if (!this.__MgetNotifsFromDBFromTo$java_util_Date$java_util_Date) {
            return this.__getNotifsFromDBFromTo(date, date2);
        }
        try {
            this.__IM.onEntry((Object)this, "getNotifsFromDBFromTo$java_util_Date$java_util_Date", new Object[]{date, date2});
            list = this.__getNotifsFromDBFromTo(date, date2);
            this.__IM.onExit((Object)this, "getNotifsFromDBFromTo$java_util_Date$java_util_Date", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNotifsFromDBFromTo$java_util_Date$java_util_Date", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineEventNotification> __getNotifsFromDBFromTo(Date dateFrom, Date dateTo) throws Exception {
        this.disconnectTopic();
        this.__getlogger().debug((Object)"Getting notification from Data Base from date {0} to date {1}.", new Object[]{dateFrom, dateTo});
        List notifList = null;
        notifList = this.__getnotifFacade().getEventNotifications(dateFrom, dateTo);
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        if (notifList != null) {
            for (JasmineEventNotification j : notifList) {
                if (!this.filter(j, true)) continue;
                result.add(j);
            }
        }
        notifList = null;
        return result;
    }

    public List<JasmineEventNotification> getNotifsFromTopic() throws Exception {
        List<JasmineEventNotification> list;
        if (!this.__MgetNotifsFromTopic) {
            return this.__getNotifsFromTopic();
        }
        try {
            this.__IM.onEntry((Object)this, "getNotifsFromTopic", new Object[0]);
            list = this.__getNotifsFromTopic();
            this.__IM.onExit((Object)this, "getNotifsFromTopic", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNotifsFromTopic", throwable);
            throw throwable;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JasmineEventNotification> __getNotifsFromTopic() throws Exception {
        this.__getlogger().debug((Object)"Getting notification from JMS Topic", new Object[0]);
        NotificationService notificationService = this;
        synchronized (notificationService) {
            if (this.__getconnection() == null) {
                this.connectTopic();
            } else {
                this.resetTimer();
            }
        }
        ArrayList<JasmineEventNotification> list = new ArrayList<JasmineEventNotification>();
        list.addAll(this.__getmanager().getAll());
        this.__getlogger().debug((Object)"Received {0} notifications.", new Object[]{list.size()});
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        for (JasmineEventNotification j : list) {
            if (!this.filter(j, false)) continue;
            result.add(j);
        }
        list = null;
        return result;
    }

    public void connectTopic() throws Exception {
        if (!this.__MconnectTopic) {
            this.__connectTopic();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "connectTopic", new Object[0]);
            this.__connectTopic();
            this.__IM.onExit((Object)this, "connectTopic", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "connectTopic", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __connectTopic() throws Exception {
        this.__getlogger().debug((Object)"Connecting to the JMS topic...", new Object[0]);
        NotificationService notificationService = this;
        synchronized (notificationService) {
            this.__setmanager(new NotificationEventManager());
            this.__setconnection(new JMSConnection((EventManager)this.__getmanager()));
            this.resetTimer();
            this.__getconnection().connect(JMS_TOPIC, (MessageListener)new JMSMessageListener(this.__getmanager()));
        }
        this.__getlogger().debug((Object)"Connected to the JMS topic", new Object[0]);
    }

    public void disconnectTopic() throws Exception {
        if (!this.__MdisconnectTopic) {
            this.__disconnectTopic();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "disconnectTopic", new Object[0]);
            this.__disconnectTopic();
            this.__IM.onExit((Object)this, "disconnectTopic", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "disconnectTopic", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __disconnectTopic() throws Exception {
        this.__getlogger().debug((Object)"Disconnecting from the JMS topic...", new Object[0]);
        NotificationService notificationService = this;
        synchronized (notificationService) {
            if (this.__getconnection() != null) {
                this.__getconnection().disconnect();
                this.__setconnection(null);
                this.__setmanager(null);
            }
            this.__setdisconnectTime(0L);
            if (this.__gettimer() != null) {
                this.__gettimer().cancel();
                this.__gettimer().purge();
                this.__settimer(null);
            }
        }
        this.__getlogger().debug((Object)"Disconnected from the JMS topic", new Object[0]);
    }

    private void resetTimer() {
        if (!this.__MresetTimer) {
            this.__resetTimer();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "resetTimer", new Object[0]);
            this.__resetTimer();
            this.__IM.onExit((Object)this, "resetTimer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "resetTimer", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __resetTimer() {
        NotificationService notificationService = this;
        synchronized (notificationService) {
            this.__setdisconnectTime(System.currentTimeMillis() + 60000L);
            if (this.__gettimer() == null) {
                this.__settimer(new Timer());
                this.__gettimer().schedule((TimerTask)new DisconnectTask(), 1000L, 1000L);
            }
        }
    }

    private boolean filter(JasmineEventNotification jasmineEventNotification, boolean bl) {
        boolean bl2;
        if (!this.__Mfilter$org_ow2_jasmine_event_beans_JasmineEventNotification$boolean) {
            return this.__filter(jasmineEventNotification, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "filter$org_ow2_jasmine_event_beans_JasmineEventNotification$boolean", new Object[]{jasmineEventNotification, new Boolean(bl)});
            bl2 = this.__filter(jasmineEventNotification, bl);
            this.__IM.onExit((Object)this, "filter$org_ow2_jasmine_event_beans_JasmineEventNotification$boolean", (Object)new Boolean(bl2));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "filter$org_ow2_jasmine_event_beans_JasmineEventNotification$boolean", throwable);
            throw throwable;
        }
        return bl2;
    }

    private boolean __filter(JasmineEventNotification notification, boolean reviewing) {
        boolean result = true;
        for (IFilter filter : this.__getalwaysProcessedFilters()) {
            result &= filter.filter(notification);
        }
        if (!reviewing) {
            for (IFilter filter : this.__getonlyWhenLiveProcessedFilters()) {
                result &= filter.filter(notification);
            }
        }
        return result;
    }

    private void initializeFilters() throws Exception {
        if (!this.__MinitializeFilters) {
            this.__initializeFilters();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initializeFilters", new Object[0]);
            this.__initializeFilters();
            this.__IM.onExit((Object)this, "initializeFilters", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initializeFilters", throwable);
            throw throwable;
        }
    }

    private void __initializeFilters() throws Exception {
        this.__getlogger().debug((Object)"Initialize filters", new Object[0]);
        Set filtersSet = this.__getfilters().keySet();
        for (String className : filtersSet) {
            Class<?> filterClass = Class.forName(className);
            Constructor<?> filterConstructor = filterClass.getConstructor(new Class[0]);
            IFilter filter = (IFilter)filterConstructor.newInstance(new Object[0]);
            if (((Boolean)this.__getfilters().get(className)).booleanValue()) {
                this.__getlogger().debug((Object)"Add {0} to the alwaysExecutedFilter list", new Object[]{className});
                this.__getalwaysProcessedFilters().add(filter);
                continue;
            }
            this.__getlogger().debug((Object)"Add {0} to the onlyWhenLiveProcessedFilters list", new Object[]{className});
            this.__getonlyWhenLiveProcessedFilters().add(filter);
        }
    }

    public NotificationBoardSettings getActions() throws Exception {
        NotificationBoardSettings notificationBoardSettings;
        if (!this.__MgetActions) {
            return this.__getActions();
        }
        try {
            this.__IM.onEntry((Object)this, "getActions", new Object[0]);
            notificationBoardSettings = this.__getActions();
            this.__IM.onExit((Object)this, "getActions", (Object)notificationBoardSettings);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getActions", throwable);
            throw throwable;
        }
        return notificationBoardSettings;
    }

    private NotificationBoardSettings __getActions() throws Exception {
        if (this.__get_settings() == null) {
            try {
                this.__set_settings(this.parseSettings(false));
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Could not parse notification-config.xml: ", new Object[]{e});
                throw e;
            }
        }
        return this.__get_settings();
    }

    private NotificationBoardSettings parseSettings(boolean bl) throws Exception {
        NotificationBoardSettings notificationBoardSettings;
        if (!this.__MparseSettings$boolean) {
            return this.__parseSettings(bl);
        }
        try {
            this.__IM.onEntry((Object)this, "parseSettings$boolean", new Object[]{new Boolean(bl)});
            notificationBoardSettings = this.__parseSettings(bl);
            this.__IM.onExit((Object)this, "parseSettings$boolean", (Object)notificationBoardSettings);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "parseSettings$boolean", throwable);
            throw throwable;
        }
        return notificationBoardSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationBoardSettings __parseSettings(boolean validate) throws Exception {
        NotificationBoardSettings settings = new NotificationBoardSettings();
        Document doc = null;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream resource = cl.getResourceAsStream(NOTIFICATION_CONFIG);
        if (resource != null) {
            this.__getlogger().debug((Object)"Loading the notification XML file: ", new Object[]{NOTIFICATION_CONFIG});
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                doc = documentBuilder.parse(resource);
            }
            finally {
                resource.close();
                resource = null;
            }
        }
        if (doc == null) {
            this.__getlogger().error((Object)"Nothing has been parsed for : ", new Object[]{NOTIFICATION_CONFIG});
            return settings;
        }
        if (validate) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource schemaFile = new StreamSource(cl.getResource(NOTIFICATION_CONFIG_XSD).openStream());
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            try {
                validator.validate(new DOMSource(doc));
            }
            catch (SAXException e) {
                throw new Exception("The configuration file META-INF/notification-config.xml is not well formed. Please refer to the XML Schema.", e);
            }
        }
        doc.getDocumentElement().normalize();
        Node acknowledgeClass = doc.getElementsByTagName("acknowledgeClass").item(0);
        String ackClassSet = acknowledgeClass.getAttributes().getNamedItem("class").getTextContent();
        this.__setcurrentAcknowledgeActionName(acknowledgeClass.getAttributes().getNamedItem("name").getTextContent());
        if ("default".equals(ackClassSet)) {
            this.__getavailableActions().put(this.__getcurrentAcknowledgeActionName(), DEFAULT_ACKNOWLEDGE_ACTION_CLASS);
        } else {
            this.__getavailableActions().put(this.__getcurrentAcknowledgeActionName(), ackClassSet);
        }
        settings.setAckColor(acknowledgeClass.getAttributes().getNamedItem("color").getTextContent());
        Node keepDisplayed = doc.getElementsByTagName("keepDisplayed").item(0);
        String numberOfHours = keepDisplayed.getAttributes().getNamedItem("hours").getTextContent();
        Node levels = doc.getElementsByTagName("levels").item(0);
        NodeList levelList = levels.getChildNodes();
        for (int i = 0; i < levelList.getLength(); ++i) {
            Node level = levelList.item(i);
            if (!"level".equals(level.getNodeName())) continue;
            LevelSetting levelSetting = new LevelSetting();
            String name = level.getAttributes().getNamedItem("name").getTextContent();
            String color = level.getAttributes().getNamedItem("color").getTextContent();
            levelSetting.setLevel(name);
            levelSetting.setColor(color);
            this.__getlogger().debug((Object)"name : {0}", new Object[]{level.getAttributes().getNamedItem("name").getTextContent()});
            this.__getlogger().debug((Object)"color : {0}", new Object[]{level.getAttributes().getNamedItem("color").getTextContent()});
            this.__getavailableLevels().put(levelSetting.getLevel(), levelSetting);
        }
        ArrayList<NotificationSetting> notifList = new ArrayList<NotificationSetting>();
        NodeList listOfEntries = doc.getElementsByTagName("notifs");
        block6: for (int j = 0; j < listOfEntries.getLength(); ++j) {
            Node notifs = listOfEntries.item(j);
            this.__getlogger().debug((Object)"<notifs> node name : {0}", new Object[]{notifs.getNodeName()});
            NodeList allNotifs = notifs.getChildNodes();
            for (int k = 0; k < allNotifs.getLength(); ++k) {
                Node notif = allNotifs.item(k);
                this.__getlogger().debug((Object)"<notif> node name : {0}", new Object[]{notif.getNodeName()});
                if ("All".equals(notif.getNodeName())) {
                    this.__getlogger().debug((Object)"Getting all the notifications ... No levels will be associated then.", new Object[0]);
                    settings.setActionsList(notifList);
                    continue block6;
                }
                if (!"notif".equals(notif.getNodeName())) continue;
                NotificationSetting actionBinding = new NotificationSetting();
                actionBinding.setRule(notif.getAttributes().getNamedItem("rule").getTextContent());
                actionBinding.setKeepDisplayed(Integer.valueOf(numberOfHours));
                Node nitem = notif.getAttributes().getNamedItem("level");
                if (nitem != null) {
                    if (this.__getavailableLevels().get(nitem.getTextContent()) != null) {
                        actionBinding.setLevel((LevelSetting)this.__getavailableLevels().get(notif.getAttributes().getNamedItem("level").getTextContent()));
                    } else {
                        throw new Exception("Level " + notif.getAttributes().getNamedItem("level").getTextContent() + " not defined in the <levels> tag");
                    }
                }
                boolean synch = Boolean.valueOf(notif.getAttributes().getNamedItem("synchronized").getTextContent());
                actionBinding.setSynchronize(synch);
                actionBinding.setAcknowledgeActionName(this.__getcurrentAcknowledgeActionName());
                NodeList allActions = notif.getChildNodes();
                for (int m = 0; m < allActions.getLength(); ++m) {
                    Node actions = allActions.item(m);
                    this.__getlogger().debug((Object)"<actions> node name : {0}", new Object[]{actions.getNodeName()});
                    if (!"actions".equals(actions.getNodeName())) continue;
                    NodeList allAction = actions.getChildNodes();
                    for (int l = 0; l < allAction.getLength(); ++l) {
                        Node action = allAction.item(l);
                        this.__getlogger().debug((Object)"<action> node name : {0}", new Object[]{action.getNodeName()});
                        if (!"action".equals(action.getNodeName())) continue;
                        actionBinding.addAction(action.getAttributes().getNamedItem("name").getTextContent());
                        if (this.__getavailableActions().containsKey(action.getAttributes().getNamedItem("name").getTextContent())) continue;
                        this.__getavailableActions().put(action.getAttributes().getNamedItem("name").getTextContent(), action.getAttributes().getNamedItem("className").getTextContent());
                    }
                }
                this.__getlogger().debug((Object)"number of actions in the binding object : {0}", new Object[]{actionBinding.getAction().size()});
                notifList.add(actionBinding);
            }
        }
        settings.setActionsList(notifList);
        Node displayedColumnsNode = doc.getElementsByTagName("displayedColumns").item(0);
        ArrayList<ColumnSetting> colList = new ArrayList<ColumnSetting>();
        NodeList columnList = displayedColumnsNode.getChildNodes();
        for (int columnListLength = 0; columnListLength < columnList.getLength(); ++columnListLength) {
            ColumnSetting columnSetting = new ColumnSetting();
            Node column = columnList.item(columnListLength);
            if (!"column".equals(column.getNodeName())) continue;
            String id = column.getAttributes().getNamedItem("id").getTextContent();
            String dataField = column.getAttributes().getNamedItem("dataField").getTextContent();
            String displayed = column.getAttributes().getNamedItem("displayed").getTextContent();
            if (column.getAttributes().getNamedItem("headerText") != null) {
                String headerText = column.getAttributes().getNamedItem("headerText").getTextContent();
                columnSetting.setHeaderText(headerText);
            } else {
                columnSetting.setHeaderText(id);
            }
            columnSetting.setId(id);
            columnSetting.setDataField(dataField);
            columnSetting.setDisplayed(displayed);
            colList.add(columnSetting);
        }
        settings.setColumnsList(colList);
        Node filtersNode = doc.getElementsByTagName("filters").item(0);
        NodeList filterList = filtersNode.getChildNodes();
        for (int filterListLength = 0; filterListLength < filterList.getLength(); ++filterListLength) {
            Node filter = filterList.item(filterListLength);
            if (!"filter".equals(filter.getNodeName())) continue;
            String className = filter.getAttributes().getNamedItem("class").getTextContent();
            Boolean reviewProcessed = Boolean.valueOf(filter.getAttributes().getNamedItem("reviewProcess").getTextContent());
            this.__getlogger().debug((Object)"reviewProcess {0}", new Object[]{reviewProcessed});
            this.__getfilters().put(className, reviewProcessed);
        }
        this.initializeFilters();
        return settings;
    }

    public ExecutedAction execute(ActionCall actionCall) throws Exception {
        ExecutedAction executedAction;
        if (!this.__Mexecute$org_ow2_jasmine_monitoring_eos_notification_service_exchange_ActionCall) {
            return this.__execute(actionCall);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_ow2_jasmine_monitoring_eos_notification_service_exchange_ActionCall", new Object[]{actionCall});
            executedAction = this.__execute(actionCall);
            this.__IM.onExit((Object)this, "execute$org_ow2_jasmine_monitoring_eos_notification_service_exchange_ActionCall", (Object)executedAction);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_ow2_jasmine_monitoring_eos_notification_service_exchange_ActionCall", throwable);
            throw throwable;
        }
        return executedAction;
    }

    private ExecutedAction __execute(ActionCall action) throws Exception {
        try {
            String actionName = action.getName();
            String actionClassName = (String)this.__getavailableActions().get(actionName);
            if (actionName.equals(this.__getcurrentAcknowledgeActionName())) {
                this.__getlogger().debug((Object)"Update notification {0} to the acknowledged state", new Object[]{action.getNotification().getId()});
                this.__getnotifFacade().updateNotificationStatus(action.getNotification().getId(), true);
            }
            JasmineEventNotificationExecutedAction actionToSave = new JasmineEventNotificationExecutedAction(action.getComment(), actionName, new Date(), action.getUser());
            this.__getnotifFacade().saveExecutedAction(action.getNotification().getId(), actionToSave);
            this.__getlogger().debug((Object)"Action name : {0} , id : {1} .\n\tThe associated class is : {2}", new Object[]{actionName, action.getNotification().getId(), actionClassName});
            if (actionName == null || actionClassName == null) {
                throw new IllegalArgumentException("Unknown action: name " + actionName + ", class " + actionClassName);
            }
            Class<?> actionClass = Class.forName(actionClassName);
            Constructor<?> actionConstructor = actionClass.getConstructor(new Class[0]);
            IAction actionInstance = (IAction)actionConstructor.newInstance(new Object[0]);
            this.__getlogger().debug((Object)"Executing the following action : {0}", new Object[]{actionInstance.getName()});
            ActionResult actionResult = actionInstance.execute(action.getNotification());
            actionResult.setName(actionName);
            JasmineEventNotification updatedNotification = this.__getnotifFacade().getEventNotification(action.getNotification().getId());
            ExecutedAction executedAction = new ExecutedAction();
            executedAction.setActionResult(actionResult);
            executedAction.setUser(action.getUser());
            executedAction.setNotification(updatedNotification);
            if (this.__getconnection() != null) {
                this.__getconnection().sendObjectMessage((Serializable)updatedNotification);
            }
            return executedAction;
        }
        catch (Exception e) {
            this.__getlogger().error((Object)"Failed executing action", new Object[]{e});
            throw e;
        }
    }

    public AcknowledgeState isAcknowledged(JasmineEventNotification jasmineEventNotification) {
        AcknowledgeState acknowledgeState;
        if (!this.__MisAcknowledged$org_ow2_jasmine_event_beans_JasmineEventNotification) {
            return this.__isAcknowledged(jasmineEventNotification);
        }
        try {
            this.__IM.onEntry((Object)this, "isAcknowledged$org_ow2_jasmine_event_beans_JasmineEventNotification", new Object[]{jasmineEventNotification});
            acknowledgeState = this.__isAcknowledged(jasmineEventNotification);
            this.__IM.onExit((Object)this, "isAcknowledged$org_ow2_jasmine_event_beans_JasmineEventNotification", (Object)acknowledgeState);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isAcknowledged$org_ow2_jasmine_event_beans_JasmineEventNotification", throwable);
            throw throwable;
        }
        return acknowledgeState;
    }

    private AcknowledgeState __isAcknowledged(JasmineEventNotification notification) {
        String loggedUser = this.getLoggedUser();
        this.__getlogger().debug((Object)"logged user : {0}", new Object[]{loggedUser});
        this.__getlogger().debug((Object)"Checking notification {0} from rule {1}", new Object[]{notification.getId(), notification.getRule()});
        JasmineEventNotification notif = this.__getnotifFacade().getEventNotification(notification.getId());
        AcknowledgeState ackState = null;
        if (notif.getStatus().booleanValue()) {
            for (JasmineEventNotificationExecutedAction action : notif.getActions()) {
                if (!action.getAction().equals(this.__getcurrentAcknowledgeActionName())) continue;
                ackState = new AcknowledgeState(notif.getStatus(), action.getUser(), notif);
            }
        } else {
            ackState = new AcknowledgeState(notif.getStatus(), "", notif);
        }
        ackState.setLoggedUser(loggedUser);
        this.__getlogger().debug((Object)"Notification {0} checked with status {1}.", new Object[]{ackState.getNotification().getId(), ackState.getState()});
        return ackState;
    }

    public String getLoggedUser() {
        String string;
        if (!this.__MgetLoggedUser) {
            return this.__getLoggedUser();
        }
        try {
            this.__IM.onEntry((Object)this, "getLoggedUser", new Object[0]);
            string = this.__getLoggedUser();
            this.__IM.onExit((Object)this, "getLoggedUser", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getLoggedUser", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getLoggedUser() {
        SecurityContext securityContext;
        SecurityCurrent securityCurrent = SecurityCurrent.getCurrent();
        if (securityCurrent != null && (securityContext = securityCurrent.getSecurityContext()) != null) {
            return securityContext.getPrincipalName();
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (!this.__MreadObject$java_io_ObjectInputStream) {
            this.__readObject(objectInputStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "readObject$java_io_ObjectInputStream", new Object[]{objectInputStream});
            this.__readObject(objectInputStream);
            this.__IM.onExit((Object)this, "readObject$java_io_ObjectInputStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "readObject$java_io_ObjectInputStream", throwable);
            throw throwable;
        }
    }

    private void __readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.__setnotifFacade((JasmineEventNotificationSLBRemote)ServiceLocator.getInstance().getRemoteObject("db-ejb/notification"));
        if (this.__getdisconnectTime() > 0L) {
            this.resetTimer();
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("onlyWhenLiveProcessedFilters")) {
                this.__FonlyWhenLiveProcessedFilters = true;
            }
            if (set.contains("connection")) {
                this.__Fconnection = true;
            }
            if (set.contains("manager")) {
                this.__Fmanager = true;
            }
            if (set.contains("availableActions")) {
                this.__FavailableActions = true;
            }
            if (set.contains("notifFacade")) {
                this.__FnotifFacade = true;
            }
            if (set.contains("alwaysProcessedFilters")) {
                this.__FalwaysProcessedFilters = true;
            }
            if (set.contains("currentAcknowledgeActionName")) {
                this.__FcurrentAcknowledgeActionName = true;
            }
            if (set.contains("id")) {
                this.__Fid = true;
            }
            if (set.contains("timer")) {
                this.__Ftimer = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("_settings")) {
                this.__F_settings = true;
            }
            if (set.contains("disconnectTime")) {
                this.__FdisconnectTime = true;
            }
            if (set.contains("filters")) {
                this.__Ffilters = true;
            }
            if (set.contains("availableLevels")) {
                this.__FavailableLevels = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getNotifsFromDB")) {
                this.__MgetNotifsFromDB = true;
            }
            if (set.contains("getNotifsFromDBFromTo$java_util_Date$java_util_Date")) {
                this.__MgetNotifsFromDBFromTo$java_util_Date$java_util_Date = true;
            }
            if (set.contains("getNotifsFromTopic")) {
                this.__MgetNotifsFromTopic = true;
            }
            if (set.contains("connectTopic")) {
                this.__MconnectTopic = true;
            }
            if (set.contains("disconnectTopic")) {
                this.__MdisconnectTopic = true;
            }
            if (set.contains("resetTimer")) {
                this.__MresetTimer = true;
            }
            if (set.contains("filter$org_ow2_jasmine_event_beans_JasmineEventNotification$boolean")) {
                this.__Mfilter$org_ow2_jasmine_event_beans_JasmineEventNotification$boolean = true;
            }
            if (set.contains("initializeFilters")) {
                this.__MinitializeFilters = true;
            }
            if (set.contains("getActions")) {
                this.__MgetActions = true;
            }
            if (set.contains("parseSettings$boolean")) {
                this.__MparseSettings$boolean = true;
            }
            if (set.contains("execute$org_ow2_jasmine_monitoring_eos_notification_service_exchange_ActionCall")) {
                this.__Mexecute$org_ow2_jasmine_monitoring_eos_notification_service_exchange_ActionCall = true;
            }
            if (set.contains("isAcknowledged$org_ow2_jasmine_event_beans_JasmineEventNotification")) {
                this.__MisAcknowledged$org_ow2_jasmine_event_beans_JasmineEventNotification = true;
            }
            if (set.contains("getLoggedUser")) {
                this.__MgetLoggedUser = true;
            }
            if (set.contains("readObject$java_io_ObjectInputStream")) {
                this.__MreadObject$java_io_ObjectInputStream = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    class DisconnectTask
    extends TimerTask {
        DisconnectTask() {
        }

        @Override
        public void run() {
            try {
                if (System.currentTimeMillis() > NotificationService.this.__getdisconnectTime()) {
                    NotificationService.this.disconnectTopic();
                }
            }
            catch (Throwable t) {
                NotificationService.this.__getlogger().error((Object)"Failed disconnecting from JMS topic", new Object[]{t});
            }
        }
    }
}

