/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.probemanager.view
{
    import com.adobe.cairngorm.control.CairngormEventDispatcher;

    import flash.net.FileFilter;

    import mx.collections.ArrayCollection;
    import mx.controls.Alert;
    import mx.events.CloseEvent;
    import mx.events.DataGridEvent;
    import mx.managers.PopUpManager;
    import mx.messaging.events.MessageEvent;
    import mx.messaging.messages.AsyncMessage;

    import org.granite.gravity.Consumer;
    import org.ow2.jasmine.kerneos.common.event.KerneosNotificationEvent;
    import org.ow2.jasmine.monitoring.eos.common.controls.ServerSideExceptionWindow;
    import org.ow2.jasmine.monitoring.eos.common.events.LoadEvent;
    import org.ow2.jasmine.monitoring.eos.common.events.ServerSideExceptionEvent;
    import org.ow2.jasmine.monitoring.eos.common.view.LoadWindow;
    import org.ow2.jasmine.monitoring.eos.probemanager.event.*;
    import org.ow2.jasmine.monitoring.eos.probemanager.model.*;
    import org.ow2.jasmine.monitoring.eos.probemanager.vo.*;

    /**
     * This is the action script part of the Probe Manager
     * @author Philippe Durieux
     */
    [Bindable]
    public class ProbeManagerUtil
    {
        // Keep a reference on the main application (mxml part)
        protected var main:Object;

        private var model:ProbeManagerModelLocator=ProbeManagerModelLocator.getInstance();
        private var dispatcher:CairngormEventDispatcher=CairngormEventDispatcher.getInstance();

        private var consumer:Consumer=null;

        public var commandNames:ArrayCollection=new ArrayCollection(["stat -name", "poll -tx", "poll -http", "poll -cpusun", "poll -ds", "poll -jcacf", "poll -servlet", "poll -joramq", "poll -slb", "poll -sfb", "poll -ent", "snap -name"]);

        private var _selectedProbeIdent:int=-1;

        private var _mbeanlist:ArrayCollection;

        private var _filter:String;

        public var sortcolumnindex:int=0;

        public function ProbeManagerUtil(mainApp:Object)
        {
            this.main=mainApp;
        }

        public function initComponent():void
        {
            model.util=this; // used to retrive this from every module

            // Listen to server side events
            dispatcher.addEventListener(ServerSideExceptionEvent.SERVER_SIDE_EXCEPTION, ServerSideExceptionEvent.show);
            dispatcher.addEventListener(NotificationEvent.NOTIFICATION, dispatchNotification);
            subscribe();
            dorefresh();
        }

        public function dispatchNotification(event:NotificationEvent):void
        {
            // Stop the event propagation
            event.stopImmediatePropagation();
            event.preventDefault();

            main.dispatchEvent(new KerneosNotificationEvent(KerneosNotificationEvent.KERNEOS_NOTIFICATION, event.notification, KerneosNotificationEvent.INFO));

            // This line added to fix the problem of displaying the current probe
            // after an action like create/copy/modify
            setMyState();
        }

        public var window:MBeanWindow=null;

        public function closeMBeanWindow():void
        {
            PopUpManager.removePopUp(window);
            window=null;
        }

        /**
         * A new mbeanlist has been retrieved from the target server
         */
        public function set mbeanlist(value:ArrayCollection):void
        {
            _mbeanlist=value;
            if (window != null)
                return;
            window=PopUpManager.createPopUp(main.probelist, MBeanWindow, true) as MBeanWindow;
            window.init(this);
            PopUpManager.centerPopUp(window);
        }

        public function get mbeanlist():ArrayCollection
        {
            return _mbeanlist;
        }

        public function set filter(value:String):void
        {
            _filter=value;
        }

        public function get filter():String
        {
            return _filter;
        }

        public function set selectedProbeIdent(value:int):void
        {
            _selectedProbeIdent=value;
            if (value >= 0)
            {
                setMyState();
            }
        }

        public function get selectedProbeIdent():int
        {
            return _selectedProbeIdent;
        }

        public function changeProbeGrid():void
        {
            //Alert.show("changeProbeGrid");
            setMyState();
        }

        public function creationCompleteProbeGrid():void
        {
            //sortProbGrid();
        }

        // FIXME: This dosn't work, and we don't know when to call it.
        private function sortProbGrid():void
        {
            // Sort the datagrid according to the chosen column index
            var event:DataGridEvent=new DataGridEvent(DataGridEvent.HEADER_RELEASE, false, true, sortcolumnindex);
            main.probeGrid.dispatchEvent(event);
        }

        /**
         * Refresh Button Handler
         */
        public function refresh():void
        {
            main.currentState="";

            // Reset value to be sure that the binding will go in the setter
            // after model has changed.
            // Indeed, setters may not be called when value do not change.
            selectedProbeIdent=-1;

            dorefresh();
        }

        private function dorefresh():void
        {
            // make sure the selectedIndex will be recomputed in setMyState()
            main.probeGrid.selectedIndex=-1;

            var ev:SimpleCommandEvent;

            ev=new SimpleCommandEvent(SimpleCommandEvent.GET_OUTPUTS_EVENT);
            dispatcher.dispatchEvent(ev);

            ev=new SimpleCommandEvent(SimpleCommandEvent.GET_TARGETS_EVENT);
            dispatcher.dispatchEvent(ev);

            ev=new SimpleCommandEvent(SimpleCommandEvent.GET_PROBES_EVENT);
            dispatcher.dispatchEvent(ev);
        }

        /**
         * Subscribe to the jasmineProbe Topic to receive probe state modifications:
         */
        private function subscribe():void
        {
            consumer=new Consumer();
            consumer.destination="gravityProbeManager";
            consumer.topic="jasmineProbe";
            consumer.subscribe();
            consumer.addEventListener(MessageEvent.MESSAGE, probeEventHandler);
        }

        public function probeEventHandler(event:MessageEvent):void
        {
            var msg:AsyncMessage=event.message as AsyncMessage;
            if (msg.body is ProbeEvent)
            {
                var probeEvent:ProbeEvent=msg.body as ProbeEvent;
                model.updateProbe(probeEvent);
                setMyState(); // TODO Should be done by binding ?
                return;
            }
            if (msg.body is ProbeResult)
            {
                var probeResult:ProbeResult=msg.body as ProbeResult;
                model.putResult(probeResult);
                return;
            }
            Alert.show("Received an unknown type of message on topic jasmineProbe");
        }

        public function enterRunningState():void
        {
            var probe:Probe=main.probeGrid.selectedItem;
            // reset probe results table
            model.resetProbeResults();
            // Listen to probe results if jasmine output set
            if (probe.hasJasmineOutput())
            {
                var ev:SimpleCommandEvent;
                ev=new SimpleCommandEvent(SimpleCommandEvent.START_LISTEN_EVENT);
                ev.ident=probe.probeId;
                dispatcher.dispatchEvent(ev);
            }
            // Set a target column in result if more than 1 target
            main.targetcolumn.visible=(probe.targets.length > 1);
            // Set a bean column  in result if more than 1 bean
            main.beancolumn.visible=probe.hasMultipleBeans();
        }

        public function enterListState():void
        {
            //Alert.show("state set to listprobes index=" + main.probeGrid.selectedIndex);
            // stop listening to probe result
            var ev:SimpleCommandEvent;
            ev=new SimpleCommandEvent(SimpleCommandEvent.STOP_LISTEN_EVENT);
            var probe:Probe=main.probeGrid.selectedItem;
            ev.ident=probe.probeId;
            dispatcher.dispatchEvent(ev);
        }

        public function showHelp():void
        {
            var helpWindow:ProbeManagerHelp=PopUpManager.createPopUp(main.mainbox, ProbeManagerHelp, true) as ProbeManagerHelp;
            //var helpWindow : ProbeManagerHelp = new ProbeManagerHelp();
            //PopUpManager.addPopUp(helpWindow, Application.application as DisplayObject, false);
            PopUpManager.centerPopUp(helpWindow);
        }

        public function setMyState():void
        {
            // force a state change to update results
            main.currentState="";
            var probe:Probe=main.probeGrid.selectedItem;

            if (main.probeGrid.selectedIndex < 0)
            {
                // scroll To Selected Probe
                var index:int=0;
                for each (var p:Probe in model.probes)
                {
                    if (p.probeId == _selectedProbeIdent)
                    {
                        main.probeGrid.selectedItem=p;
                        main.probeGrid.selectedIndex=index;
                        probe=p;
                        break;
                    }
                    index++;
                }
                    //Alert.show("scroll To Selected Probe " + main.probeGrid.selectedIndex);
            }
            switch (probe.state)
            {
                case Probe.STARTED:
                case Probe.RUNNING:
                    main.currentState="runningprobe";
                    break;
                case Probe.FAILED:
                    main.currentState="failedprobe";
                    break;
                default:
                    main.currentState="listprobes";
                    break;
            }
        }

        /**
         * Check Filter
         */
        public function checkClickHandler():void
        {
            this.filter=main.formfilter.text;
            refreshMBeans();
        }

        public function applyFilter():void
        {
            if (main.currentState == "editprobe")
                main.formfilter.text=this.filter;
            closeMBeanWindow();
        }

        public function viewMBeanList():void
        {
            this.filter="";
            refreshMBeans();
        }

        /**
         * Get the mbean list from the selected target server, according to
         * the filter this.filter.
         */
        public function refreshMBeans():void
        {
            var ev:MBeanCommandEvent;
            ev=new MBeanCommandEvent(MBeanCommandEvent.GET_MBEANS_EVENT);
            var targetlist:Array=main.targetGrid.selectedItems;
            if (targetlist.length > 0)
            {
                // Check against the first target, in case of multiple targets
                ev.probetarget=targetlist[0] as ProbeTarget;
            }
            else
            {
                Alert.show("No target selected");
                return;
            }
            ev.filter=filter;
            dispatcher.dispatchEvent(ev);
        }

        /**
         * Apply the changes made on a Probe
         */
        public function applyClickHandler():void
        {
            // Build a new value object with the values set in the form.
            var old:Probe=main.probeGrid.selectedItem;
            var modified:Probe=new Probe();
            modified.probeId=old.probeId;
            modified.selected=false;
            modified.args=main.formargs.text;
            modified.filter=main.formfilter.text;
            modified.period=int(main.formperiod.value);
            modified.refreshPeriod=int(main.formrefreshperiod.value);
            // eventswitch forces the separator to the default value!
            modified.separator=old.separator;
            modified.fullcmd=main.formfullcmd.selectedItem;

            // get the modified outputId list
            var outputlist:Array=main.outputGrid.selectedItems;
            var idlist:ArrayCollection=new ArrayCollection();
            for (var i:int=0; i < outputlist.length; i++)
            {
                idlist.addItem((outputlist[i] as ProbeOutput).name);
            }
            modified.outputId=idlist;

            // get the modified targetId list
            var targetlist:Array=main.targetGrid.selectedItems;
            idlist=new ArrayCollection();
            for (i=0; i < targetlist.length; i++)
            {
                idlist.addItem((targetlist[i] as ProbeTarget).name);
            }
            modified.targetId=idlist;

            // dispatch event to apply the changes on the server
            var ev:ProbeCommandEvent;
            ev=new ProbeCommandEvent(ProbeCommandEvent.MODIFY_PROBE_EVENT);
            ev.probe=modified;
            dispatcher.dispatchEvent(ev);
            // exit from state editprobe
            main.currentState="";
        }

        public function startClickHandler():void
        {
            var probe:Probe=main.probeGrid.selectedItem;
            startProbe(probe.probeId);
        }

        public function stopClickHandler():void
        {
            var probe:Probe=main.probeGrid.selectedItem;
            stopProbe(probe.probeId);
        }

        private function startProbe(probeId:int):void
        {
            var ev:SimpleCommandEvent;
            ev=new SimpleCommandEvent(SimpleCommandEvent.START_PROBE_EVENT);
            ev.ident=probeId;
            dispatcher.dispatchEvent(ev);
            main.currentState="";
        }

        private function stopProbe(probeId:int):void
        {
            var ev:SimpleCommandEvent;
            ev=new SimpleCommandEvent(SimpleCommandEvent.STOP_PROBE_EVENT);
            ev.ident=probeId;
            dispatcher.dispatchEvent(ev);
            main.currentState="";
        }

        public function stopall():void
        {
            var ev:SimpleCommandEvent;
            ev=new SimpleCommandEvent(SimpleCommandEvent.STOP_ALL_PROBES_EVENT);
            dispatcher.dispatchEvent(ev);
            main.currentState="";
        }

        public function startall():void
        {
            var ev:SimpleCommandEvent;
            ev=new SimpleCommandEvent(SimpleCommandEvent.START_ALL_PROBES_EVENT);
            dispatcher.dispatchEvent(ev);
            main.currentState="";
        }

        public function removeall():void
        {
            Alert.show("Do you really want to remove ALL the probes ?", "Remove All Probes", Alert.YES | Alert.CANCEL, main.probelist, removeAllProbes, null, Alert.YES);
        }

        private function removeAllProbes(event:CloseEvent):void
        {
            if (event.detail == Alert.YES)
            {
                var ev:SimpleCommandEvent;
                ev=new SimpleCommandEvent(SimpleCommandEvent.REMOVE_ALL_PROBES_EVENT);
                dispatcher.dispatchEvent(ev);
                main.currentState="";
            }
        }

        public function copyClickHandler():void
        {
            copyProbe(main.probeGrid.selectedItem);
        }

        /**
         *
         * @param probe
         */
        private function copyProbe(probe:Probe):void
        {
            var ev:ProbeCommandEvent;
            ev=new ProbeCommandEvent(ProbeCommandEvent.COPY_PROBE_EVENT);
            ev.probe=probe;
            dispatcher.dispatchEvent(ev);
            main.currentState="";
        }

        /**
         *
         * @param period
         * @return
         */
        public function showPeriod(period:int):String
        {
            if (period > 0)
                return "Period : " + period + " seconds";
            else
                return "One shot Probe";
        }

        /**
         *
         * @param period
         * @return
         */
        public function showRefreshPeriod(period:int):String
        {
            if (period > 0)
                return "refresh Period : " + period + " seconds";
            else
                return "";
        }

        // -------------------------------------------------------
        // Reset a Probe
        // -------------------------------------------------------

        public function resetClickHandler():void
        {
            // Just reinit all
            initComponent();
        }

        // -------------------------------------------------------
        // Remove a Probe
        // -------------------------------------------------------

        public function removeClickHandler():void
        {
            Alert.show("Do you really want to remove this probe ?", "Remove Probe", Alert.YES | Alert.CANCEL, main.probelist, removeSelectedProbe, null, Alert.YES);
        }

        private function removeSelectedProbe(event:CloseEvent):void
        {
            if (event.detail == Alert.YES)
            {
                removeProbe(main.probeGrid.selectedItem.probeId);
            }
        }

        private function removeProbe(probeId:int):void
        {
            var ev:SimpleCommandEvent;

            ev=new SimpleCommandEvent(SimpleCommandEvent.REMOVE_PROBE_EVENT);
            ev.ident=probeId;
            dispatcher.dispatchEvent(ev);
            main.currentState="";
        }

        // -------------------------------------------------------------------------
        // Create a Probe
        // -------------------------------------------------------------------------

        protected var probewin:NewProbe;

        public function createProbe(e:Event):void
        {
            if (probewin != null)
            {
                Alert.show("Already creating a probe");
                return;
            }
            probewin=PopUpManager.createPopUp(main.mainbox, NewProbe, false) as NewProbe;
            probewin.init(this, main.probeGrid.selectedItem as Probe);
            PopUpManager.centerPopUp(probewin);
        }

        public function addProbe():void
        {
            // Build a new value object with the values set in the form.
            var modified:Probe=new Probe();
            modified.fullcmd=probewin.npfullcmd.selectedItem as String;
            modified.filter=probewin.npfilter.text;
            // TODO: several output or target possible
            modified.outputId=new ArrayCollection([probewin.npoutput.selectedItem as String]);
            modified.targetId=new ArrayCollection([probewin.nptarget.selectedItem as String]);
            modified.separator=";"; // eventswitch forces default value
            modified.period=int(probewin.npperiod.value);
            modified.refreshPeriod=int(probewin.nprefreshperiod.value);
            modified.args=probewin.npargs.text;

            // return to initial state
            main.currentState="";

            // close the popup window
            closeProbeWindow();

            // dispatch event to create the probe on the server
            var ev:ProbeCommandEvent;
            ev=new ProbeCommandEvent(ProbeCommandEvent.NEW_PROBE_EVENT);
            ev.probe=modified;
            dispatcher.dispatchEvent(ev);
        }

        public function closeProbeWindow():void
        {
            PopUpManager.removePopUp(probewin);
            probewin=null;
        }


        // -------------------------------------------------------------------------
        // Create an Output
        // -------------------------------------------------------------------------

        protected var outputwin:NewOutput;

        public function createOutput(e:Event):void
        {
            if (outputwin != null)
            {
                Alert.show("Already creating an output");
                return;
            }
            outputwin=PopUpManager.createPopUp(main.mainbox, NewOutput, false) as NewOutput;
            outputwin.init(this, main.outputGrid.selectedItem as ProbeOutput, true);
            PopUpManager.centerPopUp(outputwin);
        }

        public function editOutputHandler():void
        {
            if (outputwin != null)
            {
                Alert.show("Already creating an output");
                return;
            }
            outputwin=PopUpManager.createPopUp(main.mainbox, NewOutput, false) as NewOutput;
            outputwin.init(this, main.outputGrid.selectedItem as ProbeOutput, false);
            PopUpManager.centerPopUp(outputwin);
        }

        public function deleteOutput():void
        {
            // dispatch event to delete the Output on the server
            var ev:SimpleCommandEvent;
            ev=new SimpleCommandEvent(SimpleCommandEvent.REMOVE_OUTPUT_EVENT);
            ev.name=outputwin.outputId.text;
            dispatcher.dispatchEvent(ev);

            // close the popup window
            closeOutputWindow();

            // return to initial state
            main.currentState="";
        }

        public function modifyOutput():void
        {
            // Build a new value object with the values set in the form.
            var oldo:ProbeOutput=main.outputGrid.selectedItem;
            var newo:ProbeOutput=new ProbeOutput();
            newo.name=oldo.name; // don't change
            if (outputwin.destType.text == "console")
            {
                newo.dest=ProbeOutput.OUTPUT_CONSOLE;
            }
            else if (outputwin.destType.text == "jasmine")
            {
                newo.dest=ProbeOutput.OUTPUT_JASMINE;
                //newo.host=outputwin.host.text;
                //newo.port=outputwin.port.text;
            }
            else if (outputwin.destType.text == "logfile")
            {
                newo.dest=ProbeOutput.OUTPUT_LOGFILE;
                newo.path=outputwin.path.text;
            }

            // dispatch event to apply the changes on the server
            var ev:OutputCommandEvent;
            ev=new OutputCommandEvent(OutputCommandEvent.MODIFY_OUTPUT_EVENT);
            ev.probeoutput=newo;
            dispatcher.dispatchEvent(ev);

            // close the popup window
            closeOutputWindow();

            // exit from state editprobe
            main.currentState="";
        }

        public function addOutput():void
        {
            // Build a new value object with the values set in the form.
            var newo:ProbeOutput=new ProbeOutput();
            newo.name=outputwin.outputId.text;
            if (outputwin.destType.text == "console")
            {
                newo.dest=ProbeOutput.OUTPUT_CONSOLE;
            }
            else if (outputwin.destType.text == "jasmine")
            {
                newo.dest=ProbeOutput.OUTPUT_JASMINE;
                //newo.host=outputwin.host.text;
                //newo.port=outputwin.port.text;
            }
            else if (outputwin.destType.text == "logfile")
            {
                newo.dest=ProbeOutput.OUTPUT_LOGFILE;
                newo.path=outputwin.path.text;
            }

            // dispatch event to create the Output on the server
            var ev:OutputCommandEvent;
            ev=new OutputCommandEvent(OutputCommandEvent.NEW_OUTPUT_EVENT);
            ev.probeoutput=newo;
            dispatcher.dispatchEvent(ev);

            // close the popup window
            closeOutputWindow();

            // return to initial state
            main.currentState="";
        }

        public function closeOutputWindow():void
        {
            PopUpManager.removePopUp(outputwin);
            outputwin=null;
        }

        // -------------------------------------------------------------------------
        // Create a Target
        // -------------------------------------------------------------------------

        protected var targetwin:NewTarget;

        public function createTarget(e:Event):void
        {
            if (targetwin != null)
            {
                Alert.show("Already creating an target");
                return;
            }
            targetwin=PopUpManager.createPopUp(main.mainbox, NewTarget, false) as NewTarget;
            targetwin.init(this, main.targetGrid.selectedItem as ProbeTarget, true);
            PopUpManager.centerPopUp(targetwin);
        }

        public function editTargetHandler():void
        {
            if (targetwin != null)
            {
                Alert.show("Already creating a target");
                return;
            }
            targetwin=PopUpManager.createPopUp(main.mainbox, NewTarget, false) as NewTarget;
            targetwin.init(this, main.targetGrid.selectedItem as ProbeTarget, false);
            PopUpManager.centerPopUp(targetwin);
        }

        public function deleteTarget():void
        {
            // dispatch event to delete the Target on the server
            var ev:SimpleCommandEvent;
            ev=new SimpleCommandEvent(SimpleCommandEvent.REMOVE_TARGET_EVENT);
            ev.name=targetwin.targetId.text;
            dispatcher.dispatchEvent(ev);

            // close the popup window
            closeTargetWindow();

            // return to initial state
            main.currentState="";
        }

        public function modifyTarget():void
        {
            // Build a new value object with the values set in the form.
            var oldt:ProbeTarget=main.targetGrid.selectedItem;
            var newt:ProbeTarget=new ProbeTarget();
            newt.name=oldt.name; // don't change
            newt.url=targetwin.url.text;
            newt.user=targetwin.user.text;
            newt.password=targetwin.password.text;

            // dispatch event to apply the changes on the server
            var ev:TargetCommandEvent;
            ev=new TargetCommandEvent(TargetCommandEvent.MODIFY_TARGET_EVENT);
            ev.probetarget=newt;
            dispatcher.dispatchEvent(ev);

            // close the popup window
            closeTargetWindow();

            // exit from state editprobe
            main.currentState="";
        }

        public function addTarget():void
        {
            // Build a new value object with the values set in the form.
            var newt:ProbeTarget=new ProbeTarget();
            newt.name=targetwin.targetId.text;
            newt.url=targetwin.url.text;
            newt.user=targetwin.user.text;
            newt.password=targetwin.password.text;

            // dispatch event to create the Target on the server
            var ev:TargetCommandEvent;
            ev=new TargetCommandEvent(TargetCommandEvent.NEW_TARGET_EVENT);
            ev.probetarget=newt;
            dispatcher.dispatchEvent(ev);

            // close the popup window
            closeTargetWindow();

            // return to initial state
            main.currentState="";
        }

        public function closeTargetWindow():void
        {
            PopUpManager.removePopUp(targetwin);
            targetwin=null;
        }

        public function saveconfig():void
        {
            var ev:SimpleCommandEvent;
            ev=new SimpleCommandEvent(SimpleCommandEvent.SAVE_CONFIG_EVENT);
            dispatcher.dispatchEvent(ev);
        }

        public function getMBeanList():void
        {
            var ev:MBeanCommandEvent;
            ev=new MBeanCommandEvent(MBeanCommandEvent.GET_MBEANS_EVENT);
            var probe:Probe=main.probeGrid.selectedItem;
            ev.filter=probe.filter;
            ev.probetarget=main.targetGrid.selectedItem;
            dispatcher.dispatchEvent(ev);
        }

        public function uploadconf():void
        {
            var loadWindows:LoadWindow=PopUpManager.createPopUp(main.mainbox, LoadWindow, true) as LoadWindow;
            var xmlTypes:FileFilter=new FileFilter("XML files", "*.xml");
            loadWindows.fileFilter=new Array(xmlTypes);
            loadWindows.addEventListener(LoadEvent.LOADED, loadEnd);
            PopUpManager.centerPopUp(loadWindows);
        }

        private function loadEnd(event:LoadEvent):void
        {
            var ev:SimpleCommandEvent;
            ev=new SimpleCommandEvent(SimpleCommandEvent.LOAD_CONF_EVENT);
            ev.name=event.filename;
            CairngormEventDispatcher.getInstance().dispatchEvent(ev);
            refresh();
        }

    }
}
