/**
 * JASMINe
 * Copyright (C) 2010-2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.probemanager.control {
import com.adobe.cairngorm.control.CairngormEventDispatcher;
import com.adobe.cairngorm.control.FrontController;

import org.ow2.jasmine.monitoring.eos.probemanager.command.*;
import org.ow2.jasmine.monitoring.eos.probemanager.event.*;

public class Controller extends FrontController {

    public function Controller(dispatcher: CairngormEventDispatcher) {
        super(dispatcher);
    }


    public function initialiseCommands():void {

        addCommand(ProbeCommandEvent.NEW_PROBE_EVENT, NewProbeCommand);
        addCommand(ProbeCommandEvent.COPY_PROBE_EVENT, CopyProbeCommand);
        addCommand(ProbeCommandEvent.MODIFY_PROBE_EVENT, ModifyProbeCommand);
        addCommand(ProbeCommandEvent.CHANGE_PERIOD_EVENT, ChangeProbePeriodCommand);

        addCommand(OutputCommandEvent.NEW_OUTPUT_EVENT, NewOutputCommand);
        addCommand(OutputCommandEvent.MODIFY_OUTPUT_EVENT, ModifyOutputCommand);

        addCommand(IndicatorCommandEvent.NEW_INDICATOR_EVENT, NewIndicatorCommand);
        addCommand(IndicatorCommandEvent.MODIFY_INDICATOR_EVENT, ModifyIndicatorCommand);

        addCommand(TargetCommandEvent.NEW_TARGET_EVENT, NewTargetCommand);
        addCommand(TargetCommandEvent.MODIFY_TARGET_EVENT, ModifyTargetCommand);

        addCommand(MBeanCommandEvent.GET_MBEANS_EVENT, GetMBeansCommand);

        addCommand(SimpleCommandEvent.GET_PROBES_EVENT, GetProbesCommand);
        addCommand(SimpleCommandEvent.GET_TARGETS_EVENT, GetTargetsCommand);
        addCommand(SimpleCommandEvent.GET_OUTPUTS_EVENT, GetOutputsCommand);
        addCommand(SimpleCommandEvent.GET_OUTPUT_TYPES_EVENT, GetOutputTypesCommand);
        addCommand(SimpleCommandEvent.GET_OUTPUT_PROPERTY_INFOS_EVENT, GetOutputPropertyInfosCommand);
        addCommand(SimpleCommandEvent.GET_INDICATORS_EVENT, GetIndicatorsCommand);
        addCommand(SimpleCommandEvent.GET_INDICATOR_TYPES_EVENT, GetIndicatorTypesCommand);
        addCommand(SimpleCommandEvent.GET_TARGET_TYPES_EVENT, GetTargetTypesCommand);
        addCommand(SimpleCommandEvent.GET_TARGET_PROPERTY_INFOS_EVENT, GetTargetPropertyInfosCommand);
        addCommand(SimpleCommandEvent.REMOVE_PROBE_EVENT, RemoveProbeCommand);
        addCommand(SimpleCommandEvent.START_PROBE_EVENT, StartProbeCommand);
        addCommand(SimpleCommandEvent.STOP_PROBE_EVENT, StopProbeCommand)
        addCommand(SimpleCommandEvent.REMOVE_TARGET_EVENT, RemoveTargetCommand);
        addCommand(SimpleCommandEvent.REMOVE_OUTPUT_EVENT, RemoveOutputCommand);
        addCommand(SimpleCommandEvent.REMOVE_INDICATOR_EVENT, RemoveIndicatorCommand);
        addCommand(SimpleCommandEvent.SAVE_CONFIG_EVENT, SaveConfigCommand);
        addCommand(SimpleCommandEvent.START_LISTEN_EVENT, StartListenCommand);
        addCommand(SimpleCommandEvent.STOP_LISTEN_EVENT, StopListenCommand);
        addCommand(SimpleCommandEvent.LOAD_CONF_EVENT, LoadConfCommand);
    }
                                
    public function removeCommands():void {
        removeCommand(ProbeCommandEvent.NEW_PROBE_EVENT);
        removeCommand(ProbeCommandEvent.COPY_PROBE_EVENT);
        removeCommand(ProbeCommandEvent.MODIFY_PROBE_EVENT);

        removeCommand(OutputCommandEvent.NEW_OUTPUT_EVENT);
        removeCommand(OutputCommandEvent.MODIFY_OUTPUT_EVENT);

        removeCommand(IndicatorCommandEvent.NEW_INDICATOR_EVENT);
        removeCommand(IndicatorCommandEvent.MODIFY_INDICATOR_EVENT);

        removeCommand(TargetCommandEvent.NEW_TARGET_EVENT);
        removeCommand(TargetCommandEvent.MODIFY_TARGET_EVENT);

        removeCommand(MBeanCommandEvent.GET_MBEANS_EVENT);

        removeCommand(SimpleCommandEvent.GET_PROBES_EVENT);
        removeCommand(SimpleCommandEvent.GET_TARGETS_EVENT);
        removeCommand(SimpleCommandEvent.GET_OUTPUTS_EVENT);
        removeCommand(SimpleCommandEvent.GET_INDICATORS_EVENT);
        removeCommand(SimpleCommandEvent.REMOVE_PROBE_EVENT);
        removeCommand(SimpleCommandEvent.START_PROBE_EVENT);
        removeCommand(SimpleCommandEvent.STOP_PROBE_EVENT)
        removeCommand(SimpleCommandEvent.REMOVE_TARGET_EVENT);
        removeCommand(SimpleCommandEvent.REMOVE_OUTPUT_EVENT);
        removeCommand(SimpleCommandEvent.REMOVE_INDICATOR_EVENT);
        removeCommand(SimpleCommandEvent.SAVE_CONFIG_EVENT);
        removeCommand(SimpleCommandEvent.START_LISTEN_EVENT);
        removeCommand(SimpleCommandEvent.STOP_LISTEN_EVENT);
        removeCommand(SimpleCommandEvent.LOAD_CONF_EVENT);
  }
}

}
