/**
 * JASMINe
 * Copyright (C) 2010-2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.probemanager.view {
import com.adobe.cairngorm.control.CairngormEventDispatcher;

import flash.events.MouseEvent;

import mx.collections.ArrayCollection;
import mx.containers.Canvas;

import mx.controls.Button;
import mx.controls.DataGrid;
import mx.controls.Label;
import mx.controls.NumericStepper;
import mx.core.UIComponent;
import mx.events.ListEvent;
import mx.resources.ResourceManager;

import org.ow2.jasmine.monitoring.eos.probemanager.event.ProbeCommandEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.event.SimpleCommandEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.model.ProbeManagerModelLocator;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.Probe;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.ProbeIndicator;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.ProbeOutput;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.ProbeTarget;



/**
 * @author Philippe Durieux
 */
public class ProbeDetailClass extends Canvas {

    [Bindable]
    protected var model:ProbeManagerModelLocator = ProbeManager.getInstance().getModel();

    [Bindable]
    private var dispatcher:CairngormEventDispatcher = ProbeManager.getInstance().getDispatcher();

    [Bindable]
    protected var probe:Probe;


    private var initDone:Boolean = false;

    // -------------------------------------------------------------------
    // These variables are defined in the mxml part.
    // -------------------------------------------------------------------

    [Bindable]
    public var topLevelBox:CommonPanel;

    [Bindable]
    public var indicatorGrid:DataGrid;

    [Bindable]
    public var outputGrid:DataGrid;

    [Bindable]
    public var targetGrid:DataGrid;

    [Bindable]
    public var resultGrid:DataGrid;

    [Bindable]
    public var pstatus:Label;

    [Bindable]
    public var startButton:Button;

    [Bindable]
    public var stopButton:Button;

    [Bindable]
    public var npperiod:NumericStepper;

    // -------------------------------------------------------------------
    // Module init
    // -------------------------------------------------------------------

    public function ProbeDetailClass() {
    }

    public function initView():void {
        if (! initDone && this.probe != null) {
            // Depending on timing, init may not have been achieved.
            initComponent(this.probe);
        }
    }

    public function initComponent(p:Probe):void {
        this.probe = p;

        // Check if window initialized before processing
        if (indicatorGrid == null) {
            // window not initialized yet: cannot achieve init.
            return;
        }
        initDone = true;

        // Build the lists
        removeUnusedOutputs();
        removeUnusedTargets();
        removeUnusedIndicators();

        // Listen to probe results if jasmine output set
        if (probe.hasJasmineOutput()) {

            // start listening the results
            var ev:SimpleCommandEvent;
            ev = new SimpleCommandEvent(SimpleCommandEvent.START_LISTEN_EVENT);
            ev.name = probe.probeId;
            dispatcher.dispatchEvent(ev);
        }

        // Listen event from CommonPanel
        topLevelBox.addEventListener("editButtonClick", editMode);
    }

    /**
     * Close the Window
     */
    public function closeWindow():void {

        // Stop listening to probe results
        var ev:SimpleCommandEvent;
        ev = new SimpleCommandEvent(SimpleCommandEvent.STOP_LISTEN_EVENT);
        ev.name = probe.probeId;
        dispatcher.dispatchEvent(ev);

        ProbeManager.getInstance().mainView.removeTab(this as UIComponent);
    }

    /**
     * Period has been changed by user
     */
    public function changePeriod():void {
        probe.period = int(npperiod.value);
        var ev:ProbeCommandEvent;
        ev = new ProbeCommandEvent(ProbeCommandEvent.CHANGE_PERIOD_EVENT);
        ev.probe = probe;
        dispatcher.dispatchEvent(ev);
    }

    // -------------------------------------------------------------------
    // Buttons
    // -------------------------------------------------------------------

    public function doStartButton():void {
       ProbeManager.getInstance().mainView.startProbe(probe.probeId);
    }

    public function doStopButton():void {
       ProbeManager.getInstance().mainView.stopProbe(probe.probeId);
    }

    private function editMode(e:MouseEvent):void {
       ProbeManager.getInstance().mainView.editProbe(probe.probeId);
    }

    protected function indicatorView(event:ListEvent):void {
        var iname:String = indicatorList[event.rowIndex].Name;
        ProbeManager.getInstance().mainView.editIndicator(iname);
    }

    protected function targetView(event:ListEvent):void {
        var iname:String = targetList[event.rowIndex].Name;
        ProbeManager.getInstance().mainView.editTarget(iname);
    }

    protected function outputView(event:ListEvent):void {
        var iname:String = outputList[event.rowIndex].Name;
        ProbeManager.getInstance().mainView.editOutput(iname);
    }

    // -------------------------------------------------------------------
    // State
    // -------------------------------------------------------------------

    /**
     * @param st
     */
    public function set state(st:int):void {
        if (st == Probe.FAILED) {
            currentState = "failed";
            if (startButton != null) {
               startButton.visible = true;
               stopButton.visible = false;
            }
        }
        if (st == Probe.RUNNING) {
            currentState = "running";
            if (startButton != null) {
               startButton.visible = false;
               stopButton.visible = true;
            }
        }
        if (st == Probe.STOPPED) {
            currentState = "stopped";
            if (startButton != null) {
               startButton.visible = true;
               stopButton.visible = false;
            }
        }
        if (pstatus != null && probe != null) {
            pstatus.text = probe.statusString();
        }
    }

    // -------------------------------------------------------------------
    // Target list
    // -------------------------------------------------------------------

    [Bindable]
    protected var targetList:ArrayCollection = new ArrayCollection();

    public function set targets(list:ArrayCollection):void {
        targetList = new ArrayCollection();
        for each (var target:ProbeTarget in list) {
            var obj:Object = {Name: target.name, Type: target.type, Properties: target.properties};
            targetList.addItem(obj);
        }
        if (probe != null) {
            removeUnusedTargets();
        }
    }

    private function removeUnusedTargets():void {
        if (targetList.length > 0) {
            var copyList:ArrayCollection = targetList;
            targetList = new ArrayCollection();
            for each (var obj:Object in copyList) {
                if (probe.hasTarget(obj.Name)) {
                    targetList.addItem(obj);
                }
            }
        }
    }

    // -------------------------------------------------------------------
    // Indicator List
    // -------------------------------------------------------------------

    [Bindable]
    protected var indicatorList:ArrayCollection = new ArrayCollection();

    /**
     * Update indicator list when model changes. (binding)
     * @param list
     */
    public function set indicators(list:ArrayCollection):void {
        indicatorList = new ArrayCollection();
        for each (var ind:ProbeIndicator in list) {
            var obj:Object = {Name: ind.name, Type: ind.type, Scale: ind.scale, Sources: ind.sources, Properties: ind.properties};
            indicatorList.addItem(obj);
        }
        if (probe != null) {
            removeUnusedIndicators();
        }
    }

    private function removeUnusedIndicators():void {
        if (indicatorList.length > 0) {
            var copyList:ArrayCollection = indicatorList;
            indicatorList = new ArrayCollection();
            for each (var obj:Object in copyList) {
                if (probe.hasIndicator(obj.Name)) {
                    indicatorList.addItem(obj);
                }
            }
        }
    }

    // -------------------------------------------------------------------
    // Output List
    // -------------------------------------------------------------------

    [Bindable]
    protected var outputList:ArrayCollection = new ArrayCollection();

    public function set outputs(list:ArrayCollection):void {
        outputList = new ArrayCollection();
        for each (var output:ProbeOutput in list) {
            var obj:Object = {Name: output.name, Type: output.type, Properties: output.properties};
            outputList.addItem(obj);
        }
        if (probe != null) {
            removeUnusedOutputs();
        }
    }

    private function removeUnusedOutputs():void {
        if (outputList.length > 0) {
            var copyList:ArrayCollection = outputList;
            outputList = new ArrayCollection();
            for each (var obj:Object in copyList) {
                if (probe.hasOutput(obj.Name)) {
                    outputList.addItem(obj);
                }
            }
        }
    }

    // -----------------------------------------------------------------------------
    // Internationalization
    // -----------------------------------------------------------------------------

    /**
     * Get localized String
     */
    public function locale(s:String):String {
        return ResourceManager.getInstance().getString("probemanagerResources", s);
    }



}
}
