/**
 * JASMINe
 * Copyright (C) 2010-2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.probemanager.view {
import com.adobe.cairngorm.control.CairngormEventDispatcher;

import flash.geom.Point;

import mx.collections.ArrayCollection;
import mx.collections.GroupingCollection2;
import mx.containers.Canvas;

import mx.containers.HBox;
import mx.containers.Panel;
import mx.containers.TabNavigator;
import mx.controls.AdvancedDataGrid;
import mx.controls.Alert;
import mx.controls.DataGrid;
import mx.controls.LinkButton;
import mx.controls.Menu;
import mx.core.UIComponent;
import mx.events.ListEvent;
import mx.events.MenuEvent;
import mx.managers.PopUpManager;
import mx.resources.ResourceManager;

import org.ow2.jasmine.monitoring.eos.common.events.ServerSideExceptionEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.event.NotificationEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.event.SimpleCommandEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.model.ProbeManagerModelLocator;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.Probe;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.ProbeIndicator;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.ProbeOutput;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.ProbeTarget;
import org.ow2.kerneos.common.event.KerneosNotificationEvent;

/**
 * This is the action script part of the Probe Manager
 * @author Philippe Durieux
 */
public class ProbeManagerClass extends Canvas {

    [Bindable]
    protected var model:ProbeManagerModelLocator = ProbeManager.getInstance().getModel();

    [Bindable]
    private var dispatcher:CairngormEventDispatcher = ProbeManager.getInstance().getDispatcher();

    // -------------------------------------------------------------------
    // These variables are defined in the mxml part.
    // -------------------------------------------------------------------

    [Bindable]
    public var toolBar:HBox;

    [Bindable]
    public var newButton:LinkButton;

    [Bindable]
    public var newMenuData:XML;

    [Bindable]
    public var copyMenuData:XML;

    [Bindable]
    public var probelist:Panel;

    [Bindable]
    public var probeGrid:DataGrid;

    [Bindable]
    public var indicatorGrid:AdvancedDataGrid;

    [Bindable]
    public var outputGrid:AdvancedDataGrid;

    [Bindable]
    public var targetGrid:AdvancedDataGrid;

    [Bindable]
    public var tabNavigator:TabNavigator;

    [Bindable]
    public var outputGC:GroupingCollection2;

    [Bindable]
    public var indicatorGC:GroupingCollection2;

    // -------------------------------------------------------------------
    // Constructors
    // -------------------------------------------------------------------

    public function ProbeManagerClass() {
    }

    public function initComponent():void {

        // Listen to server side events
        dispatcher.addEventListener(ServerSideExceptionEvent.SERVER_SIDE_EXCEPTION, ServerSideExceptionEvent.show);

        dispatcher.addEventListener(NotificationEvent.NOTIFICATION, dispatchNotification);
        model.subscribeJasmineProbeTopic();

        // Get the ouput types
        var ev:SimpleCommandEvent;
        ev = new SimpleCommandEvent(SimpleCommandEvent.GET_OUTPUT_TYPES_EVENT);
        dispatcher.dispatchEvent(ev);

        // Get the indicator types
        ev = new SimpleCommandEvent(SimpleCommandEvent.GET_INDICATOR_TYPES_EVENT);
        dispatcher.dispatchEvent(ev);

        // Get the target types
        ev = new SimpleCommandEvent(SimpleCommandEvent.GET_TARGET_TYPES_EVENT);
        dispatcher.dispatchEvent(ev);

        refresh();
        debug("ProbeManager initialized");
    }

    public function initServices():void {
        debug("ProbeManager service initialized");
    }

    public function destroy():void {
        debug("ProbeManager removed");
        model.unsubscribeJasmineProbeTopic();

        // Remove listeners
        dispatcher.removeEventListener(ServerSideExceptionEvent.SERVER_SIDE_EXCEPTION, ServerSideExceptionEvent.show);
        dispatcher.removeEventListener(NotificationEvent.NOTIFICATION, dispatchNotification);
    }

    /**
     * Server side Event:
     * Dispatch a Notification to Kerneos
     * @param event
     */
    protected function dispatchNotification(event:NotificationEvent):void {
        event.stopImmediatePropagation();
        event.preventDefault();
        dispatchEvent(new KerneosNotificationEvent(KerneosNotificationEvent.KERNEOS_NOTIFICATION, event.notification, KerneosNotificationEvent.INFO));
   }

    public function refresh():void {
                                    
        debug("refresh data from server")
        var ev:SimpleCommandEvent;

        ev = new SimpleCommandEvent(SimpleCommandEvent.GET_OUTPUTS_EVENT);
        dispatcher.dispatchEvent(ev);

        ev = new SimpleCommandEvent(SimpleCommandEvent.GET_INDICATORS_EVENT);
        dispatcher.dispatchEvent(ev);

        ev = new SimpleCommandEvent(SimpleCommandEvent.GET_TARGETS_EVENT);
        dispatcher.dispatchEvent(ev);

        ev = new SimpleCommandEvent(SimpleCommandEvent.GET_PROBES_EVENT);
        dispatcher.dispatchEvent(ev);
    }

    public function showHelp():void {
        var helpWindow:ProbeManagerHelp = PopUpManager.createPopUp(tabNavigator, ProbeManagerHelp, true) as ProbeManagerHelp;
        PopUpManager.centerPopUp(helpWindow);
        // TODO use the TabNavigator, but must adapt the HelpWindow class
        //var helpWindow:ProbeManagerHelp = new ProbeManagerHelp();
        //addTab(helpWindow);
    }

    /**
     * BUTTON: Save current config
     */
    public function saveconfig():void {
        var ev:SimpleCommandEvent;
        ev = new SimpleCommandEvent(SimpleCommandEvent.SAVE_CONFIG_EVENT);
        dispatcher.dispatchEvent(ev);
        debug("Configuration has been saved")
    }

    /**
     * BUTTON: Upload a local config file.
     */
    public function uploadconf():void {   
        debug("upload config file (not implemented)")
        // TODO
    }

    private var point1:Point = new Point();
    private var newMenu:Menu;

    /*
     * Create and display the New menu control.
     */
    public function showNewMenu():void {
        newMenu = Menu.createMenu(toolBar, newMenuData, false);
        newMenu.labelField = "@label"
        newMenu.addEventListener("itemClick", newMenuHandler);

        // Calculate position of Menu in Application's coordinates.
        point1.x = newButton.x;
        point1.y = newButton.y;

        newMenu.show(point1.x + 5, point1.y + newButton.height + 25);
    }

    /*
     * Create and display the Copy menu control.
     */
    public function showCopyMenu():void {
        newMenu = Menu.createMenu(toolBar, copyMenuData, false);
        newMenu.labelField = "@label"
        newMenu.addEventListener("itemClick", copyMenuHandler);

        // Calculate position of Menu in Application's coordinates.
        point1.x = newButton.x;
        point1.y = newButton.y;

        newMenu.show(point1.x + 5, point1.y + newButton.height + 25);
    }

    /*
     * Event handler for the New menu control's change event.
     */
    private function newMenuHandler(event:MenuEvent):void {

        if (event.item.@eventName == "newProbe") {
            this.createProbe();
        } else if (event.item.@eventName == "newTarget") {
            this.createTarget();
        } else if (event.item.@eventName == "newOutput") {
            this.createOutput();
        } else if (event.item.@eventName == "newIndicator") {
            this.createIndicator();
        } else if (event.item.@eventName == "probeWizard") {
            this.probeWizard();
        }
    }
    /*
     * Event handler for the Copy menu control's change event.
     */
    private function copyMenuHandler(event:MenuEvent):void {

        if (event.item.@eventName == "newProbe") {
            this.copyProbes();
        } else if (event.item.@eventName == "newTarget") {
            this.copyTargets();
        } else if (event.item.@eventName == "newOutput") {
            this.copyOutputs();
        } else if (event.item.@eventName == "newIndicator") {
            this.copyIndicators();
        }
    }

    /**
     * add a view to tabNavigator
     */
    public function addTab(view:UIComponent):void {
        tabNavigator.addChild(view);
        tabNavigator.selectedIndex = tabNavigator.numChildren - 1;
    }
    /**
     * remove a view from tabNavigator
     */
    public function removeTab(view:UIComponent):void {
        tabNavigator.removeChild(view);
    }

    // -------------------------------------------------------------------
    // Indicator List
    // -------------------------------------------------------------------

    [Bindable]
    protected var indicatorList:ArrayCollection;

    public function set indicators(list:ArrayCollection):void {
        indicatorList = new ArrayCollection();
        for each (var ind:ProbeIndicator in list) {
            var obj:Object = {Name: ind.name, Type: ind.type, Scale: ind.scale, Sources: ind.sources, Properties: ind.properties};
            indicatorList.addItem(obj);
        }
        indicatorGC.refresh();
    }


    // -------------------------------------------------------------------
    // Output List
    // -------------------------------------------------------------------

    [Bindable]
    protected var outputList:ArrayCollection;

    public function set outputs(list:ArrayCollection):void {
        outputList = new ArrayCollection();
        for each (var output:ProbeOutput in list) {
            var obj:Object = {Name: output.name, Type: output.type, Properties: output.properties};
            outputList.addItem(obj);
        }
        outputGC.refresh();
    }

    // -------------------------------------------------------------------
    // Actions
    // -------------------------------------------------------------------

    /**
     * Display indicator in another Tab
     * @param event
     */
    protected function indicatorView(event:ListEvent):void {
        var iname:String = indicatorList[event.rowIndex].Name;
        editIndicator(iname);
    }

    /**
     * Display output in another Tab
     * @param event
     */
    protected function outputView(event:ListEvent):void {
        var iname:String = outputList[event.rowIndex].Name;
        editOutput(iname);
    }

    /**
     * Display probe in another Tab
     * @param event
     */
    protected function probeView(event:ListEvent):void {
        var iname:String = model.probes[event.rowIndex].probeId;
        viewProbe(iname);
    }

    /**
     * Display target in another Tab
     * @param event
     */
    protected function targetView(event:ListEvent):void {
        var iname:String = model.targets[event.rowIndex].name;
        editTarget(iname);
    }

    /**
     * Create a new Probe from scratch
     */
    public function createProbe():void {
        // Create the ProbeEditView
        var view:ProbeEditView = new ProbeEditView();
        view.label = "New Probe";
        view.initComponent("new", new Probe());
        addTab(view);
        debug("creating probe")
    }

    /**
     * Create a new Probe from a template
     */
    public function probeWizard():void {
        var wizard:ProbeWizard = PopUpManager.createPopUp(tabNavigator, ProbeWizard, true) as ProbeWizard;
        PopUpManager.centerPopUp(wizard);
    }

    public function createTarget():void {
        // Create the TargetEditView
        var view:TargetEditView = new TargetEditView();
        view.label = "New Target";
        view.initComponent("new", new ProbeTarget());
        addTab(view);
        debug("creating target")
    }

    public function createOutput():void {
        // Create the OutputEditView
        var view:OutputEditView = new OutputEditView();
        view.label = "New Output";
        view.initComponent("new", new ProbeOutput());
        addTab(view);
        debug("creating output")
    }

    public function createIndicator():void {
        // Create the IndicatorEditView
        var view:IndicatorEditView = new IndicatorEditView();
        view.label = "New Indicator";
        view.initComponent("new", new ProbeIndicator());
        addTab(view);
        debug("creating indicator")
    }

    public function copyProbes():void {
        for (var i:int = 0; i < probeGrid.selectedItems.length; i++) {
            copyProbe((probeGrid.selectedItems[i] as Probe).probeId);
        }
    }

    public function copyTargets():void {
        for (var i:int = 0; i < targetGrid.selectedItems.length; i++) {
            copyTarget((targetGrid.selectedItems[i] as ProbeTarget).name);
        }
    }

    public function copyOutputs():void {
        for (var i:int = 0; i < outputGrid.selectedItems.length; i++) {
            copyOutput(outputGrid.selectedItems[i].Name);
        }
    }

    public function copyIndicators():void {
        for (var i:int = 0; i < indicatorGrid.selectedItems.length; i++) {
            copyIndicator(indicatorGrid.selectedItems[i].Name);
        }
    }

    public function copyProbe(name:String):void {
        // Create the ProbeEditView
        var view:ProbeEditView = new ProbeEditView();
        view.label = "copy of " + name;
        view.initComponent("copy", model.getProbe(name));
        addTab(view);
    }

    public function copyTarget(name:String):void {
        // Create the TargetEditView
        var view:TargetEditView = new TargetEditView();
        view.label = "copy of " + name;
        view.initComponent("copy", model.getTarget(name));
        addTab(view);
    }

    public function copyOutput(name:String):void {
        // Create the OutputEditView
        var view:OutputEditView = new OutputEditView();
        view.label = "copy of " + name;
        view.initComponent("copy", model.getOutput(name));
        addTab(view);
    }

    public function copyIndicator(name:String):void {
        // Create the IndicatorEditView
        var view:IndicatorEditView = new IndicatorEditView();
        view.label = "copy of " + name;
        view.initComponent("copy", model.getIndicator(name));
        addTab(view);
    }

    public function editProbe(name:String):void {
        // Create the ProbeEditView
        var view:ProbeEditView = new ProbeEditView();
        view.label = "P: " + name;
        view.initComponent("change", model.getProbe(name));
        addTab(view);
    }

    public function editTarget(name:String):void {
        // Create the TargetEditView
        var view:TargetEditView = new TargetEditView();
        view.label = "T: " + name;
        view.initComponent("change", model.getTarget(name));
        addTab(view);
    }

    public function editOutput(name:String):void {
        // Create the OutputEditView
        var view:OutputEditView = new OutputEditView();
        view.label = "O: " + name;
        var output:ProbeOutput = model.getOutput(name);
        view.initComponent("change", output);
        addTab(view);
    }

    public function editIndicator(name:String):void {
        // Create the IndicatorEditView
        var view:IndicatorEditView = new IndicatorEditView();
        view.label = "I: " + name;
        var indicator:ProbeIndicator = model.getIndicator(name);
        view.initComponent("change", indicator);
        addTab(view);
    }

    public function doStartButton():void {
        for (var i:int = 0; i < probeGrid.selectedItems.length; i++) {
            startProbe((probeGrid.selectedItems[i] as Probe).probeId);
        }
    }

    public function doStopButton():void {
        for (var i:int = 0; i < probeGrid.selectedItems.length; i++) {
            stopProbe((probeGrid.selectedItems[i] as Probe).probeId);
        }
    }

    public function startProbe(probeId:String):void {
        var ev:SimpleCommandEvent;
        ev = new SimpleCommandEvent(SimpleCommandEvent.START_PROBE_EVENT);
        ev.name = probeId;
        dispatcher.dispatchEvent(ev);
    }

    public function stopProbe(probeId:String):void {
        var ev:SimpleCommandEvent;
        ev = new SimpleCommandEvent(SimpleCommandEvent.STOP_PROBE_EVENT);
        ev.name = probeId;
        dispatcher.dispatchEvent(ev);
    }

    public function viewProbe(name:String):void {
        // Create the ProbeDetailView
        var view:ProbeDetailView = new ProbeDetailView();
        view.label = "P: " + name;
        view.initComponent(model.getProbe(name));
        addTab(view);
    }

    // -----------------------------------------------------------------------------
    // Internationalization
    // -----------------------------------------------------------------------------

    /**
     * Get localized String
     */
    public function locale(s:String):String {
        return ResourceManager.getInstance().getString("probemanagerResources", s);
    }

    public function debug(message:String):void {
        dispatchEvent(new KerneosNotificationEvent(KerneosNotificationEvent.KERNEOS_NOTIFICATION,
                message, KerneosNotificationEvent.DEBUG));
    }



}
}
