/**
 * JASMINe
 * Copyright (C) 2010-2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.probemanager.view {
import com.adobe.cairngorm.control.CairngormEventDispatcher;

import flash.events.MouseEvent;

import mx.collections.ArrayCollection;
import mx.containers.Canvas;
import mx.containers.Form;
import mx.containers.FormHeading;

import mx.containers.FormItem;
import mx.containers.HBox;
import mx.controls.Alert;
import mx.controls.ComboBox;
import mx.controls.TextInput;
import mx.events.CloseEvent;
import mx.resources.ResourceManager;

import org.ow2.jasmine.monitoring.eos.probemanager.event.OutputCommandEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.event.SimpleCommandEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.model.ProbeManagerModelLocator;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.ProbeOutput;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.PropertyInfo;



/**
 * @author Philippe Durieux
 */
public class OutputEditClass extends Canvas {

    [Bindable]
    protected var model:ProbeManagerModelLocator = ProbeManager.getInstance().getModel();

    [Bindable]
    private var dispatcher:CairngormEventDispatcher = ProbeManager.getInstance().getDispatcher();

    [Bindable]
    protected var output:ProbeOutput = null;

    /**
     * ope may be one of "new","change","copy"
     */
    [Bindable]
    protected var ope:String = null;

    [Bindable]
    private var propertyFormItems:ArrayCollection = new ArrayCollection();

    private var initDone:Boolean = false;

    // -------------------------------------------------------------------
    // These variables are defined in the mxml part.
    // -------------------------------------------------------------------

    [Bindable]
    public var topLevelBox:CommonPanel;

    [Bindable]
    public var outputType:ComboBox;

    [Bindable]
    public var outputId:TextInput;

    [Bindable]
    public var propertyBox:Form;

    [Bindable]
    public var buttonBox:HBox;

    // -------------------------------------------------------------------
    // Module init
    // -------------------------------------------------------------------

    public function OutputEditClass() {
    }

    public function initView():void {
        if (! initDone && this.ope != null) {
            // Depending on timing, init may not have been achieved.
            initComponent(this.ope, this.output);
        }
    }

    public function initComponent(oper:String, po:ProbeOutput):void {
        this.output = po;
        this.ope = oper;

        // Check if window initialized before processing
        if (outputId == null || outputType == null) {
            // window not initialized yet: cannot achieve init.
            return;
        }
        initDone = true;

        if (this.ope == "change") {
            // Name must not be changed
            outputId.editable = false;
        } else {
            // new or copy: must choose a name
            this.output.name = "";
            // enable apply button
            buttonBox.enabled = true;
        }

        if (this.ope != "new") {
            // pre select combo box with current type
            // This doesn't work: outputType.selectedItem = this.output.type;
            var ind:int = 0;
            for each (var val:String in model.outputTypes) {
                if (val == this.output.type) {
                    outputType.selectedIndex = ind;
                    break;
                }
                ind++;
            }
            typeChosen();
        }

        // Listen event from CommonPanel
        topLevelBox.addEventListener("editButtonClick", editMode);
    }

    private function editMode(e:MouseEvent):void {
        buttonBox.enabled = true;
    }

    protected function typeChosen():void {
      // Check that a type has been actually chosen
      if (outputType.selectedIndex < 0) {
        return;
      }
      // Get the properties info for this ouput type
      var ev:SimpleCommandEvent;
      ev = new SimpleCommandEvent(SimpleCommandEvent.GET_OUTPUT_PROPERTY_INFOS_EVENT);
      ev.name = outputType.text;
      dispatcher.dispatchEvent(ev);
      // this will trigger "set properties()"
    }

    /**
     * Initialize the list of properties for the type selected.
     * and build the list of form items to get their values
     * @param props
     */
    public function set properties(props:ArrayCollection):void {
        propertyBox.removeAllChildren();
        var fh:FormHeading = new FormHeading();
        fh.label = "List of properties";
        propertyBox.addChild(fh);
        propertyFormItems = new ArrayCollection();
        for each (var prop:PropertyInfo in props) {
            // Add a Property Form Item
            var fi:FormItem = new FormItem();
            fi.label = prop.name;
            fi.required = prop.required;
            var ti:TextInput = new TextInput();
            ti.width = 600;
            ti.toolTip = prop.description;
            ti.text = getPropertyValue(prop.name);
            fi.addChild(ti);
            propertyFormItems.addItem(fi);
            propertyBox.addChild(fi);
        }
    }

    private function getPropertyValue(pname:String):String {
        var ret:String = "";
        if (this.output.properties != null) {
            var prop:String;
            for each (prop in this.output.properties) {
                var index:int = prop.indexOf("=");
                var name:String = prop.substring(0, index);
                if (name == pname) {
                    ret = prop.substring(index + 1);
                    break;
                }
            }
        }
        return ret;
    }

    // -------------------------------------------------------------------
    // Actions
    // -------------------------------------------------------------------

    public function remove():void {
        Alert.show("Do you really want to remove this output ?",
                "Remove Output",
                Alert.YES | Alert.NO,
                topLevelBox, removeSelectedOutput, null, Alert.YES);

    }

    private function removeSelectedOutput(event:CloseEvent):void {
        if (event.detail == Alert.YES) {
            removeOutput(output.name);
            // close the tab
            topLevelBox.closeWindow(null);
        }
    }

    private function removeOutput(id:String):void {
        var ev:SimpleCommandEvent;
        ev = new SimpleCommandEvent(SimpleCommandEvent.REMOVE_OUTPUT_EVENT);
        ev.name = id;
        dispatcher.dispatchEvent(ev);
    }

    /**
     * Called when user clic on "Apply"
     */
    public function apply():void {
        // update Output with values from the form
        updateOutput();

        // Apply the operation
        var ev:OutputCommandEvent;
        if (ope == "new" || ope == "copy") {
            ev = new OutputCommandEvent(OutputCommandEvent.NEW_OUTPUT_EVENT);
            ev.probeoutput = output;
            dispatcher.dispatchEvent(ev);

        }
        if (ope == "change") {
            ev = new OutputCommandEvent(OutputCommandEvent.MODIFY_OUTPUT_EVENT);
            ev.probeoutput = output;
            dispatcher.dispatchEvent(ev);
        }

        // close the tab
        topLevelBox.closeWindow(null);
    }

    /**
     * Update object with values typed in the form.
     */
    public function updateOutput():void {
        output.name = outputId.text;
        output.type = outputType.text;

        // properties
        var props:ArrayCollection = new ArrayCollection();
        for each (var fi:FormItem in propertyFormItems) {
            var t:TextInput = fi.getChildAt(0) as TextInput;
            var p:String = fi.label + "=" + t.text;
            props.addItem(p);
        }
        output.properties = props;
    }

    // -----------------------------------------------------------------------------
    // Internationalization
    // -----------------------------------------------------------------------------

    /**
     * Get localized String
     */
    public function locale(s:String):String {
        return ResourceManager.getInstance().getString("probemanagerResources", s);
    }



}
}
