/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.probemanager.view {
import mx.core.UIComponent;

import org.ow2.jasmine.monitoring.eos.probemanager.event.CommonPanelEvent;

import flash.events.MouseEvent;

import mx.containers.Panel;
import mx.controls.LinkButton;

[Event(name="editButtonClick", type="flash.events.MouseEvent")]

public class CommonPanel extends Panel {

    private var editButton:LinkButton = new LinkButton();
    private var closeButton:LinkButton = new LinkButton();
    private var helpButton:LinkButton = new LinkButton();

    private const buttonWidth:int = 36;
    private const buttonHeight:int = 22;

    [Embed(source='/../assets/cancel18.png')]
    [Bindable]
    public var cancelIcon:Class;

    [Embed(source='/../assets/edit18.png')]
    [Bindable]
    public var editIcon:Class;

    [Embed(source='/../assets/help18.png')]
    [Bindable]
    public var helpIcon:Class;

    public function CommonPanel() {
        super();
    }

    // this method is called during the initialize phase
    // and is used to create the interface
    override protected function createChildren():void {

        super.createChildren();

        editButton.height = buttonHeight;
        editButton.toolTip = "Edit this object";
        editButton.setStyle("labelPlacement", "bottom");
        editButton.setStyle("icon", editIcon);
        editButton.addEventListener(MouseEvent.CLICK, editClick);
        titleBar.addChild(editButton);

        closeButton.height = buttonHeight;
        closeButton.toolTip = "close this window";
        closeButton.setStyle("labelPlacement", "bottom");
        closeButton.setStyle("icon", cancelIcon);
        closeButton.addEventListener(MouseEvent.CLICK, closeWindow);
        titleBar.addChild(closeButton);

        helpButton.height = buttonHeight;
        helpButton.toolTip = "display the help";
        helpButton.setStyle("labelPlacement", "bottom");
        helpButton.setStyle("icon", helpIcon);
        helpButton.addEventListener(MouseEvent.CLICK, helpClick);
        titleBar.addChild(helpButton);


    }

    // this method is used every time there is a change in the DisplayList
    // to move and reorganize the interface
    override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number):void {

        super.updateDisplayList(unscaledWidth, unscaledHeight);

        editButton.move(this.width - 3 * buttonWidth, 4);
        helpButton.move(this.width - 2 * buttonWidth, 4);
        closeButton.move(this.width - buttonWidth, 4);
    }


    private function editClick(e:MouseEvent):void {
        var event:CommonPanelEvent = new CommonPanelEvent('editButtonClick', e);
        dispatchEvent(event);
    }

    private function helpClick(e:MouseEvent):void {
        ProbeManager.getInstance().mainView.showHelp();
    }

    public function closeWindow(e:MouseEvent):void {
        ProbeManager.getInstance().mainView.removeTab(this.parent as UIComponent);
    }
}
}
