/**
 * JASMINe
 * Copyright (C) 2010-2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.probemanager.view {
import com.adobe.cairngorm.control.CairngormEventDispatcher;

import flash.events.MouseEvent;

import mx.collections.ArrayCollection;
import mx.containers.Canvas;
import mx.containers.Form;
import mx.containers.FormHeading;

import mx.containers.FormItem;
import mx.containers.HBox;
import mx.controls.Alert;
import mx.controls.ComboBox;
import mx.controls.Label;
import mx.controls.LinkButton;
import mx.controls.TextInput;
import mx.events.CloseEvent;
import mx.resources.ResourceManager;

import mx.validators.NumberValidator;

import mx.validators.Validator;

import org.ow2.jasmine.monitoring.eos.probemanager.event.IndicatorCommandEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.event.SimpleCommandEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.model.ProbeManagerModelLocator;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.CollectorInfo;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.ProbeIndicator;
import org.ow2.jasmine.monitoring.eos.probemanager.vo.PropertyInfo;



/**
 * @author Philippe Durieux
 */
public class IndicatorEditClass extends Canvas {


    [Bindable]
    protected var model:ProbeManagerModelLocator = ProbeManager.getInstance().getModel();

    [Bindable]
    private var dispatcher:CairngormEventDispatcher = ProbeManager.getInstance().getDispatcher();

    [Bindable]
    protected var indicator:ProbeIndicator = null;

    /**
     * ope may be one of "new","change","copy"
     */
    [Bindable]
    protected var ope:String = null;

    [Bindable]
    private var propertyFormItems:ArrayCollection = new ArrayCollection();

    [Bindable]
    private var sourceCombos:ArrayCollection = new ArrayCollection();

    private var initDone:Boolean = false;

    private var validators:ArrayCollection = new ArrayCollection();

    [Embed(source='/../assets/loupe18.png')]
    [Bindable]
    public var loupe18:Class;

    // -------------------------------------------------------------------
    // These variables are defined in the mxml part.
    // -------------------------------------------------------------------

    [Bindable]
    public var topLevelBox:CommonPanel;

    [Bindable]
    public var indicatorType:ComboBox;

    [Bindable]
    public var indicatorId:TextInput;

    [Bindable]
    public var scaleValue:TextInput;

    [Bindable]
    public var propertyBox:Form;

    [Bindable]
    public var sourceBox:Form;

    [Bindable]
    public var buttonBox:HBox;

    [Bindable]
    public var shortDesc:Label;

    // -------------------------------------------------------------------
    // Module init
    // -------------------------------------------------------------------

    public function IndicatorEditClass() {
    }

    public function initView():void {
        if (! initDone && this.ope != null) {
            // Depending on timing, init may not have been achieved.
            initComponent(this.ope, this.indicator);
        }
    }

    public function initComponent(oper:String, po:ProbeIndicator):void {
        this.indicator = po;
        this.ope = oper;


        // Check if window initialized before processing
        if (indicatorId == null || indicatorType == null) {
            // window not initialized yet: cannot achieve init.
            return;
        }
        initDone = true;

        if (this.ope == "change") {
            // cannot change the name
            indicatorId.editable = false;
        } else {
            // new or copy: must choose a name
            this.indicator.name = "";
            // enable apply button
            buttonBox.enabled = true;
        }

        if (this.ope != "new") {
            // pre select combo box with current type
            // This doesn't work: indicatorType.selectedItem = this.indicator.type;
            var ind:int = 0;
            for each (var val:String in model.indicatorTypes) {
                if (val == this.indicator.type) {
                    indicatorType.selectedIndex = ind;
                    break;
                }
                ind++;
            }
            typeChosen();
        }

        // Listen event from CommonPanel
        topLevelBox.addEventListener("editButtonClick", editMode);

        // Validators
        var scaleValid:NumberValidator = new NumberValidator();
        scaleValid.source = scaleValue;
        scaleValid.property = "text";
        scaleValid.minValue = 1;
        scaleValid.lowerThanMinError="You must set a positive value"
        scaleValid.domain = "int";
        validators.addItem(scaleValid);
    }

    private function editMode(e:MouseEvent):void {
        buttonBox.enabled = true;
    }

    protected function typeChosen():void {
        // Check that a type has been actually chosen
        if (indicatorType.selectedIndex <= 0) {
            currentState = "init";
            return;
        }
        currentState = "filling";

        // type is chosen: Get the CollectorInfo from model.
        // It should have been got at init.
        // TODO may be it has changed and we should got it again ?
        var info:CollectorInfo = model.getCollectorInfo(indicatorType.text);
        shortDesc.text = info.shortDesc;

        // properties
        propertyBox.removeAllChildren();
        var fh:FormHeading = new FormHeading();
        fh.label = info.longDesc;
        propertyBox.addChild(fh);
        propertyFormItems = new ArrayCollection();
        for each (var prop:PropertyInfo in info.propertyInfos) {
            // Add a Property Form Item
            var fi:FormItem = new FormItem();
            fi.label = prop.name;
            fi.required = prop.required;
            var ti:TextInput = new TextInput();
            ti.width = 600;
            ti.toolTip = prop.description;
            ti.text = getPropertyValue(prop.name);
            fi.addChild(ti);
            propertyFormItems.addItem(fi);
            propertyBox.addChild(fi);
        }

        // sources
        sourceBox.removeAllChildren();
        fh = new FormHeading();
        fh.label = info.sourceDesc;
        sourceBox.addChild(fh);
        sourceCombos = new ArrayCollection();
        for (var nbs:int = 0; nbs < info.sourceMax; nbs++) {
            fi = new FormItem();
            fi.label = "source " + (nbs + 1);
            fi.required = nbs < info.sourceMin;
            var cb:ComboBox = new ComboBox();
            cb.dataProvider = model.indicatorNames;
            if (this.indicator.sources.length > nbs) {
                cb.selectedItem = String(this.indicator.sources.getItemAt(nbs));
            }
            fi.addChild(cb);
            sourceCombos.addItem(cb);
            var hb:HBox = new HBox();
            hb.addChild(fi);
            var lb:LinkButton = new LinkButton();
            lb.height = 25;
            lb.label = "View";
            lb.labelPlacement = "right";
            lb.toolTip = "View indicator :";
            lb.setStyle("icon", loupe18);
            lb.setStyle("textAlign", "center");
            lb.addEventListener(MouseEvent.CLICK, doViewButton);
            hb.addChild(lb);
            sourceBox.addChild(hb);
        }
    }

    public function doViewButton(ev:MouseEvent):void {
        var myLinkButton:LinkButton = ev.currentTarget as LinkButton;
        var myHBox:HBox = myLinkButton.parent as HBox;
        var myFormItem:FormItem = myHBox.getChildAt(0) as FormItem;
        var myComboBox:ComboBox = myFormItem.getChildAt(0) as ComboBox;
        ProbeManager.getInstance().mainView.editIndicator(myComboBox.text);
    }

    private function getPropertyValue(pname:String):String {
        var ret:String = "";
        if (this.indicator.properties != null) {
            var prop:String;
            for each (prop in this.indicator.properties) {
                var index:int = prop.indexOf("=");
                var name:String = prop.substring(0, index);
                if (name == pname) {
                    ret = prop.substring(index + 1);
                    break;
                }
            }
        }
        return ret;
    }

    // -------------------------------------------------------------------
    // Actions
    // -------------------------------------------------------------------

    public function remove():void {
        Alert.show("Do you really want to remove this indicator ?",
                "Remove Indicator",
                Alert.YES | Alert.NO,
                topLevelBox, removeSelectedIndicator, null, Alert.YES);

    }

    private function removeSelectedIndicator(event:CloseEvent):void {
        if (event.detail == Alert.YES) {
            removeIndicator(indicator.name);
            // close the tab
            topLevelBox.closeWindow(null);
        }
    }

    private function removeIndicator(id:String):void {
        var ev:SimpleCommandEvent;
        ev = new SimpleCommandEvent(SimpleCommandEvent.REMOVE_INDICATOR_EVENT);
        ev.name = id;
        dispatcher.dispatchEvent(ev);
    }

    /**
     * Called when user clic on "Apply"
     */
    public function apply():void {
        // validate the form
        var errors:Array = Validator.validateAll(validators.source);
        if (errors.length > 0) {
            Alert.show("Fix errors first!");
            return;
        }

        // update Indicator with values from the form
        updateIndicator();

        // Apply the operation
        var ev:IndicatorCommandEvent;
        if (ope == "new" || ope == "copy") {
            ev = new IndicatorCommandEvent(IndicatorCommandEvent.NEW_INDICATOR_EVENT);
            ev.probeindicator = indicator;
            dispatcher.dispatchEvent(ev);

        }
        if (ope == "change") {
            ev = new IndicatorCommandEvent(IndicatorCommandEvent.MODIFY_INDICATOR_EVENT);
            ev.probeindicator = indicator;
            dispatcher.dispatchEvent(ev);
        }

        // close the tab
        topLevelBox.closeWindow(null);
    }

    /**
     * Update object with values typed in the form.
     */
    public function updateIndicator():void {
        indicator.name = indicatorId.text;
        indicator.type = indicatorType.text;
        indicator.scale = int(scaleValue.text);

        // sources
        var sources:ArrayCollection = new ArrayCollection();
        for each (var cb:ComboBox in sourceCombos) {
            sources.addItem(cb.text);
        }
        indicator.sources = sources;

        // properties
        var props:ArrayCollection = new ArrayCollection();
        for each (var fi:FormItem in propertyFormItems) {
            var t:TextInput = fi.getChildAt(0) as TextInput;
            var p:String = fi.label + "=" + t.text;
            props.addItem(p);
        }
        indicator.properties = props;
    }

    // -----------------------------------------------------------------------------
    // Internationalization
    // -----------------------------------------------------------------------------

    /**
     * Get localized String
     */
    public function locale(s:String):String {
        return ResourceManager.getInstance().getString("probemanagerResources", s);
    }



}
}
