/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.probemanager.vo {
import com.adobe.cairngorm.vo.IValueObject;

import mx.collections.ArrayCollection;


[Bindable]
public class CollectorInfo implements IValueObject {
    private var _type:String;
    private var _shortDesc:String;
    private var _longDesc:String;
    private var _sourceDesc:String;
    private var _sourceMin:int;
    private var _sourceMax:int;

    [ArrayElementType(PropertyInfo)]
    private var _propertyInfos:ArrayCollection;

    public function CollectorInfo() {
    }

    public function get type():String {
        return _type;
    }

    public function set type(value:String):void {
        _type = value;
    }

    public function get shortDesc():String {
        return _shortDesc;
    }

    public function set shortDesc(value:String):void {
        _shortDesc = value;
    }

    public function get longDesc():String {
        return _longDesc;
    }

    public function set longDesc(value:String):void {
        _longDesc = value;
    }

    public function get sourceDesc():String {
        return _sourceDesc;
    }

    public function set sourceDesc(value:String):void {
        _sourceDesc = value;
    }

    public function get sourceMin():int {
        return _sourceMin;
    }

    public function set sourceMin(value:int):void {
        _sourceMin = value;
    }

    public function get sourceMax():int {
        return _sourceMax;
    }

    public function set sourceMax(value:int):void {
        _sourceMax = value;
    }

    public function get propertyInfos():ArrayCollection {
        return _propertyInfos;
    }

    public function set propertyInfos(value:ArrayCollection):void {
        _propertyInfos = value;
    }
}
}
