/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.probemanager.vo {
import com.adobe.cairngorm.vo.IValueObject;
import com.adobe.cairngorm.vo.IValueObject;

import mx.collections.ArrayCollection;
import mx.controls.Alert;

import org.ow2.jasmine.monitoring.eos.probemanager.view.ProbeDetailClass;

[Bindable]
public class Probe implements IValueObject {
    private var _probeId:String;
    private var _outputId:ArrayCollection;
    private var _indicatorId:ArrayCollection;
    private var _targetId:ArrayCollection;
    private var _period:int;
    private var _state:int;
    private var _selected:Boolean;
    private var _error:String;

    [Transient]
    public var targets:Array;
    [Transient]
    public var outputs:Array;
    [Transient]
    public var indicators:Array;
    [Transient]
    private var _results:ArrayCollection = new ArrayCollection();

    /**
     * Allowed states
     * WARNING: these values must match those in the RemoteClass
     */
    public static var STOPPED:int = 0;
    public static var STARTED:int = 1;
    public static var RUNNING:int = 2;
    public static var FAILED:int = 3;

    public function Probe() {
    }

    public function get probeId():String {
        return this._probeId;
    }

    public function set probeId(value:String):void {
        this._probeId = value;
    }

    public function get targetId():ArrayCollection {
        return this._targetId;
    }

    public function set targetId(value:ArrayCollection):void {
        this._targetId = value;
    }

    public function get outputId():ArrayCollection {
        return this._outputId;
    }

    public function set outputId(value:ArrayCollection):void {
        this._outputId = value;
    }

    public function get indicatorId():ArrayCollection {
        return this._indicatorId;
    }

    public function set indicatorId(value:ArrayCollection):void {
        this._indicatorId = value;
    }

    public function get period():int {
        return this._period;
    }

    public function set period(value:int):void {
        this._period = value;
    }

    public function get state():int {
        return this._state;
    }

    public function set state(value:int):void {
        this._state = value;
    }

    public function get selected():Boolean {
        return this._selected;
    }

    public function set selected(value:Boolean):void {
        this._selected = value;
    }

    public function get error():String {
        return this._error;
    }

    public function set error(value:String):void {
        this._error = value;
    }

    public function statusString():String {
        switch (_state) {
            case RUNNING:
                return "running";
            case STOPPED:
                return "stopped";
            case STARTED:
                return "started";
            default:
                return "failed";
        }
    }

    public function hasJasmineOutput():Boolean {
        for each (var output:ProbeOutput in outputs) {
            if (output.type == ProbeOutput.OUTPUT_JASMINE) {
                return true;
            }
        }
        return false;
    }

    public function hasOutput(n:String):Boolean {
        for each (var name:String in outputId) {
            if (name == n) {
                return true;
            }
        }
        return false;
    }

    public function hasIndicator(n:String):Boolean {
        for each (var name:String in indicatorId) {
            if (name == n) {
                return true;
            }
        }
        return false;
    }

    public function hasTarget(n:String):Boolean {
        for each (var name:String in targetId) {
            if (name == n) {
                return true;
            }
        }
        return false;
    }

    public function get results():ArrayCollection {
        return _results;
    }

    public function addResult(res:ProbeResult):void {
        this._results.addItemAt(res, 0);
    }
}
}
