/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.probemanager.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.monitoring.eos.common.osgi.OSGiManager;
import org.ow2.jasmine.monitoring.eos.probemanager.service.JasmineListener;
import org.ow2.jasmine.monitoring.eos.probemanager.service.Probe;
import org.ow2.jasmine.monitoring.eos.probemanager.service.ProbeManagerException;
import org.ow2.jasmine.monitoring.eos.probemanager.service.ProbeOutput;
import org.ow2.jasmine.monitoring.eos.probemanager.service.ProbeTarget;
import org.ow2.jasmine.monitoring.eos.probemanager.service.ProbeTopicProducer;
import org.ow2.jasmine.monitoring.mbeancmd.api.ConsoleOutput;
import org.ow2.jasmine.monitoring.mbeancmd.api.EventswitchOutput;
import org.ow2.jasmine.monitoring.mbeancmd.api.FileOutput;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineOutput;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasminePoll;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineProbe;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineProbeListener;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineProbeManager;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineStat;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineTarget;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeManagerService
implements Serializable {
    private static final long serialVersionUID = 48822803471540481L;
    protected Log logger = LogFactory.getLog(this.getClass());
    protected JasmineListener jasmineListener = null;
    protected ProbeTopicProducer producer = new ProbeTopicProducer();
    protected boolean usembc = true;
    protected JasmineProbeManager probeService = null;

    public ProbeManagerService() {
        this.jasmineListener = new JasmineListener(this.producer);
    }

    public ArrayList<ProbeTarget> getTargets() throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"get Targets", new Object[0]);
        Collection targets = null;
        try {
            targets = probeService.getTargets();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot get list of targets:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot get list of targets: " + e.getMessage());
        }
        this.logger.debug((Object)("found " + targets.size() + " targets"), new Object[0]);
        ArrayList<ProbeTarget> result = new ArrayList<ProbeTarget>();
        for (JasmineTarget jt : targets) {
            result.add(this.newProbeTarget(jt));
        }
        return result;
    }

    public ArrayList<ProbeTarget> newTarget(ProbeTarget target) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"create new target", new Object[0]);
        Collection targets = null;
        try {
            JasmineTarget jt = this.newJasmineTarget(target);
            probeService.createTarget(jt);
            targets = probeService.getTargets();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot create target:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot create target: " + e.getMessage());
        }
        ArrayList<ProbeTarget> result = new ArrayList<ProbeTarget>();
        for (JasmineTarget jt : targets) {
            result.add(this.newProbeTarget(jt));
        }
        return result;
    }

    public ArrayList<ProbeTarget> removeTarget(String name) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"remove target", new Object[0]);
        Collection targets = null;
        try {
            probeService.removeTarget(name);
            targets = probeService.getTargets();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot remove target:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot remove target: " + e.getMessage());
        }
        ArrayList<ProbeTarget> result = new ArrayList<ProbeTarget>();
        for (JasmineTarget jt : targets) {
            result.add(this.newProbeTarget(jt));
        }
        return result;
    }

    public ArrayList<ProbeTarget> modifyTarget(ProbeTarget target) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"modify Target", new Object[0]);
        Collection targets = null;
        try {
            probeService.changeTarget(this.newJasmineTarget(target));
            targets = probeService.getTargets();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot modify Target:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot modify Target: " + e.getMessage());
        }
        ArrayList<ProbeTarget> result = new ArrayList<ProbeTarget>();
        for (JasmineTarget jt : targets) {
            result.add(this.newProbeTarget(jt));
        }
        return result;
    }

    public ArrayList<ProbeOutput> getOutputs() throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"get Outputs", new Object[0]);
        Collection outputs = null;
        try {
            outputs = probeService.getOutputs();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot get list of outputs:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot get list of outputs: " + e.getMessage());
        }
        this.logger.debug((Object)("found " + outputs.size() + " outputs"), new Object[0]);
        ArrayList<ProbeOutput> result = new ArrayList<ProbeOutput>();
        for (JasmineOutput jo : outputs) {
            result.add(this.newProbeOutput(jo));
        }
        return result;
    }

    public ArrayList<ProbeOutput> newOutput(ProbeOutput output) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"create new output", new Object[0]);
        Collection outputs = null;
        try {
            probeService.createOutput(this.newJasmineOutput(output));
            outputs = probeService.getOutputs();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot get list of outputs:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot get list of outputs: " + e.getMessage());
        }
        ArrayList<ProbeOutput> result = new ArrayList<ProbeOutput>();
        for (JasmineOutput jo : outputs) {
            result.add(this.newProbeOutput(jo));
        }
        return result;
    }

    public ArrayList<ProbeOutput> removeOutput(String name) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"remove output", new Object[0]);
        Collection outputs = null;
        try {
            probeService.removeOutput(name);
            outputs = probeService.getOutputs();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot remove output:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot remove output: " + e.getMessage());
        }
        ArrayList<ProbeOutput> result = new ArrayList<ProbeOutput>();
        for (JasmineOutput jo : outputs) {
            result.add(this.newProbeOutput(jo));
        }
        return result;
    }

    public ArrayList<ProbeOutput> modifyOutput(ProbeOutput output) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"modify Output", new Object[0]);
        Collection outputs = null;
        try {
            probeService.changeOutput(this.newJasmineOutput(output));
            outputs = probeService.getOutputs();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot modify Output:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot modify Output: " + e.getMessage());
        }
        ArrayList<ProbeOutput> result = new ArrayList<ProbeOutput>();
        for (JasmineOutput jo : outputs) {
            result.add(this.newProbeOutput(jo));
        }
        return result;
    }

    public ArrayList<Probe> newProbe(Probe probe) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"create new probe", new Object[0]);
        Collection probes = null;
        int id = -1;
        try {
            id = probeService.createProbe(this.newJasmineProbe(probe));
            probes = probeService.getProbes();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot get list of probes:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot get list of probes: " + e.getMessage());
        }
        ArrayList<Probe> result = new ArrayList<Probe>();
        for (JasmineProbe jp : probes) {
            Probe p = this.newProbe(jp);
            p.setSelected(jp.getId() == id);
            result.add(p);
        }
        return result;
    }

    public ArrayList<Probe> getProbes() throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"get Probes", new Object[0]);
        Collection probes = null;
        try {
            probes = probeService.getProbes();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot get list of probes:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot get list of probes: " + e.getMessage());
        }
        this.logger.debug((Object)("found " + probes.size() + " probes"), new Object[0]);
        ArrayList<Probe> result = new ArrayList<Probe>();
        int select = 0;
        for (JasmineProbe jp : probes) {
            Probe p = this.newProbe(jp);
            p.setSelected(select++ == 0);
            result.add(p);
        }
        return result;
    }

    public ArrayList<Probe> removeProbe(int ident) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        Collection probes = null;
        try {
            this.logger.debug((Object)"remove Probe", new Object[0]);
            probeService.removeProbe(new Integer(ident).intValue());
            probes = probeService.getProbes();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot remove Probe:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot remove Probe: " + e.getMessage());
        }
        ArrayList<Probe> result = new ArrayList<Probe>();
        int select = 0;
        for (JasmineProbe jp : probes) {
            Probe p = this.newProbe(jp);
            p.setSelected(select++ == 0);
            result.add(p);
        }
        return result;
    }

    public void startProbe(int ident) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        try {
            this.logger.debug((Object)"start Probe", new Object[0]);
            probeService.startProbe(new Integer(ident).intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot start Probe:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot start Probe: " + e.getMessage());
        }
    }

    public void startAllProbes() throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        try {
            this.logger.debug((Object)"start All Probes", new Object[0]);
            probeService.startAllProbes();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot start Probe:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot start Probe: " + e.getMessage());
        }
    }

    public void stopProbe(int ident) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        try {
            this.logger.debug((Object)"stop Probe", new Object[0]);
            probeService.stopProbe(new Integer(ident).intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot stop Probe:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot stop Probe: " + e.getMessage());
        }
    }

    public void stopAllProbes() throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        try {
            this.logger.debug((Object)"stop All Probes", new Object[0]);
            probeService.stopAllProbes();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot stop Probe:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot stop Probe: " + e.getMessage());
        }
    }

    public ArrayList<Probe> removeAllProbes() throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        Collection probes = null;
        try {
            this.logger.debug((Object)"remove All Probes", new Object[0]);
            probeService.removeAllProbes();
            probes = probeService.getProbes();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot remove Probe:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot remove Probe: " + e.getMessage());
        }
        ArrayList<Probe> result = new ArrayList<Probe>();
        for (JasmineProbe jp : probes) {
            Probe p = this.newProbe(jp);
            result.add(p);
        }
        return result;
    }

    public ArrayList<Probe> modifyProbe(Probe probe) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        Collection probes = null;
        int id = probe.getProbeId();
        try {
            this.logger.debug((Object)"modify Probe", new Object[0]);
            probeService.changeProbe(this.newJasmineProbe(probe));
            probes = probeService.getProbes();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot modify Probe:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot modify Probe: " + e.getMessage());
        }
        ArrayList<Probe> result = new ArrayList<Probe>();
        for (JasmineProbe jp : probes) {
            Probe p = this.newProbe(jp);
            p.setSelected(jp.getId() == id);
            result.add(p);
        }
        return result;
    }

    public ArrayList<Probe> copyProbe(Probe probe) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"copy Probe", new Object[0]);
        Collection probes = null;
        int id = -1;
        try {
            id = probeService.createProbe(this.newJasmineProbe(probe));
            probes = probeService.getProbes();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot copy Probe:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot copy Probe: " + e.getMessage());
        }
        this.logger.debug((Object)("found " + probes.size() + " probes"), new Object[0]);
        ArrayList<Probe> result = new ArrayList<Probe>();
        for (JasmineProbe jp : probes) {
            Probe p = this.newProbe(jp);
            p.setSelected(jp.getId() == id);
            result.add(p);
        }
        return result;
    }

    public void saveConfig() throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)"save configuration", new Object[0]);
        try {
            probeService.saveConfig(null);
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot save configuration:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot save configuration: " + e.getMessage());
        }
    }

    public void startListen(int cmdId) throws ProbeManagerException {
        this.logger.debug((Object)"start listening", new Object[0]);
        try {
            this.jasmineListener.startListening(cmdId);
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot start listening:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot start listening: " + e.getMessage());
        }
    }

    public void stopListen(int cmdId) throws ProbeManagerException {
        this.logger.debug((Object)"stop listening", new Object[0]);
        try {
            this.jasmineListener.stopListening(cmdId);
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot stop listening:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot stop listening: " + e.getMessage());
        }
    }

    public ArrayList<Probe> loadConf(String url) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)("load configuration file: " + url), new Object[0]);
        Collection probes = null;
        try {
            probeService.loadConfig(url);
            probes = probeService.getProbes();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("Cannot load Config:" + e), new Object[0]);
            throw new ProbeManagerException("Cannot load config: " + e.getMessage());
        }
        ArrayList<Probe> result = new ArrayList<Probe>();
        int select = 0;
        for (JasmineProbe jp : probes) {
            Probe p = this.newProbe(jp);
            p.setSelected(select++ == 0);
            result.add(p);
        }
        return result;
    }

    public ArrayList<String> getMBeans(String filter, ProbeTarget target) throws ProbeManagerException {
        JasmineProbeManager probeService = this.getProbeService();
        this.logger.debug((Object)("get Mbeans matching: " + filter), new Object[0]);
        Set mbeans = null;
        try {
            mbeans = probeService.getMBeans(this.newJasmineTarget(target), filter);
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot get mbeans: " + e), new Object[0]);
            throw new ProbeManagerException("Cannot get mbeans: " + e.getMessage());
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ObjectName mbean : mbeans) {
            result.add(mbean.getCanonicalName());
        }
        return result;
    }

    private JasmineProbeManager getProbeService() throws ProbeManagerException {
        if (this.probeService == null) {
            this.logger.debug((Object)"Retrieve JasmineProbeManager", new Object[0]);
            try {
                OSGiManager osgiManager = new OSGiManager();
                BundleContext bctx = osgiManager.getBundleContext();
                ServiceReference sref = bctx.getServiceReference(JasmineProbeManager.class.getName());
                if (sref == null) {
                    this.logger.error((Object)"Cannot get JasmineProbeManager: null service ref", new Object[0]);
                    throw new ProbeManagerException("Cannot get JasmineProbeManager: null service ref");
                }
                this.probeService = (JasmineProbeManager)bctx.getService(sref);
                if (this.probeService == null) {
                    this.logger.error((Object)"Cannot get JasmineProbeManager: null JasmineProbeManager", new Object[0]);
                    throw new ProbeManagerException("Cannot get JasmineProbeManager: null JasmineProbeManager");
                }
                this.probeService.addProbeListener((JasmineProbeListener)this.producer);
            }
            catch (Exception e) {
                throw new ProbeManagerException(e.getMessage());
            }
        }
        return this.probeService;
    }

    private ProbeTarget newProbeTarget(JasmineTarget jt) throws ProbeManagerException {
        ProbeTarget t = new ProbeTarget();
        t.setName(jt.getName());
        t.setUrl(jt.getJmxUrl());
        t.setUser(jt.getUser());
        t.setPassword(jt.getPassword());
        switch (jt.getState()) {
            case 0: {
                t.setState(0);
                break;
            }
            case 1: {
                t.setState(1);
                break;
            }
            case 2: {
                t.setState(2);
            }
        }
        return t;
    }

    private JasmineTarget newJasmineTarget(ProbeTarget t) throws ProbeManagerException {
        JasmineTarget jt = new JasmineTarget();
        jt.setName(t.getName());
        jt.setJmxUrl(t.getUrl());
        jt.setUser(t.getUser());
        jt.setPassword(t.getPassword());
        return jt;
    }

    private ProbeOutput newProbeOutput(JasmineOutput jo) throws ProbeManagerException {
        ProbeOutput o = new ProbeOutput();
        o.setName(jo.getName());
        if (jo instanceof ConsoleOutput) {
            o.setDest(0);
        } else if (jo instanceof FileOutput) {
            FileOutput fjo = (FileOutput)jo;
            o.setDest(2);
            o.setPath(fjo.getPath());
        } else if (jo instanceof EventswitchOutput) {
            EventswitchOutput ejo = (EventswitchOutput)jo;
            o.setDest(1);
            o.setHost(ejo.getHost());
            o.setPort(ejo.getPort());
        }
        return o;
    }

    private JasmineOutput newJasmineOutput(ProbeOutput output) throws ProbeManagerException {
        ConsoleOutput jo = null;
        if (output.getDest() == 0) {
            jo = new ConsoleOutput();
        } else if (output.getDest() == 2) {
            FileOutput fjo = new FileOutput();
            jo = fjo;
            fjo.setPath(output.getPath());
        } else if (output.getDest() == 1) {
            EventswitchOutput ejo = new EventswitchOutput();
            jo = ejo;
            ejo.setHost(output.getHost());
            ejo.setPort(output.getPort());
        }
        jo.setName(output.getName());
        return jo;
    }

    private Probe newProbe(JasmineProbe jp) throws ProbeManagerException {
        Probe p = new Probe();
        p.setProbeId(jp.getId());
        p.setPeriod(jp.getPeriod());
        p.setRefreshPeriod(jp.getRefreshPeriod());
        p.setSeparator(jp.getSeparator());
        if (jp instanceof JasmineStat) {
            this.usembc = true;
            JasmineStat stat = (JasmineStat)jp;
            p.setCmd("stat");
            p.setWhich("name");
            p.setFilter(stat.getFilter());
            if (stat.getAttributes() != null) {
                String args = "";
                for (String attrib : stat.getAttributes()) {
                    args = args + attrib + " ";
                }
                p.setArgs(args.trim());
            }
        } else if (jp instanceof JasminePoll) {
            this.usembc = true;
            JasminePoll poll = (JasminePoll)jp;
            p.setCmd("poll");
            p.setWhich(poll.getWhich());
            p.setFilter(poll.getFilter());
        } else {
            throw new ProbeManagerException("Got unknown type probe");
        }
        if (this.usembc) {
            ArrayList<String> targetId = new ArrayList<String>();
            for (JasmineTarget jt : jp.getTargetList()) {
                targetId.add(jt.getName());
            }
            p.setTargetId(targetId);
        }
        ArrayList<String> outputId = new ArrayList<String>();
        for (JasmineOutput jo : jp.getOutputList()) {
            outputId.add(jo.getName());
        }
        p.setOutputId(outputId);
        switch (jp.getState()) {
            case 3: {
                p.setState(3);
                break;
            }
            case 2: {
                p.setState(2);
                break;
            }
            case 1: {
                p.setState(1);
                break;
            }
            case 0: {
                p.setState(0);
            }
        }
        return p;
    }

    private JasmineProbe newJasmineProbe(Probe probe) throws ProbeManagerException {
        JasmineStat jp = null;
        ArrayList<JasmineTarget> tlist = new ArrayList<JasmineTarget>();
        for (String tid : probe.getTargetId()) {
            JasmineTarget target = this.getProbeService().findTarget(tid);
            if (target == null) {
                this.logger.error((Object)("cannot find target " + tid), new Object[0]);
                continue;
            }
            tlist.add(target);
        }
        ArrayList<JasmineOutput> olist = new ArrayList<JasmineOutput>();
        for (String oid : probe.getOutputId()) {
            JasmineOutput output = this.getProbeService().findOutput(oid);
            if (output == null) {
                this.logger.error((Object)("cannot find output " + oid), new Object[0]);
                continue;
            }
            olist.add(output);
        }
        if (probe.getCmd().equals("stat")) {
            if (this.usembc) {
                JasmineStat stat;
                jp = stat = new JasmineStat();
                stat.setFilter(probe.getFilter());
                ArrayList<String> sattr = new ArrayList<String>();
                StringTokenizer stk = new StringTokenizer(probe.getArgs());
                while (stk.hasMoreTokens()) {
                    String tok = stk.nextToken();
                    sattr.add(tok);
                }
                stat.setAttributes(sattr.toArray(new String[sattr.size()]));
            }
        } else if (probe.getCmd().equals("poll")) {
            if (this.usembc) {
                JasminePoll poll = new JasminePoll();
                jp = poll;
                poll.setFilter(probe.getFilter());
                poll.setWhich(probe.getWhich());
            }
        } else {
            throw new ProbeManagerException("probe type not supported yet: " + probe.getCmd());
        }
        jp.setId(probe.getProbeId().intValue());
        jp.setPeriod(probe.getPeriod());
        jp.setRefreshPeriod(probe.getRefreshPeriod());
        if (this.usembc) {
            jp.setSeparator(probe.getSeparator());
            jp.setTargetList(tlist);
        }
        jp.setOutputList(olist);
        return jp;
    }
}

