/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.probemanager.service;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.jasmine.event.messages.JasmineEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.service.ProbeTopicProducer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JasmineListener
implements MessageListener {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Set<String> probeId = new HashSet<String>();
    protected TopicSubscriber subscriber = null;
    protected TopicSession session = null;
    protected TopicConnection connection = null;
    protected Topic topic = null;
    protected ProbeTopicProducer producer;

    public JasmineListener(ProbeTopicProducer producer) {
        this.producer = producer;
    }

    protected void connect() {
        try {
            InitialContext ictx = new InitialContext();
            TopicConnectionFactory tcf = (TopicConnectionFactory)ictx.lookup("JTCF");
            this.topic = (Topic)ictx.lookup("jasmine");
            this.connection = tcf.createTopicConnection();
            this.session = this.connection.createTopicSession(false, 2);
            this.subscriber = this.session.createSubscriber(this.topic);
            this.subscriber.setMessageListener((MessageListener)this);
            this.connection.start();
        }
        catch (NamingException e) {
            this.logger.error((Object)("cannot lookup jasmine topic: " + e), new Object[0]);
        }
        catch (JMSException e) {
            this.logger.error((Object)("cannot connect to jasmine topic: " + (Object)((Object)e)), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        if (this.connection != null) {
            try {
                if (this.subscriber != null) {
                    this.subscriber.close();
                }
                if (this.session != null) {
                    this.session.close();
                }
                this.connection.close();
            }
            catch (JMSException e) {
                this.logger.error((Object)"cannot disconnect from jasmine topic", new Object[0]);
            }
            finally {
                this.connection = null;
                this.session = null;
                this.topic = null;
                this.subscriber = null;
            }
        }
        this.producer.releaseProbeConnection();
    }

    public void startListening(String id) {
        this.logger.debug((Object)("start listening on jasmine topic for " + id), new Object[0]);
        this.probeId.add(id);
        if (this.connection == null) {
            this.connect();
        }
    }

    public void stopListening(String id) {
        this.logger.debug((Object)("stop listening on jasmine topic for " + id), new Object[0]);
        this.probeId.remove(id);
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                message.acknowledge();
                ObjectMessage om = (ObjectMessage)message;
                Serializable jasmineEventObject = om.getObject();
                if (!(jasmineEventObject instanceof JasmineEvent)) {
                    return;
                }
                JasmineEvent event = (JasmineEvent)jasmineEventObject;
                this.logger.debug((Object)("got a result on jasmine topic for " + event.getProbeId()), new Object[0]);
                if (this.probeId.contains(event.getProbeId())) {
                    this.producer.publishResult(event);
                }
            }
        }
        catch (JMSException e) {
            this.logger.error((Object)("error on message: " + (Object)((Object)e)), new Object[0]);
        }
    }
}

