/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.probemanager.service;

import java.io.Serializable;
import java.util.StringTokenizer;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.ow2.jasmine.event.messages.JasmineEvent;
import org.ow2.jasmine.event.messages.JasmineEventDetails;
import org.ow2.jasmine.monitoring.eos.probemanager.service.ProbeEvent;
import org.ow2.jasmine.monitoring.eos.probemanager.service.ProbeResult;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeListener;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ProbeTopicProducer
implements JasmineProbeListener {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Connection probeconn = null;
    protected Session probesess = null;
    protected Topic probetopic = null;
    protected MessageProducer probeProducer = null;

    public void notifyEvent(JasmineProbe probe) {
        this.logger.debug((Object)("Publish State Change to " + probe.getStatus()), new Object[0]);
        ProbeEvent event = new ProbeEvent(probe.getId(), probe.getStatus(), probe.getError());
        this.sendMessageToTopic(event);
    }

    public void publishResult(JasmineEvent event) {
        this.logger.debug((Object)"publish result on Probe Topic", new Object[0]);
        if (!this.getProducerForProbeTopic()) {
            return;
        }
        try {
            for (JasmineEventDetails detail : event.getEvents()) {
                ProbeResult result = new ProbeResult(event.getProbeId());
                result.setTarget(event.getServer());
                int index = detail.getProbe().lastIndexOf(58);
                String mbean = detail.getProbe().substring(0, index);
                String attrib = detail.getProbe().substring(index + 1);
                result.setAttrname(attrib);
                index = mbean.indexOf("name=");
                if (index >= 0) {
                    String name = mbean.substring(index + 5);
                    StringTokenizer st = new StringTokenizer(name, ":;=, ");
                    result.setMbean(st.nextToken());
                } else {
                    result.setMbean(mbean);
                }
                result.setAttrvalue(detail.getValue());
                result.setTimestamp(detail.getTimestamp());
                ObjectMessage message = this.probesess.createObjectMessage((Serializable)result);
                this.probeProducer.send((Message)message);
            }
        }
        catch (JMSException e) {
            this.logger.warn((Object)("Cannot send message to topic: " + (Object)((Object)e)), new Object[0]);
        }
    }

    public void releaseProbeConnection() {
        if (this.probesess != null) {
            try {
                this.probesess.close();
                this.probesess = null;
            }
            catch (JMSException ignore) {
                // empty catch block
            }
        }
        if (this.probeconn != null) {
            try {
                this.probeconn.close();
                this.probeconn = null;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    private void sendMessageToTopic(Serializable message) {
        if (!this.getProducerForProbeTopic()) {
            return;
        }
        try {
            ObjectMessage objm = this.probesess.createObjectMessage(message);
            this.probeProducer.send((Message)objm);
        }
        catch (JMSException e) {
            this.logger.warn((Object)("Cannot send message to topic: " + (Object)((Object)e)), new Object[0]);
        }
        catch (ClassCastException e) {
            this.logger.warn((Object)("Cannot send message to topic: " + e), new Object[0]);
        }
    }

    private boolean getProducerForProbeTopic() {
        if (this.probeconn == null) {
            this.probesess = null;
            InitialContext ictx = null;
            ConnectionFactory factory = null;
            try {
                ictx = new InitialContext();
                factory = (ConnectionFactory)ictx.lookup("CF");
                this.probeconn = factory.createConnection();
            }
            catch (Exception e) {
                this.logger.error((Object)("Cannot get a connection to send message on topic: " + e), new Object[0]);
                return false;
            }
        }
        if (this.probesess == null) {
            this.probeProducer = null;
            try {
                this.probesess = this.probeconn.createSession(false, 1);
            }
            catch (Exception e) {
                this.logger.error((Object)("Cannot get a Session to send message on topic: " + e), new Object[0]);
                return false;
            }
        }
        if (this.probeProducer == null) {
            try {
                this.probeProducer = this.probesess.createProducer((Destination)this.getProbeTopic());
            }
            catch (Exception e) {
                this.logger.error((Object)("Cannot get a Producer to send message on topic: " + e), new Object[0]);
                return false;
            }
        }
        return true;
    }

    private Topic getProbeTopic() {
        if (this.probetopic == null) {
            InitialContext ictx = null;
            try {
                ictx = new InitialContext();
                this.probetopic = (Topic)ictx.lookup("jasmineProbe");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.probetopic;
    }
}

