/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.eos.probemanager.service;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Instantiate;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.kerneos.core.service.KerneosAsynchronousService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;


@Component
@Instantiate
@Provides
public class AsyncService implements KerneosAsynchronousService {
    private static final Log logger = LogFactory.getLog(AsyncService.class);

    @ServiceProperty(name = KerneosAsynchronousService.ID, value = "asynchProbeManagerService")
    private String id;

    @ServiceProperty(name = KerneosAsynchronousService.TYPE, value = Type.JMS)
    private String type;

    @ServiceProperty(name = "destination-type", value = "Topic")
    private String destinationType;

    @ServiceProperty(name = "connection-factory", value = "JTCF")
    private String connectionFactory;

    @ServiceProperty(name = "destination-jndi-name", value = "jasmineProbe")
    private String destinationJndiName;

    @ServiceProperty(name = "acknowledge-mode", value = "AUTO_ACKNOWLEDGE")
    private String acknowledgeMode;

    @ServiceProperty(name = "transacted-sessions", value = "false")
    private String transactedSessions;

    /**
     * Start
     */
    @Validate
    private void start() {
        logger.info("Start probeManager AsyncService");
    }

    /**
     * Stop
     */
    @Invalidate
    private void stop() {
        logger.info("Stop probeManager AsyncService");
    }
}
