/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.quickvisu.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.JasmineEventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.JMSConnection;
import org.ow2.jasmine.monitoring.eos.common.jms.event.JasmineMessageEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickVisuService
implements Serializable {
    private static final long serialVersionUID = -1254916345191626735L;
    private static Log logger = LogFactory.getLog(QuickVisuService.class);
    private static final String JMS_TOPIC = "jasmine";
    private JMSConnection connection = null;
    private JasmineEventManager manager = new JasmineEventManager();
    private Timer timer = null;
    private static long TIMER = 120000L;

    public void connectTopic() throws Exception {
        if (this.connection == null) {
            this.connection = new JMSConnection((EventManager)this.manager);
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DisconnectTask(), TIMER);
        this.connection.connect(JMS_TOPIC);
    }

    public void disconnectTopic() throws Exception {
        logger.debug((Object)"Disconnecting from the JMS topic...", new Object[0]);
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public List<JasmineMessageEvent> getMessage() {
        this.resetTimer();
        ArrayList<JasmineMessageEvent> list = new ArrayList<JasmineMessageEvent>();
        list.addAll(this.manager.getAll());
        return list;
    }

    private void resetTimer() {
        this.timer.cancel();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DisconnectTask(), TIMER);
    }

    class DisconnectTask
    extends TimerTask {
        DisconnectTask() {
        }

        public void run() {
            try {
                QuickVisuService.this.disconnectTopic();
            }
            catch (Exception e) {
                logger.error((Object)"Failed disconnecting from JMS topic", new Object[]{e});
            }
        }
    }
}

