/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.quickvisu.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.JasmineEventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.JMSConnection;
import org.ow2.jasmine.monitoring.eos.common.jms.event.JasmineMessageEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickVisuService
implements Serializable {
    private static final long serialVersionUID = -1254916345191626735L;
    private static Log logger = LogFactory.getLog(QuickVisuService.class);
    private JMSConnection connection = null;
    private JasmineEventManager manager = new JasmineEventManager();
    private Timer timer = null;
    private static long TIMER = 120000L;

    public int connectTopic() {
        if (this.connection == null) {
            this.connection = new JMSConnection((EventManager)this.manager);
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DisconnectTask(), TIMER);
        return this.connection.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int disconnectTopic() {
        logger.debug((Object)"Disconnecting from the JMS topic...", new Object[0]);
        try {
            if (this.connection == null) {
                int n = -1;
                return n;
            }
            int n = this.connection.disconnect();
            return n;
        }
        finally {
            this.timer.cancel();
        }
    }

    public List<JasmineMessageEvent> getMessage() {
        this.resetTimer();
        ArrayList<JasmineMessageEvent> list = new ArrayList<JasmineMessageEvent>();
        list.addAll(this.manager.getAll());
        return list;
    }

    private void resetTimer() {
        this.timer.cancel();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DisconnectTask(), TIMER);
    }

    class DisconnectTask
    extends TimerTask {
        DisconnectTask() {
        }

        public void run() {
            QuickVisuService.this.disconnectTopic();
        }
    }
}

