/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.rules.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.monitoring.eos.common.osgi.OSGiManager;
import org.ow2.jasmine.rules.manager.model.IRulePackage;
import org.ow2.jasmine.rules.manager.model.textual.ITextualRulePackage;
import org.ow2.jasmine.rules.manager.model.visual.ILHSElement;
import org.ow2.jasmine.rules.manager.model.visual.IRHSElement;
import org.ow2.jasmine.rules.manager.model.visual.IRule;
import org.ow2.jasmine.rules.manager.model.visual.IVisualRulePackage;
import org.ow2.jasmine.rules.manager.model.visual.Rule;
import org.ow2.jasmine.rules.manager.model.visual.VisualRulePackage;
import org.ow2.jasmine.rules.manager.service.DroolsManagerFactory;
import org.ow2.jasmine.rules.manager.service.IDroolsManager;
import org.ow2.jasmine.rules.manager.service.IDroolsManagerFactory;
import org.ow2.jasmine.rules.manager.service.RuleEngineStatus;
import org.ow2.jasmine.rules.manager.service.RulePackageCompilationError;
import org.ow2.jasmine.rules.manager.service.RulePackageSaveReport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleEngineService
implements Serializable {
    private static final long serialVersionUID = 1943812711958376631L;
    private static Log logger = LogFactory.getLog(RuleEngineService.class);
    OSGiManager osgiManager = new OSGiManager();
    IDroolsManagerFactory managerFactory;
    private Map<String, IDroolsManager> droolsManagers = new HashMap<String, IDroolsManager>();

    public void start(String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        ruleEngineManager.start();
    }

    public void stop(String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        ruleEngineManager.stop();
    }

    public RuleEngineStatus getRuleEngineStatus(String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        RuleEngineStatus res = new RuleEngineStatus();
        res.ruleEngineName = ruleEngineName;
        res.engineStatus = ruleEngineManager.getState().toString();
        switch (ruleEngineManager.getState()) {
            case IDLE: {
                res.engineDetails = "The rule engine is available and waiting for rules to run.";
                break;
            }
            case RUNNING: {
                res.engineDetails = "The rule engine is running. ";
                List deployedPackagesNames = ruleEngineManager.getDeployedPackagesNames();
                if (deployedPackagesNames == null) break;
                if (deployedPackagesNames.size() > 1) {
                    res.engineDetails = res.engineDetails + deployedPackagesNames.size() + " packages deployed";
                    break;
                }
                res.engineDetails = res.engineDetails + deployedPackagesNames.size() + " package deployed";
                break;
            }
            case STOPPED: {
                res.engineDetails = "The rule engine is stopped.";
            }
        }
        return res;
    }

    public List<IRulePackage> getRulePackages(String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        IRulePackage[] res = ruleEngineManager.getRulePackages();
        if (res != null) {
            return Arrays.asList(res);
        }
        return new ArrayList<IRulePackage>();
    }

    public IRulePackage getRulePackage(String rulePackageSystemName, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        return ruleEngineManager.getRulePackage(rulePackageSystemName);
    }

    public RulePackageSaveReport saveRulePackage(IRulePackage rulePackage, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        return ruleEngineManager.commitRulePackageChanges(this.rebuildPackage(rulePackage));
    }

    public void deleteRulePackage(IRulePackage rulePackage, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        ruleEngineManager.deleteRulePackage(this.rebuildPackage(rulePackage));
    }

    public List<RulePackageCompilationError> compileRulePackage(IRulePackage rulePackage, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        return ruleEngineManager.checkCompilation(this.rebuildPackage(rulePackage));
    }

    public Boolean checkNameAvailability(String systemName, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        return ruleEngineManager.checkNameAvailability(systemName);
    }

    private IDroolsManager getRuleEngineManager(String ruleEngineName) throws Exception {
        if (!this.droolsManagers.containsKey(ruleEngineName)) {
            try {
                ServiceReference managerFactoryRef = this.osgiManager.getBundleContext().getServiceReference(IDroolsManagerFactory.class.getName());
                this.managerFactory = (DroolsManagerFactory)this.osgiManager.getBundleContext().getService(managerFactoryRef);
                this.droolsManagers.put(ruleEngineName, this.managerFactory.getManager(ruleEngineName));
            }
            catch (Exception e) {
                throw new Exception("Could not connect to the rule engine manager", e);
            }
        }
        return this.droolsManagers.get(ruleEngineName);
    }

    private IRulePackage rebuildPackage(IRulePackage rulePackage) {
        if (rulePackage instanceof ITextualRulePackage) {
            return rulePackage;
        }
        if (rulePackage instanceof IVisualRulePackage) {
            VisualRulePackage convertedRP = new VisualRulePackage();
            convertedRP.setDescription(rulePackage.getDescription());
            convertedRP.setDisplayName(rulePackage.getDisplayName());
            convertedRP.setPreviousSystemName(rulePackage.getPreviousSystemName());
            convertedRP.setRuleEngineInstanceName(rulePackage.getRuleEngineInstanceName());
            convertedRP.setState(rulePackage.getState());
            convertedRP.setSystemName(rulePackage.getSystemName());
            ArrayList<String> convertedImports = new ArrayList<String>();
            for (String importStatement : ((IVisualRulePackage)rulePackage).getImports()) {
                convertedImports.add(importStatement);
            }
            convertedRP.setImports(convertedImports);
            ArrayList<Rule> convertedRules = new ArrayList<Rule>();
            for (IRule rule : ((IVisualRulePackage)rulePackage).getRules()) {
                Rule convertedRule = new Rule();
                convertedRule.setName(rule.getName());
                ArrayList convertedVariables = new ArrayList();
                for (String variable : rule.getVariables()) {
                    convertedImports.add(variable);
                }
                convertedRule.setVariables(convertedVariables);
                ArrayList<ILHSElement> convertedLHS = new ArrayList<ILHSElement>();
                for (ILHSElement lhsElement : rule.getLHS()) {
                    convertedLHS.add(lhsElement);
                }
                convertedRule.setLHS(convertedLHS);
                ArrayList<IRHSElement> convertedRHS = new ArrayList<IRHSElement>();
                for (IRHSElement rhsElement : rule.getRHS()) {
                    convertedRHS.add(rhsElement);
                }
                convertedRule.setRHS(convertedRHS);
                convertedRules.add(convertedRule);
            }
            convertedRP.setRules(convertedRules);
            return convertedRP;
        }
        return null;
    }
}

