/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.rules.common.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.modeler.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExportRulePackagesServlet
extends HttpServlet {
    private static final long serialVersionUID = -4729955174780787192L;
    private final String tempDir = System.getProperty("java.io.tmpdir") + File.separatorChar + "EoS.temp" + File.separatorChar;
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private final String BUNDLE_PROTOTYPE_PATH = "WEB-INF/lib/rules-bundle-prototype.jar";
    private final String BUNDLE_RULES_PATH = "rules/";

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            FileOutputStream dest;
            BufferedInputStream origin;
            res.setContentType("text/xml");
            ServletOutputStream out = res.getOutputStream();
            out.println("<response>");
            File tmpDirFile = new File(this.tempDir);
            tmpDirFile.mkdirs();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String date = dateFormat.format(new Date());
            ArrayList<File> files = new ArrayList<File>();
            Node packages = ExportRulePackagesServlet.ConvertStringToNode(req.getParameter("packages"));
            packages = packages.getFirstChild();
            for (int i = 0; i < packages.getChildNodes().getLength(); ++i) {
                Node drlFile = packages.getChildNodes().item(i);
                File file = new File(this.tempDir + DomUtil.getChild((Node)drlFile, (String)"name").getTextContent() + "_" + date + ".drl");
                FileOutputStream fileOutStream = new FileOutputStream(file);
                fileOutStream.write(DomUtil.getChild((Node)drlFile, (String)"source").getTextContent().getBytes());
                fileOutStream.close();
                files.add(file);
            }
            String targetOutput = req.getParameter("output");
            if (targetOutput.equals("bundle")) {
                File jarFile = new File(this.tempDir + "rules-bundle_" + date + ".jar");
                origin = null;
                dest = new FileOutputStream(jarFile);
                ZipOutputStream jarOut = new ZipOutputStream(new BufferedOutputStream(dest));
                byte[] data = new byte[2048];
                URL protoBundlePath = ((Object)((Object)this)).getClass().getClassLoader().getResource("WEB-INF/lib/rules-bundle-prototype.jar");
                File protoBundle = new File(protoBundlePath.getPath());
                ZipInputStream protoBundleIn = new ZipInputStream(new FileInputStream(protoBundle));
                ZipEntry protoBundleEntry = protoBundleIn.getNextEntry();
                while (protoBundleEntry != null) {
                    int count;
                    jarOut.putNextEntry(new ZipEntry(protoBundleEntry));
                    if (protoBundleEntry.getName().equals("META-INF/MANIFEST.MF")) {
                        ByteArrayOutputStream manifestFile = new ByteArrayOutputStream();
                        while ((count = protoBundleIn.read(data, 0, 2048)) > 0) {
                            manifestFile.write(data, 0, count);
                        }
                        String manifestFileContent = manifestFile.toString();
                        manifestFileContent = manifestFileContent.replaceFirst("Bundle-SymbolicName: ", "Bundle-SymbolicName: " + System.currentTimeMillis());
                        jarOut.write(manifestFileContent.getBytes());
                    } else {
                        while ((count = protoBundleIn.read(data, 0, 2048)) > 0) {
                            jarOut.write(data, 0, count);
                        }
                    }
                    protoBundleEntry = protoBundleIn.getNextEntry();
                }
                protoBundleIn.close();
                for (int i = 0; i < files.size(); ++i) {
                    int count;
                    FileInputStream fi = new FileInputStream((File)files.get(i));
                    origin = new BufferedInputStream(fi, 2048);
                    ZipEntry newEntry = new ZipEntry("rules/" + ((File)files.get(i)).getName());
                    jarOut.putNextEntry(newEntry);
                    while ((count = origin.read(data, 0, 2048)) > 0) {
                        jarOut.write(data, 0, count);
                    }
                    origin.close();
                }
                jarOut.close();
                out.println("<file path=\"" + jarFile.getAbsolutePath() + "\" " + "name=\"" + jarFile.getName() + "\" " + "size=\"" + jarFile.length() / 1024L + "\" " + "/>");
            } else if (files.size() > 1) {
                File zipFile = new File(this.tempDir + "DRL_packages_" + date + ".zip");
                origin = null;
                dest = new FileOutputStream(zipFile);
                ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(dest));
                byte[] data = new byte[2048];
                for (int i = 0; i < files.size(); ++i) {
                    int count;
                    FileInputStream fi = new FileInputStream((File)files.get(i));
                    origin = new BufferedInputStream(fi, 2048);
                    ZipEntry entry = new ZipEntry(((File)files.get(i)).getName());
                    zipOut.putNextEntry(entry);
                    while ((count = origin.read(data, 0, 2048)) != -1) {
                        zipOut.write(data, 0, count);
                    }
                    origin.close();
                }
                zipOut.close();
                out.println("<file path=\"" + zipFile.getAbsolutePath() + "\" " + "name=\"" + zipFile.getName() + "\" " + "size=\"" + zipFile.length() / 1024L + "\" " + "/>");
            } else {
                out.println("<file path=\"" + ((File)files.get(0)).getAbsolutePath() + "\" " + "name=\"" + ((File)files.get(0)).getName() + "\" " + "size=\"" + ((File)files.get(0)).length() / 1024L + "\" " + "/>");
            }
            out.println("</response>");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public static Node ConvertStringToNode(String Str) throws Exception {
        Node result = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder constructeur = factory.newDocumentBuilder();
        StringBuffer Buffer = new StringBuffer(Str);
        ByteArrayInputStream Bis1 = new ByteArrayInputStream(Buffer.toString().getBytes());
        Document document = constructeur.parse(Bis1);
        Element root = document.getDocumentElement();
        result = root.getParentNode();
        return result;
    }
}

