/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.rules.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.monitoring.eos.common.osgi.OSGiManager;
import org.ow2.jasmine.monitoring.eos.rules.common.RuleEngineStatus;
import org.ow2.jasmine.rules.manager.model.IRulePackage;
import org.ow2.jasmine.rules.manager.model.textual.ITextualRulePackage;
import org.ow2.jasmine.rules.manager.model.visual.ILHSElement;
import org.ow2.jasmine.rules.manager.model.visual.IRHSElement;
import org.ow2.jasmine.rules.manager.model.visual.IRule;
import org.ow2.jasmine.rules.manager.model.visual.IVisualRulePackage;
import org.ow2.jasmine.rules.manager.model.visual.LogicalExpression;
import org.ow2.jasmine.rules.manager.model.visual.Rule;
import org.ow2.jasmine.rules.manager.model.visual.VisualRulePackage;
import org.ow2.jasmine.rules.manager.service.DroolsManagerFactory;
import org.ow2.jasmine.rules.manager.service.IDroolsManager;
import org.ow2.jasmine.rules.manager.service.IDroolsManagerFactory;
import org.ow2.jasmine.rules.manager.service.RulePackageCompilationError;
import org.ow2.jasmine.rules.manager.service.RulePackageSaveReport;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleEngineService
implements Serializable {
    private static final long serialVersionUID = 1943812711958376631L;
    private static Log logger = LogFactory.getLog(RuleEngineService.class);
    private final String tempDir = System.getProperty("java.io.tmpdir") + File.separatorChar + "EoS.temp" + File.separatorChar;
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    OSGiManager osgiManager = new OSGiManager();
    IDroolsManagerFactory managerFactory;
    private Map<String, IDroolsManager> droolsManagers = new HashMap<String, IDroolsManager>();

    public void start(String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        ruleEngineManager.start();
    }

    public void stop(String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        ruleEngineManager.stop();
    }

    public RuleEngineStatus getRuleEngineStatus(String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        RuleEngineStatus res = new RuleEngineStatus();
        res.ruleEngineName = ruleEngineName;
        res.engineStatus = ruleEngineManager.getState().toString();
        switch (ruleEngineManager.getState()) {
            case IDLE: {
                break;
            }
            case RUNNING: {
                List deployedPackagesNames = ruleEngineManager.getDeployedPackagesNames();
                if (deployedPackagesNames == null) break;
                res.nbDeployedPackages = deployedPackagesNames.size();
                Iterator it = deployedPackagesNames.iterator();
                int i = 0;
                while (it.hasNext()) {
                    if (i == 0) {
                        res.deployedPackages = (String)it.next();
                    } else {
                        String nextPackage = ", " + (String)it.next();
                        res.deployedPackages.concat(nextPackage);
                    }
                    ++i;
                }
                break;
            }
        }
        return res;
    }

    public List<IRulePackage> getRulePackages(String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        IRulePackage[] res = ruleEngineManager.getRulePackages();
        if (res != null) {
            return Arrays.asList(res);
        }
        return new ArrayList<IRulePackage>();
    }

    public IRulePackage getRulePackage(String rulePackageSystemName, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        return ruleEngineManager.getRulePackage(rulePackageSystemName);
    }

    public RulePackageSaveReport saveRulePackage(IRulePackage rulePackage, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        return ruleEngineManager.commitRulePackageChanges(this.rebuildPackage(rulePackage));
    }

    public void deleteRulePackage(IRulePackage rulePackage, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        ruleEngineManager.deleteRulePackage(this.rebuildPackage(rulePackage));
    }

    public List<RulePackageCompilationError> compileRulePackage(IRulePackage rulePackage, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        return ruleEngineManager.checkCompilation(this.rebuildPackage(rulePackage));
    }

    public Boolean checkNameAvailability(String systemName, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        return ruleEngineManager.checkNameAvailability(systemName);
    }

    public Document exportRulePackagesAsXML(List<IRulePackage> rulePackages, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        File tmpDirFile = new File(this.tempDir);
        tmpDirFile.mkdirs();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String date = dateFormat.format(new Date());
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document fileToDownloadInfo = docBuilder.newDocument();
        Element fileToDownloadInfoNode = fileToDownloadInfo.createElement("file");
        fileToDownloadInfo.appendChild(fileToDownloadInfoNode);
        ArrayList<File> files = new ArrayList<File>();
        for (IRulePackage rulePackage : rulePackages) {
            File file = new File(this.tempDir + rulePackage.getSystemName().substring(rulePackage.getSystemName().lastIndexOf(".") + 1) + "_" + date + ".xml");
            FileOutputStream fileOutStream = new FileOutputStream(file);
            fileOutStream.write(ruleEngineManager.exportRulePackageToXML(this.rebuildPackage(rulePackage)).getBytes());
            fileOutStream.close();
            files.add(file);
        }
        if (files.size() > 1) {
            File zipFile = new File(this.tempDir + "XML_packages_" + date + ".zip");
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(zipFile);
            ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            for (int i = 0; i < files.size(); ++i) {
                int count;
                FileInputStream fi = new FileInputStream((File)files.get(i));
                origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(((File)files.get(i)).getName());
                zipOut.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    zipOut.write(data, 0, count);
                }
                origin.close();
            }
            zipOut.close();
            fileToDownloadInfoNode.setTextContent(zipFile.getAbsolutePath());
            fileToDownloadInfoNode.setAttribute("name", zipFile.getName());
            fileToDownloadInfoNode.setAttribute("size", String.valueOf(zipFile.length() / 1024L));
        } else {
            fileToDownloadInfoNode.setTextContent(((File)files.get(0)).getAbsolutePath());
            fileToDownloadInfoNode.setAttribute("name", ((File)files.get(0)).getName());
            fileToDownloadInfoNode.setAttribute("size", String.valueOf(((File)files.get(0)).length() / 1024L));
        }
        return fileToDownloadInfo;
    }

    public IRulePackage importRulePackageFromXML(String filePath, String ruleEngineName) throws Exception {
        IDroolsManager ruleEngineManager = this.getRuleEngineManager(ruleEngineName);
        StringBuilder fileContent = new StringBuilder();
        BufferedReader input = new BufferedReader(new FileReader(new File(filePath)));
        String line = null;
        while ((line = input.readLine()) != null) {
            fileContent.append(line);
            fileContent.append(System.getProperty("line.separator"));
        }
        input.close();
        return ruleEngineManager.importRulePackageFromXML(fileContent.toString().trim());
    }

    private IDroolsManager getRuleEngineManager(String ruleEngineName) throws Exception {
        if (!this.droolsManagers.containsKey(ruleEngineName)) {
            try {
                ServiceReference managerFactoryRef = this.osgiManager.getBundleContext().getServiceReference(IDroolsManagerFactory.class.getName());
                this.managerFactory = (DroolsManagerFactory)this.osgiManager.getBundleContext().getService(managerFactoryRef);
                this.droolsManagers.put(ruleEngineName, this.managerFactory.getManager(ruleEngineName));
            }
            catch (Exception e) {
                throw new Exception("Could not connect to the rule engine manager", e);
            }
        }
        return this.droolsManagers.get(ruleEngineName);
    }

    private IRulePackage rebuildPackage(IRulePackage rulePackage) {
        if (rulePackage instanceof ITextualRulePackage) {
            return rulePackage;
        }
        if (rulePackage instanceof IVisualRulePackage) {
            VisualRulePackage convertedRP = new VisualRulePackage();
            convertedRP.setDescription(rulePackage.getDescription());
            convertedRP.setDisplayName(rulePackage.getDisplayName());
            convertedRP.setPreviousSystemName(rulePackage.getPreviousSystemName());
            convertedRP.setRuleEngineInstanceName(rulePackage.getRuleEngineInstanceName());
            convertedRP.setState(rulePackage.getState());
            convertedRP.setSystemName(rulePackage.getSystemName());
            ArrayList<String> convertedImports = new ArrayList<String>();
            for (String importStatement : ((IVisualRulePackage)rulePackage).getImports()) {
                convertedImports.add(importStatement);
            }
            convertedRP.setImports(convertedImports);
            ArrayList<Rule> convertedRules = new ArrayList<Rule>();
            for (IRule rule : ((IVisualRulePackage)rulePackage).getRules()) {
                Rule convertedRule = new Rule();
                convertedRule.setName(rule.getName());
                ArrayList convertedVariables = new ArrayList();
                for (String variable : rule.getVariables()) {
                    convertedImports.add(variable);
                }
                convertedRule.setVariables(convertedVariables);
                ArrayList<ILHSElement> convertedLHS = new ArrayList<ILHSElement>();
                for (ILHSElement lhsElement : rule.getLHS()) {
                    convertedLHS.add(this.rebuildLHSElement(lhsElement));
                }
                convertedRule.setLHS(convertedLHS);
                ArrayList<IRHSElement> convertedRHS = new ArrayList<IRHSElement>();
                for (IRHSElement rhsElement : rule.getRHS()) {
                    convertedRHS.add(this.rebuildRHSElement(rhsElement));
                }
                convertedRule.setRHS(convertedRHS);
                convertedRules.add(convertedRule);
            }
            convertedRP.setRules(convertedRules);
            return convertedRP;
        }
        return null;
    }

    private ILHSElement rebuildLHSElement(ILHSElement element) {
        if (element instanceof LogicalExpression) {
            LogicalExpression convertedLogicalExpression = new LogicalExpression();
            convertedLogicalExpression.setOperator(((LogicalExpression)element).getOperator());
            ArrayList<ILHSElement> convertedOperands = new ArrayList<ILHSElement>();
            for (ILHSElement lhsElement : ((LogicalExpression)element).getOperands()) {
                convertedOperands.add(this.rebuildLHSElement(lhsElement));
            }
            convertedLogicalExpression.setOperands(convertedOperands);
            return convertedLogicalExpression;
        }
        return element;
    }

    private IRHSElement rebuildRHSElement(IRHSElement element) {
        return element;
    }
}

