/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.ow2.jasmine.rules.api.DroolsWorkingMemoryState;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemory;

public abstract class AbstractDroolsWorkingMemory
implements IDroolsWorkingMemory {
    private static Logger logger = null;
    protected Thread thread = null;
    private volatile long timeout = 5000L;
    protected File dumpDir;
    protected volatile WorkingMemory workingMemory = null;
    protected final ClassLoader classLoader;
    protected RuleBase ruleBase;
    protected volatile DroolsWorkingMemoryState state;
    protected final PackageBuilderConfiguration pkgBuilderCfg;

    public AbstractDroolsWorkingMemory(ClassLoader classloader, Logger logger) {
        this.classLoader = classloader;
        AbstractDroolsWorkingMemory.logger = logger;
        this.state = DroolsWorkingMemoryState.IDLE;
        this.pkgBuilderCfg = new PackageBuilderConfiguration(this.classLoader);
        JavaDialectConfiguration javaConf = (JavaDialectConfiguration)this.pkgBuilderCfg.getDialectConfiguration("java");
        javaConf.setCompiler(1);
        if (this.dumpDir != null) {
            this.pkgBuilderCfg.setDumpDir(this.dumpDir);
        }
    }

    public void stop() {
        this.stop(DroolsWorkingMemoryState.STOPPED);
    }

    public void stop(DroolsWorkingMemoryState state) {
        if (this.workingMemory != null) {
            this.workingMemory.halt();
        }
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.workingMemory = null;
        this.state = state == DroolsWorkingMemoryState.IDLE || state == DroolsWorkingMemoryState.STOPPED ? state : DroolsWorkingMemoryState.STOPPED;
    }

    public FactHandle insert(Object fact) {
        if (this.state != DroolsWorkingMemoryState.STOPPED && this.workingMemory != null) {
            return this.workingMemory.insert(fact);
        }
        return null;
    }

    public void setDumpDir(File dumpDir) {
        this.dumpDir = dumpDir;
    }

    protected void createWorkingMemory() {
        logger.log(Level.INFO, "Init the Working Memory...");
        this.workingMemory = this.ruleBase.newStatefulSession();
    }

    protected void startRuleExecutor() {
        this.state = DroolsWorkingMemoryState.RUNNING;
        this.thread = new Thread(new RuleExecutor());
        this.thread.start();
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public DroolsWorkingMemoryState getState() {
        return this.state;
    }

    public PackageBuilder getPackageBuilder() throws Exception {
        return new PackageBuilder(this.pkgBuilderCfg);
    }

    private class RuleExecutor
    implements Runnable {
        private RuleExecutor() {
        }

        public void run() {
            Logger logger = Logger.getLogger(this.getClass().getName());
            while (AbstractDroolsWorkingMemory.this.state.equals((Object)DroolsWorkingMemoryState.RUNNING)) {
                try {
                    Thread.sleep(AbstractDroolsWorkingMemory.this.timeout);
                }
                catch (InterruptedException e) {
                    logger.log(Level.INFO, "DroolsWorkingMemory stopped");
                }
                if (AbstractDroolsWorkingMemory.this.workingMemory == null) continue;
                try {
                    logger.log(Level.FINE, "Execute the rules...");
                    AbstractDroolsWorkingMemory.this.workingMemory.fireAllRules();
                }
                catch (FactException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

